<?php
class yith_chkm_pynw {
    public function __construct() {
        if (is_admin()) { // Ensure this only runs in the admin area
            add_action('init', array($this, 'initialize_plugin'));
        }
    }

    public function initialize_plugin() {
        $this->load_yith_plugins();
        add_action('plugins_loaded', array($this, 'disable_yith_license_activation_redirect'));
		add_action('admin_init', array($this,'override_yith_onboarding_queue'), 0);
        add_action('admin_init', array($this, 'remove_plugin_update_hooks'), 100);
		add_action('yith_plugin_fw_panel_enqueue_scripts',array($this,'yith_plugin_fw_panel_enqueue_scripts'),9,1);																										   
    }
	public function disable_yith_license_activation_redirect() {
    remove_action('admin_init', array('YITH_Plugin_Licence_Onboarding', 'handle_redirect'), 5);
}

	public function override_yith_onboarding_queue() {
    set_transient('yith_plugin_licence_onboarding_queue', array(), 1);
}
	 public function yith_plugin_fw_panel_enqueue_scripts($panel){
        remove_action('yith_plugin_fw_panel_enqueue_scripts',[\YITH\PluginUpgrade\Admin\Banner::class,'maybe_enqueue_and_render_licence_banner'],10);
    }

    public function load_yith_plugins() {
                $license_options = get_option('yit_products_licence_activation', array());
				$license_options['yith-woocommerce-checkout-manager'] = $this->prepare_license_data();


        update_option('yit_products_licence_activation', $license_options);
        update_option('yit_plugin_licence_activation', $license_options);
        update_option('yit_theme_licence_activation', $license_options);
    }

    private function prepare_license_data() {
        return array(
            'activated' => true,
            'email' => 'zhaket@poyantheme.ir',
            'licence_key' => '123xxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx',
            'activation_limit' => '1',
            'activation_remaining' => '0',
            'is_membership' => 'true',
            'marketplace' => 'yith',
            'licence_expires' => strtotime('+5 years'),
        );
    }

    public function remove_plugin_update_hooks() {
        if (class_exists('YITH\PluginUpgrade\Upgrade')) {
            remove_action('load-plugins.php', array(YITH\PluginUpgrade\Upgrade::instance(), 'remove_wp_plugin_update_row'), 25);
        }

        if (class_exists('YITH_Plugin_Upgrade')) {
            remove_action('load-plugins.php', array(YITH_Plugin_Upgrade::instance(), 'remove_wp_plugin_update_row'), 25);
        }
    }
}

new yith_chkm_pynw();
