<?php
defined('ABSPATH') || exit('No Access!');

$user_id = get_current_user_id();
$banned_users = $this->options->get_option('banned-users');
$banned_users = $banned_users ? explode(',', $banned_users) : null;
$can_submit = true;
if (is_array($banned_users) && count($banned_users) && in_array($user_id, $banned_users)) {
    $can_submit = false;
}

$labels = new WPAST_Labels_Manager();
$all_url = remove_query_arg(['action', 'ticket-id']);
$ticket_id = $_GET['ticket-id'];
$ticket_manager = new WPAST_Ticket_Manager();
$ticket = $ticket_manager->get_ticket($ticket_id);
if (!$ticket) {
    return;
}

$token = $_GET['token'] ?? null;
$vendor_id = wpast_is_user_seller($user_id) ? $user_id : 0;
if (!$ticket_manager->can_view($ticket_id, $token, $user_id, $vendor_id)) {
    return;
}

$user_data = get_userdata($ticket->creator_id);
$_user_data = get_userdata($ticket->user_id);
$department_manager = new WPAST_Department_Manager();
$department = $department_manager->get_department($ticket->department_id);
$parent_department = $department_manager->get_department($department->parent);
$data_manager = new WPAST_Field_Data_Manager();
$field_data = $data_manager->get_field_data($ticket_id, $user_id);

$header_text = $this->options->get_option('header-text');
$footer_text = $this->options->get_option('footer-text');

$upload_max = $this->options->get_option('upload-max');
$extensions = $this->options->get_option('extensions');

$support_departments = $this->options->get_option('support-departments');

$reply_manager = new WPAST_Reply_Manager($ticket_id);
$replies = $reply_manager->get_replies();

$voice_file = $ticket->voice_file ? explode(',', $ticket->voice_file) : [];
$ath_file = $ticket->ath_file ? explode(',', $ticket->ath_file) : [];
$total_voice = count($voice_file);
$total_ath = count($ath_file);
foreach ($replies as $reply) {
    $reply_voice = $reply->voice_file ? explode(',', $reply->voice_file) : [];
    $reply_ath = $reply->ath_file ? explode(',', $reply->ath_file) : [];

    $total_voice += count($reply_voice);
    $total_ath += count($reply_ath);
}
?>
<div class="wpast-wrap wpast-view-ticket <?php echo isset($_COOKIE['wpast-hide-sidebar']) ? null : 'wpast-show-sibebar'; ?>">
    <header class="wpast-panel-header wpast-clearfix">
        <h4><?php echo $this->labels->get_label('view-ticket'); ?></h4>
        <?php if (is_user_logged_in()): ?>
            <a href="<?php echo $all_url; ?>" class="wpast-all-tickets wpast-btn wpast-btn-primary wpast-btn-small"><?php echo $this->labels->get_label('all-tickets'); ?></a>
        <?php else: ?>
            <a href="<?php echo WPAST_Ticket_Url::tracking(); ?>" class="wpast-ticket-tracking wpast-btn wpast-btn-primary wpast-btn-small"><?php echo $this->labels->get_label('ticket-tracking'); ?></a>
        <?php endif; ?>
    </header>
    <div class="wpast-ticket-title">
        <?php if (is_user_logged_in()): ?>
            <a href="<?php echo $all_url; ?>" class="wpast-all-tickets">
                <img src="<?php echo WPAST_IMG_URL; ?>left-chevron.svg" width="14" height="14" alt="chevron">
            </a>
        <?php else: ?>
            <a href="<?php echo WPAST_Ticket_Url::tracking(); ?>" class="wpast-ticket-tracking">
                <img src="<?php echo WPAST_IMG_URL; ?>left-chevron.svg" width="14" height="14" alt="chevron">
            </a>
        <?php endif; ?>
        <h4>
            <span><?php echo esc_html($ticket->title); ?></span>
            <span class="wpast-ticket-id"><?php echo $this->labels->get_label('ticket-id') . ': ' . $ticket_id; ?></span>
        </h4>
    </div>
    <div class="wpast-row">
        <div class="wpast-main-content wpast-col-12 wpast-col-lg-8">
            <div class="wpast-total-ath wpast-clearfix">
                <span class="wpast-voice">
                    <img src="<?php echo WPAST_IMG_URL; ?>microphone2.svg" width="22" height="22" alt="clip">
                    <?php echo $total_voice; ?>
                </span>
                <span class="wpast-ath">
                    <img src="<?php echo WPAST_IMG_URL; ?>clip.svg" width="22" height="22" alt="clip">
                    <?php echo $total_ath; ?>
                </span>
                <a href="#" id="wpast-sidebar-toggle">
                    <img src="<?php echo WPAST_IMG_URL; ?>sidebar.svg" width="26" height="26" alt="sidebar">
                </a>
            </div>
            <div class="wpast-reply-toggle">
                <a href="#">
                    <img src="<?php echo WPAST_IMG_URL; ?>plus.svg" width="12" height="12" alt="plus">
                    <?php echo $this->labels->get_label('submit-ticket-reply'); ?>
                </a>
            </div>
            <?php if ($ticket->status != 'finished' && $can_submit): ?>
                <form id="wpast-submit-ticket-reply" enctype="multipart/form-data">
                    <input type="hidden" name="ticket-id" value="<?php echo esc_attr($ticket->ID); ?>">
                    <div class="wpast-row">
                        <div class="wpast-content-wrapper wpast-col-12">
                            <div class="wpast-form-group">
                                <label class="wpast-form-label" for="wpast-content"><?php echo $this->labels->get_label('enter-content'); ?></label>
                                <?php if ($this->options->get_option('advanced-editor')): ?>
                                    <?php wp_editor(null, '_content', ['editor_height' => 256]); ?>
                                <?php else: ?>
                                    <textarea class="wpast-form-control" id="wpast-content" name="_content" rows="7"></textarea>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if ($this->options->get_option('voice-message')): ?>
                            <div class="wpast-voice-message-wrapper wpast-col-12">
                                <div class="wpast-form-group">
                                    <?php include(WPAST_TPL_PATH . 'recorder.php'); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ($this->options->get_option('active-upload')): ?>
                            <div class="wpast-upload-wrapper wpast-col-12">
                                <div class="wpast-form-group">
                                    <?php if ($this->options->get_option('advanced-uploader')): ?>
                                        <?php echo $upload_max ? '<div class="wpast-max-size">' . $this->labels->get_label('max-size') . ': ' . $upload_max . ' ' . __('Megabit', 'wpast') . '</div>' : null; ?>
                                        <?php echo $extensions ? '<div class="wpast-extensions">' . $this->labels->get_label('allowed-extensions') . ': ' . str_replace(',', ', ', $extensions) . '</div>' : null; ?>
                                        <div id="wpast-uppy-area"></div>
                                        <input type="hidden" id="wpast_ath_file" name="ath_file" value="">
                                    <?php else: ?>
                                        <div class="wpast-upload">
                                            <?php echo $upload_max ? '<div class="wpast-max-size">' . $this->labels->get_label('max-size') . ': ' . $upload_max . ' ' . __('Megabit', 'wpast') . '</div>' : null; ?>
                                            <?php echo $extensions ? '<div class="wpast-extensions">' . $this->labels->get_label('allowed-extensions') . ': ' . str_replace(',', ', ', $extensions) . '</div>' : null; ?>
                                            <label for="wpast-file" class="wpast-btn wpast-btn-secondary"><?php echo $this->labels->get_label('select-file'); ?></label>
                                            <input type="file" id="wpast-file" name="file">
                                            <div class="wpast-file-name"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="wpast-col-12">
                            <div class="wpast-form-group">
                                <?php if ($vendor_id): ?>
                                    <select class="wpast-custom-select" name="status">
                                        <option value="open"><?php echo esc_html($labels->get_label('open')); ?></option>
                                        <option value="closed"><?php echo esc_html($labels->get_label('closed')); ?></option>
                                        <option value="answered"><?php echo esc_html($labels->get_label('answered')); ?></option>
                                    </select>
                                <?php else: ?>
                                    <label>
                                        <input type="checkbox" class="wpast-checkbox" name="status" value="closed">
                                        <?php echo $this->labels->get_label('close-ticket'); ?>
                                    </label>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="wpast-col-12">
                            <button type="submit" class="wpast-submit wpast-btn wpast-btn-success">
                                <img src="<?php echo WPAST_IMG_URL; ?>send.svg" class="wpast-send" width="26" height="26" alt="send">
                                <?php echo $this->labels->get_label('submit-ticket'); ?>
                                <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="28" height="28" alt="loader">
                            </button>
                        </div>
                    </div>
                </form>
            <?php endif; ?>
            <div class="wpast-ticket wpast-start-ticket <?php echo $ticket->from_admin ? 'wpast-from-admin' : ''; ?>">
                <div class="wpast-ticket-content">
                    <?php
                    if ($header_text && $ticket->from_admin) {
                        echo '<div class="wpast-header-text">' . apply_filters('the_content', $header_text) . '</div>';
                    }
                    echo nl2br($ticket->content);
                    if ($footer_text && $ticket->from_admin) {
                        echo '<div class="wpast-footer-text">' . apply_filters('the_content', $footer_text) . '</div>';
                    }
                    ?>
                    <?php if ($ticket->voice_file): ?>
                        <div class="wpast-voice-file">
                            <?php $voice_file = explode(',', $ticket->voice_file); ?>
                            <?php foreach ($voice_file as $file): ?>
                                <audio src="<?php echo esc_attr($file); ?>" controls></audio>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($ticket->ath_file): ?>
                        <div class="wpast-ath-file">
                            <?php $ath_file = explode(',', $ticket->ath_file); ?>
                            <?php foreach ($ath_file as $file): ?>
                                <a href="<?php echo esc_attr($file); ?>" class="wpast-clearfix" title="<?php echo $this->labels->get_label('download'); ?>" target="_blank">
                                    <span class="wpast-icon"><img src="<?php echo WPAST_IMG_URL; ?>diamond.svg" width="24" height="24" alt="diamond"></span>
                                    <span class="wpast-file-name"><?php echo esc_html(wpast_get_file_name($file)); ?></span>
                                    <img class="wpast-icon-download" src="<?php echo WPAST_IMG_URL; ?>download.svg" width="18" height="18" alt="download">
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="wpast-info">
                    <?php echo wpast_get_avatar($ticket->creator_id); ?>
                    <span class="wpast-creator"><?php echo $user_data ? $user_data->display_name : $ticket->user_name; ?></span>
                    <span class="wpast-date"><?php echo wpast_format_date(strtotime($ticket->create_date)); ?></span>
                </div>
            </div>
            <div class="wpast-replies-title"><span><?php echo $this->labels->get_label('replies'); ?></span></div>
            <?php include(WPAST_TPL_PATH . 'front/replies.php'); ?>
        </div>
        <aside class="wpast-sidabar wpast-col-12 wpast-col-lg-4">
            <?php include(WPAST_TPL_PATH . 'front/rating.php'); ?>
            <div class="wpast-widget-status wpast-widget">
                <?php echo wpast_get_status_html($ticket->status); ?>
                <hr>
                <div class="wpast-time">
                    <img src="<?php echo WPAST_IMG_URL; ?>clock.svg" width="18" height="18" alt="clock">
                    <div>
                        <div class="wpast-date"><?php echo wpast_format_date(strtotime($ticket->create_date)); ?></div>
                        <div class="wpast-reply-date" title="<?php echo wpast_format_date(strtotime($ticket->reply_date)); ?>">
                            <span><?php echo $this->labels->get_label('updated'); ?>: <?php echo wpast_time_ago(strtotime($ticket->reply_date)); ?></span>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="wpast-ticket-priority">
                    <strong><?php echo $this->labels->get_label('priority'); ?>:</strong>
                    <span class="wpast-priority wpast-priority-<?php echo $ticket->priority; ?>"><?php echo $this->labels->get_label($ticket->priority); ?></span>
                </div>
            </div>
            <div class="wpast-widget">
                <div class="wpast-creator">
                    <?php echo wpast_get_avatar($ticket->creator_id, 46); ?>
                    <span><?php echo $user_data ? $user_data->display_name : $ticket->user_name; ?></span>
                </div>
                <?php if (count($field_data)): ?>
                    <hr>
                    <div class="wpast-filed-data">
                        <?php foreach ($field_data as $data): ?>
                            <div class="wpast-field-<?php echo esc_attr($data->ID); ?>">
                                <strong class="wpast-data-label"><?php echo esc_html($data->label); ?></strong>
                                <div class="wpast-data-value">
                                    <?php
                                    if (!is_serialized($data->value)) {
                                        echo esc_html($data->value);
                                    } else {
                                        echo implode(', ', unserialize($data->value));
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if ($ticket->creator_id == $user_id && $ticket->user_id && function_exists('dokan_is_seller_dashboard') && dokan_is_seller_dashboard()): ?>
                <div class="wpast-widget">
                    <div class="wpast-user">
                        <?php echo wpast_get_avatar($ticket->user_id, 28); ?>
                        <span><?php echo $_user_data ? $_user_data->display_name : ''; ?></span>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($ticket->product): ?>
                <div class="wpast-widget">
                    <div class="wpast-product-container">
                        <span><?php echo $this->labels->get_label('product'); ?>: </span>
                        <?php
                        if (intval($ticket->product) && wpast_is_woocommerce_active()) {
                            $orders = new WPAST_Customer_Orders($user_id);
                            $product_id = $ticket->product;
                            $options = $this->options;
                            include(WPAST_TPL_PATH . 'bought-product.php');
                        } else {
                            echo esc_html($ticket->product);
                        }
                        ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="wpast-widget">
                <div class="wpast-ticket-department">
                    <span class="wpast-icon"></span>
                    <span class="wpast-department wpast-department-<?php echo $ticket->department_id; ?>"><?php echo wpast_get_formatted_department($ticket->department_id); ?></span>
                </div>
            </div>
        </aside>
    </div>
</div>