<?php
defined('ABSPATH') || exit('No Access!');

$submit_type = $this->options->get_option('submit-type');
$submit_type = $submit_type ? $submit_type : 'multi';
$default_department = $this->options->get_option('default-department');

$user_id = get_current_user_id();
$banned_users = $this->options->get_option('banned-users');
$banned_users = $banned_users ? explode(',', $banned_users) : null;
if (is_array($banned_users) && count($banned_users) && in_array($user_id, $banned_users)) {
    return;
}

$help_text = $this->options->get_option('help-text');
$fags = $this->options->get_option('fags');
$department_manager = new WPAST_Department_Manager();
$parent_departments = $department_manager->get_parent_departments();
$support_departments = $this->options->get_option('support-departments');
$vendor_submit_departments = $this->options->get_option('vendor-submit-departments');
$blocked_departments = $this->options->get_option('blocked-departments');
$bought_products = wpast_get_bought_products($user_id);
$upload_max = $this->options->get_option('upload-max');
$extensions = $this->options->get_option('extensions');
$site_key = $this->options->get_option('recaptcha-site-key');
$secret_key = $this->options->get_option('recaptcha-secret-key');
$fields_manager = new WPAST_Fields_Manager();
$default_department_desc = $default_department ? $department_manager->get_department($default_department)->description : null;
$default_department_fields = $default_department ? unserialize($department_manager->get_department($default_department)->fields) : [];
?>
<div class="wpast-wrap wpast-submit-ticket">
    <header class="wpast-panel-header wpast-clearfix">
        <h4><?php echo $this->labels->get_label('submit-new-ticket'); ?></h4>
        <?php if (is_user_logged_in()): ?>
            <a href="<?php echo remove_query_arg('action', WPAST_Ticket_Url::all($user_id, false)); ?>" class="wpast-all-tickets wpast-btn wpast-btn-primary wpast-btn-small"><?php echo $this->labels->get_label('all-tickets'); ?></a>
        <?php else: ?>
            <a href="<?php echo WPAST_Ticket_Url::tracking(); ?>" class="wpast-ticket-tracking wpast-btn wpast-btn-primary wpast-btn-small"><?php echo $this->labels->get_label('ticket-tracking'); ?></a>
        <?php endif; ?>
    </header>
    <?php if ($help_text): ?>
        <div class="wpast-help-text"><?php echo apply_filters('the_content', $help_text); ?></div>
    <?php endif; ?>
    <?php if (is_array($fags) && count($fags)): ?>
        <ul class="wpast-fags">
            <?php foreach ($fags as $fag): ?>
                <?php
                if (!strpos($fag, ':')) {
                    continue;
                }
                list($title, $content) = explode(':', $fag);
                ?>
                <li>
                    <h5>
                        <?php echo esc_html($title); ?>
                    </h5>
                    <p><?php echo nl2br($content); ?></p>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if ($submit_type == 'multi'): ?>
        <div style="text-align: center;">
            <a href="#" class="wpast-not-found-answer wpast-btn wpast-btn-success"><?php echo $this->labels->get_label('not-found-answer'); ?></a>
        </div>
    <?php endif; ?>
    <form id="wpast-submit-ticket" class="<?php echo esc_attr($submit_type); ?>-step" enctype="multipart/form-data">
        <div class="wpast-step-1">
            <div class="wpast-row">
                <?php if (is_array($parent_departments) && count($parent_departments)): ?>
                    <?php if ($submit_type != 'child-department'): ?>
                        <div class="wpast-parent-department-wrapper wpast-col-12 wpast-col-lg-6">
                            <div class="wpast-form-group">
                                <label class="wpast-form-label" for="wpast-parent-department"><?php echo $this->labels->get_label('select-department'); ?></label>
                                <select class="wpast-parent-department wpast-custom-select" id="wpast-parent-department">
                                    <option value=""><?php _e('Please select an item.', 'wpast'); ?></option>
                                    <?php foreach ($parent_departments as $parent_department): ?>
                                        <option value="<?php echo esc_attr($parent_department->ID); ?>"><?php echo esc_html($parent_department->name); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="wpast-child-department-wrapper wpast-col-12 wpast-col-lg-6">
                            <div class="wpast-form-group">
                                <label class="wpast-form-label" for="wpast-child-department"><?php echo $this->labels->get_label('select-type'); ?></label>
                                <select class="wpast-child-department wpast-child-department-0 wpast-custom-select" id="wpast-child-department" name="child-department">
                                    <option value=""><?php echo esc_html($this->labels->get_label('select-parent-department')); ?></option>
                                </select>
                                <?php foreach ($parent_departments as $parent_department): ?>
                                    <?php $child_departments = $department_manager->get_child_departments($parent_department->ID); ?>
                                    <?php if (is_array($child_departments) && count($child_departments)): ?>
                                        <select class="wpast-child-department wpast-child-department-<?php echo esc_attr($parent_department->ID); ?> wpast-custom-select" id="wpast-child-department" name="child-department">
                                            <option value=""></option>
                                            <?php foreach ($child_departments as $child_department): ?>
                                                <?php
                                                $_fields = $child_department->fields;
                                                $_fields = $_fields ? unserialize($_fields) : [];
                                                $_fields = implode(',', $_fields);
                                                ?>
                                                <option value="<?php echo esc_attr($child_department->ID); ?>" data-support="<?php echo is_array($support_departments) && in_array($child_department->ID, $support_departments) ? 1 : null; ?>" data-vendor-submit="<?php echo is_array($vendor_submit_departments) && in_array($child_department->ID, $vendor_submit_departments) ? 1 : null; ?>" data-block="<?php echo is_array($blocked_departments) && in_array($child_department->ID, $blocked_departments) ? 1 : null; ?>" data-description="<?php echo esc_attr($child_department->description); ?>" data-fields="<?php echo esc_attr($_fields); ?>"><?php echo esc_html($child_department->name); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php else: ?>
                                        <div class="wpast-child-department wpast-child-department-<?php echo esc_attr($parent_department->ID); ?> wpast-alert wpast-alert-danger">
                                            <p><?php _e('No child departments found! Create child department for all main departments.', 'wpast'); ?></p>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php $child_departments = $department_manager->get_child_departments(); ?>
                        <div class="wpast-child-department-wrapper wpast-col-12">
                            <div class="wpast-form-group">
                                <label class="wpast-form-label" for="wpast-child-department"><?php echo $this->labels->get_label('select-type'); ?></label>
                                <?php if (is_array($child_departments) && count($child_departments)): ?>
                                    <select class="wpast-child-department wpast-custom-select" id="wpast-child-department" name="child-department" style="display: inline-block !important;">
                                        <option value=""></option>
                                        <?php foreach ($child_departments as $child_department): ?>
                                            <?php
                                            $_fields = $child_department->fields;
                                            $_fields = $_fields ? unserialize($_fields) : [];
                                            $_fields = implode(',', $_fields);
                                            ?>
                                            <option value="<?php echo esc_attr($child_department->ID); ?>" data-support="<?php echo is_array($support_departments) && in_array($child_department->ID, $support_departments) ? 1 : null; ?>" data-vendor-submit="<?php echo is_array($vendor_submit_departments) && in_array($child_department->ID, $vendor_submit_departments) ? 1 : null; ?>" data-block="<?php echo is_array($blocked_departments) && in_array($child_department->ID, $blocked_departments) ? 1 : null; ?>" data-description="<?php echo esc_attr($child_department->description); ?>" data-fields="<?php echo esc_attr($_fields); ?>" <?php selected($default_department, $child_department->ID); ?>><?php echo esc_html($child_department->name); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <div class="wpast-child-department wpast-child-department-<?php echo esc_attr($parent_department->ID); ?> wpast-alert wpast-alert-danger">
                                        <p><?php _e('No child departments found! Create child department for all main departments.', 'wpast'); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="wpast-description-wrapper wpast-col-12" <?php echo $default_department_desc ? 'style="display: block;"' : ''; ?>>
                        <div class="wpast-form-group">
                            <div class="wpast-description"><?php echo $default_department_desc ? $default_department_desc : ''; ?></div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="wpast-alert wpast-alert-danger wpast-col-12">
                        <p>
                            <?php _e('No departments found! Create departments first.', 'wpast'); ?>
                            <a href="<?php echo admin_url('admin.php?page=wpast-departments'); ?>"><?php _e('Click here', 'wpast'); ?></a>
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="wpast-step-2">
            <div class="wpast-row">
                <div class="wpast-title-wrapper wpast-col-12">
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-title"><?php echo $this->labels->get_label('enter-title'); ?></label>
                        <input type="text" class="wpast-form-control" id="wpast-title" name="title">
                    </div>
                </div>
                <?php if (wpast_is_showing_field('priority')): ?>
                    <div class="wpast-priority-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-priority"><?php echo $this->labels->get_label('select-priority'); ?></label>
                            <select class="wpast-custom-select" id="wpast-priority" name="priority">
                                <option value="low"><?php echo $this->labels->get_label('low'); ?></option>
                                <option value="medium" selected><?php echo $this->labels->get_label('medium'); ?></option>
                                <option value="high"><?php echo $this->labels->get_label('high'); ?></option>
                            </select>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (function_exists('dokan_is_seller_dashboard') && dokan_is_seller_dashboard()): ?>
                    <div class="wpast-user-wrapper wpast-col-12" <?php echo is_array($vendor_submit_departments) && in_array($default_department, $vendor_submit_departments) ? 'style="display: inline-block;"' : ''; ?>>
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-product"><?php echo $this->labels->get_label('select-user'); ?></label>
                            <div>
                                <input type="text" class="wpast-form-control" id="wpast-user" autocomplete="off">
                                <input type="hidden" name="user">
                                <img class="wpast-loader" src="<?php echo WPAST_IMG_URL; ?>loader.svg" alt="loader" width="18" height="18">
                                <div class="wpast-ajax-results"></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (wpast_is_showing_field('product')): ?>
                    <div class="wpast-product-wrapper wpast-col-12" <?php echo is_array($support_departments) && in_array($default_department, $support_departments) ? 'style="display: inline-block;"' : ''; ?>>
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-product"><?php echo $this->labels->get_label('select-product'); ?></label>
                            <?php if ($this->options->get_option('wc-support')): ?>
                                <select class="wpast-custom-select" id="wpast-product" name="product">
                                    <?php if (!$this->options->get_option('wc-only-customer')): ?>
                                        <option value=""></option>
                                    <?php endif; ?>
                                    <?php if ($bought_products): ?>
                                        <?php foreach ($bought_products as $bought_id): ?>
                                            <?php
                                            $validation = new WPAST_Ticket_Submit_Validation($user_id, $bought_id);
                                            $is_valid = $validation->is_valid();
                                            $support_expired = !$is_valid ? ' (' . $this->labels->get_label('support-expired') . ')' : '';
                                            ?>
                                            <option value="<?php echo $bought_id; ?>" <?php echo !$is_valid ? 'disabled' : ''; ?>><?php echo get_the_title($bought_id) . $support_expired; ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            <?php else: ?>
                                <div>
                                    <input type="text" class="wpast-form-control" id="wpast-product" <?php echo !wpast_is_woocommerce_active() ? 'name="product"' : null; ?> autocomplete="off">
                                    <?php if (wpast_is_woocommerce_active()): ?>
                                        <input type="hidden" name="product">
                                        <img class="wpast-loader" src="<?php echo WPAST_IMG_URL; ?>loader.svg" alt="loader" width="18" height="18">
                                        <div class="wpast-ajax-results"></div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (wpast_is_showing_field('name')): ?>
                    <div class="wpast-name-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-user-name"><?php echo $this->labels->get_label('enter-name'); ?></label>
                            <input type="text" class="wpast-form-control" id="wpast-user-name" name="user-name">
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (wpast_is_showing_field('email')): ?>
                    <div class="wpast-email-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-user-email"><?php echo $this->labels->get_label('enter-email'); ?></label>
                            <input type="email" class="wpast-form-control" id="wpast-user-email" name="user-email">
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (wpast_is_showing_field('mobile')): ?>
                    <div class="wpast-mobile-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-user-mobile"><?php echo $this->labels->get_label('-enter-mobile'); ?></label>
                            <input type="text" class="wpast-form-control" id="wpast-user-mobile" name="user-mobile">
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="wpast-row">
                <?php echo wpast_is_showing_field('fields') ? $fields_manager->render_html($default_department_fields) : null; ?>
                <div class="wpast-content-wrapper wpast-col-12">
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-content"><?php echo $this->labels->get_label('enter-content'); ?></label>
                        <?php if ($this->options->get_option('advanced-editor')): ?>
                            <?php wp_editor(null, '_content', ['editor_height' => 256]); ?>
                        <?php else: ?>
                            <textarea class="wpast-form-control" id="wpast-content" name="_content" rows="10"></textarea>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if ($this->options->get_option('voice-message')): ?>
                    <div class="wpast-voice-message-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <?php include(WPAST_TPL_PATH . 'recorder.php'); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if ($this->options->get_option('active-upload') && wpast_is_showing_field('file')): ?>
                    <div class="wpast-upload-wrapper wpast-col-12">
                        <div class="wpast-form-group">
                            <?php if ($this->options->get_option('advanced-uploader')): ?>
                                <?php echo $upload_max ? '<div class="wpast-max-size">' . $this->labels->get_label('max-size') . ': ' . $upload_max . ' ' . __('Megabit', 'wpast') . '</div>' : null; ?>
                                <?php echo $extensions ? '<div class="wpast-extensions">' . $this->labels->get_label('allowed-extensions') . ': ' . str_replace(',', ', ', $extensions) . '</div>' : null; ?>
                                <div id="wpast-uppy-area"></div>
                                <input type="hidden" id="wpast_ath_file" name="ath_file" value="">
                            <?php else: ?>
                                <div class="wpast-upload">
                                    <?php echo $upload_max ? '<div class="wpast-max-size">' . $this->labels->get_label('max-size') . ': ' . $upload_max . ' ' . __('Megabit', 'wpast') . '</div>' : null; ?>
                                    <?php echo $extensions ? '<div class="wpast-extensions">' . $this->labels->get_label('allowed-extensions') . ': ' . str_replace(',', ', ', $extensions) . '</div>' : null; ?>
                                    <label for="wpast-file" class="wpast-btn wpast-btn-secondary"><?php echo $this->labels->get_label('select-file'); ?></label>
                                    <input type="file" id="wpast-file" name="file">
                                    <div class="wpast-file-name"></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!is_user_logged_in() && $this->options->get_option('guest-ticket') && $site_key && $secret_key): ?>
                    <div class="wpast-col-12">
                        <div class="wpast-form-group">
                            <div class="wpast-g-recaptcha g-recaptcha" data-sitekey="<?php echo esc_attr($site_key); ?>"></div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="wpast-col-12">
                    <button type="submit" class="wpast-submit wpast-btn wpast-btn-success">
                        <img src="<?php echo WPAST_IMG_URL; ?>send.svg" class="wpast-send" width="26" height="26" alt="send">
                        <?php echo $this->labels->get_label('submit-ticket'); ?>
                        <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="28" height="28" alt="loader">
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>