<?php defined('ABSPATH') || exit('No Access!'); ?>
<div class="wpast-replies">
    <?php if (is_array($replies) && count($replies)): ?>
        <?php foreach ($replies as $reply): ?>
            <?php $user__data = get_userdata($reply->creator_id); ?>
            <div class="wpast-ticket wpast-reply-item <?php echo $reply->from_admin ? 'wpast-from-admin' : ''; ?> <?php echo wpast_is_vendor_ticket($ticket, $support_departments, $reply->creator_id) ? 'wpast-from-vendor' : ''; ?>">
                <div class="wpast-ticket-content">
                    <?php
                    if ($header_text && $reply->from_admin) {
                        echo '<div class="wpast-header-text">' . apply_filters('the_content', $header_text) . '</div>';
                    }
                    echo nl2br($reply->content);
                    if ($footer_text && $reply->from_admin) {
                        echo '<div class="wpast-footer-text">' . apply_filters('the_content', $footer_text) . '</div>';
                    }
                    ?>
                    <?php if ($reply->voice_file): ?>
                        <div class="wpast-voice-file">
                            <?php $voice_file = explode(',', $reply->voice_file); ?>
                            <?php foreach ($voice_file as $file): ?>
                                <audio src="<?php echo esc_attr($file); ?>" controls></audio>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($reply->ath_file): ?>
                        <div class="wpast-ath-file">
                            <?php $ath_file = explode(',', $reply->ath_file); ?>
                            <?php foreach ($ath_file as $file): ?>
                                <a href="<?php echo esc_attr($file); ?>" class="wpast-clearfix" title="<?php echo $this->labels->get_label('download'); ?>" target="_blank">
                                    <span class="wpast-icon"><img src="<?php echo WPAST_IMG_URL; ?>diamond.svg" width="24" height="24" alt="diamond"></span>
                                    <span class="wpast-file-name"><?php echo esc_html(wpast_get_file_name($file)); ?></span>
                                    <img class="wpast-icon-download" src="<?php echo WPAST_IMG_URL; ?>download.svg" width="18" height="18" alt="download">
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="wpast-info">
                    <?php echo wpast_get_avatar($reply->creator_id); ?>
                    <span class="wpast-creator"><?php echo $user__data ? $user__data->display_name : ($reply->creator_id == null ? $ticket->user_name : ''); ?></span>
                    <span class="wpast-date"><?php echo wpast_format_date(strtotime($reply->create_date)); ?></span>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>