<?php defined('ABSPATH') || exit('No Access!'); ?>
<?php if ($ticket->active_rating): ?>
    <div class="wpast-rating-widget wpast-widget">
        <?php if ($ticket->rating): ?>
            <p><?php echo $this->labels->get_label('registered-rating'); ?></p>
            <fieldset class="wpast-rating">
                <label class="<?php echo $ticket->rating >= 5 ? 'wpast-active' : null; ?>"></label>
                <label class="<?php echo $ticket->rating >= 4 ? 'wpast-active' : null; ?>"></label>
                <label class="<?php echo $ticket->rating >= 3 ? 'wpast-active' : null; ?>"></label>
                <label class="<?php echo $ticket->rating >= 2 ? 'wpast-active' : null; ?>"></label>
                <label class="<?php echo $ticket->rating >= 1 ? 'wpast-active' : null; ?>"></label>
            </fieldset>
        <?php else: ?>
            <p><?php echo $this->labels->get_label('help-us-rating'); ?></p>
            <form id="wpast-submit-rating">
                <input type="hidden" name="ticket-id" value="<?php echo esc_attr($ticket_id); ?>">
                <fieldset class="wpast-rating">
                    <input type="radio" id="wpast-star5" name="rating" value="5">
                    <label for="wpast-star5" title="5 <?php echo $this->labels->get_label('star'); ?>"></label>
                    <input type="radio" id="wpast-star4" name="rating" value="4">
                    <label for="wpast-star4" title="4 <?php echo $this->labels->get_label('star'); ?>"></label>
                    <input type="radio" id="wpast-star3" name="rating" value="3">
                    <label for="wpast-star3" title="3 <?php echo $this->labels->get_label('star'); ?>"></label>
                    <input type="radio" id="wpast-star2" name="rating" value="2">
                    <label for="wpast-star2" title="2 <?php echo $this->labels->get_label('star'); ?>"></label>
                    <input type="radio" id="wpast-star1" name="rating" value="1">
                    <label for="wpast-star1" title="1 <?php echo $this->labels->get_label('star'); ?>"></label>
                </fieldset>
                <button type="submit" class="wpast-submit wpast-btn wpast-btn-warning">
                    <?php echo $this->labels->get_label('register-rating'); ?>
                    <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="28" height="28" alt="loader">
                </button>
            </form>
        <?php endif; ?>
    </div>
<?php endif; ?>