<?php
defined('ABSPATH') || exit('No Access!');

$site_key = $this->options->get_option('recaptcha-site-key');
$secret_key = $this->options->get_option('recaptcha-secret-key');
$fields = $this->options->get_option('fields');
?>
<div class="wpast-wrap">
    <div class="wpast-row">
        <div class="wpast-col-12 wpast-col-lg-6" style="margin: auto;">
            <form class="wpast-login-form">
                <h4 class="wpast-login-title"><?php echo $this->labels->get_label('login-title'); ?></h4>
                <div class="wpast-inner">
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-username"><?php echo $this->labels->get_label('username-email'); ?></label>
                        <input type="text" class="wpast-form-control" id="wpast-username" name="username">
                    </div>
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-password"><?php echo $this->labels->get_label('password'); ?></label>
                        <input type="password" class="wpast-form-control" id="wpast-password" name="password">
                    </div>
                    <div class="wpast-form-group">
                        <input type="checkbox" class="wpast-checkbox" id="wpast-remember-me" name="remember-me">
                        <label for="wpast-remember-me"><?php echo $this->labels->get_label('remember-me'); ?></label>
                    </div>
                    <?php if ($site_key && $secret_key): ?>
                        <div class="wpast-form-group">
                            <div class="wpast-g-recaptcha g-recaptcha" id="login-recaptcha" data-sitekey="<?php echo esc_attr($site_key); ?>"></div>
                        </div>
                    <?php endif; ?>
                    <button type="submit" class="wpast-login wpast-btn wpast-btn-success">
                        <?php echo $this->labels->get_label('login'); ?>
                        <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="28" height="28" alt="loader">
                    </button>
                </div>
                <div class="wpast-login-footer">
                    <a href="#" class="wpast-toggle-login" data-toggle="wpast-register-form"><?php echo $this->labels->get_label('register-title'); ?></a>
                </div>
            </form>
            <form class="wpast-register-form">
                <h4 class="wpast-login-title"><?php echo $this->labels->get_label('register-title'); ?></h4>
                <div class="wpast-inner">
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-username2"><?php echo $this->labels->get_label('username'); ?></label>
                        <input type="text" class="wpast-form-control" id="wpast-username2" name="username">
                    </div>
                    <?php if (isset($fields['email']['register'])): ?>
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-email"><?php echo $this->labels->get_label('email'); ?></label>
                            <input type="text" class="wpast-form-control" id="wpast-email" name="email">
                        </div>
                    <?php endif; ?>
                    <?php if (isset($fields['mobile']['register'])): ?>
                        <div class="wpast-form-group">
                            <label class="wpast-form-label" for="wpast-mobile"><?php echo $this->labels->get_label('mobile'); ?></label>
                            <input type="text" class="wpast-form-control" id="wpast-mobile" name="mobile" placeholder="09123456789">
                        </div>
                    <?php endif; ?>
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-password2"><?php echo $this->labels->get_label('password'); ?></label>
                        <input type="password" class="wpast-form-control" id="wpast-password2" name="password">
                    </div>
                    <div class="wpast-form-group">
                        <label class="wpast-form-label" for="wpast-confirm-password"><?php echo $this->labels->get_label('confirm-password'); ?></label>
                        <input type="password" class="wpast-form-control" id="wpast-confirm-password" name="confirm-password">
                    </div>
                    <?php if ($site_key && $secret_key): ?>
                        <div class="wpast-form-group">
                            <div class="wpast-g-recaptcha g-recaptcha" id="register-recaptcha" data-sitekey="<?php echo esc_attr($site_key); ?>"></div>
                        </div>
                    <?php endif; ?>
                    <button type="submit" class="wpast-register wpast-btn wpast-btn-success">
                        <?php echo $this->labels->get_label('register'); ?>
                        <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="28" height="28" alt="loader">
                    </button>
                </div>
                <div class="wpast-login-footer">
                    <a href="#" class="wpast-toggle-login" data-toggle="wpast-login-form"><?php echo $this->labels->get_label('login-title'); ?></a>
                </div>
            </form>
        </div>
    </div>
</div>