<?php
defined('ABSPATH') || exit('No Access!');

$user_id = get_current_user_id();
$page_id = get_the_ID();
$statuses = wpast_get_statuses();

$ticket_manager = new WPAST_Ticket_Manager();
$type = $_GET['_type'] ?? 'all';
$status = $_GET['status'] ?? 'all';
$page_num = $_GET['page-number'] ?? 1;
$orderby = $_GET['orderby'] ?? ($this->options->get_option('orderby') ?? 'last-reply');
$vendor_id = wpast_is_user_seller($user_id) ? $user_id : 0;
$tickets = $ticket_manager->get_tickets($user_id, $vendor_id, $type, $status, $orderby, $page_num);
$total_count = $ticket_manager->found_tickets($user_id, $vendor_id, $type, $status);
?>
<div class="wpast-wrap wpast-all-tickets">
    <header class="wpast-panel-header wpast-clearfix">
        <h4><?php echo $this->labels->get_label('all-tickets'); ?></h4>

        <a href="<?php echo WPAST_Ticket_Url::new($user_id, false); ?>" class="wpast-new-ticket wpast-btn wpast-btn-success wpast-btn-small"><?php echo $this->labels->get_label('submit-new-ticket'); ?></a>
    </header>
    <div class="wpast-statues-box">
        <div class="wpast-row">
            <?php foreach ($statuses as $__status): ?>
                <div class="wpast-status-item wpast-status-item-<?php echo esc_attr($__status['slug']); ?> wpast-col">
                    <div>
                        <div class="wpast-status-icon">
                            <img src="<?php echo WPAST_IMG_URL; ?>ticket.svg" width="32" height="32" alt="ticket">
                            <span style="background: <?php echo esc_attr($__status['color']); ?>;"></span>
                        </div>
                        <div class="wpast-status-name"><?php echo esc_html($__status['name']); ?></div>
                        <div class="wpast-status-count" style="color: <?php echo esc_attr($__status['color']); ?>;"><?php echo esc_html(number_format($ticket_manager->found_tickets($user_id, $vendor_id, null, $__status['slug']))); ?></div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="wpast-status-item wpast-status-item-all wpast-col">
                <div>
                    <div class="wpast-status-icon">
                        <img src="<?php echo WPAST_IMG_URL; ?>ticket.svg" width="32" height="32" alt="ticket">
                    </div>
                    <div class="wpast-status-name"><?php echo $this->labels->get_label('all'); ?></div>
                    <div class="wpast-status-count"><?php echo esc_html($ticket_manager->found_tickets($user_id, $vendor_id)); ?></div>
                </div>
            </div>
        </div>
    </div>
    <div class="wpast-filter-container wpast-clearfix">
        <span class="wpast-total-count"><?php echo sprintf($this->labels->get_label('showing-tickets'), esc_html($total_count)); ?></span>
        <form id="wpast-filter" method="get" action="">
            <select class="wpast-ticket-type wpast-custom-select" name="_type">
                <option value="all"><?php echo $this->labels->get_label('all') . ' (' . $ticket_manager->found_tickets($user_id, $vendor_id) . ')'; ?></option>
                <?php if (wpast_is_user_seller($user_id)): ?>
                    <option value="customers" <?php selected($type, 'customers'); ?>><?php echo $this->labels->get_label('customers') . ' (' . $ticket_manager->found_tickets($user_id, $vendor_id, 'customers') . ')'; ?></option>
                <?php endif; ?>
                <option value="sent" <?php selected($type, 'sent'); ?>><?php echo $this->labels->get_label('sent') . ' (' . $ticket_manager->found_tickets($user_id, $vendor_id, 'sent') . ')'; ?></option>
                <option value="received" <?php selected($type, 'received'); ?>><?php echo $this->labels->get_label('received') . ' (' . $ticket_manager->found_tickets($user_id, $vendor_id, 'received') . ')'; ?></option>
            </select>
            <select class="wpast-ticket-status wpast-custom-select" name="status">
                <option value="all"><?php echo $this->labels->get_label('all') . ' (' . $ticket_manager->found_tickets($user_id, $vendor_id) . ')'; ?></option>
                <?php foreach ($statuses as $_status): ?>
                    <option value="<?php echo esc_attr($_status['slug']); ?>" <?php selected($status, $_status['slug']); ?>><?php echo esc_html($_status['name']) . ' (' . esc_html($ticket_manager->found_tickets($user_id, $vendor_id, null, $_status['slug'])) . ')'; ?></option>
                <?php endforeach; ?>
            </select>
            <select class="wpast-orderby wpast-custom-select" name="orderby">
                <option value="reply-date" <?php selected($orderby, 'reply-date'); ?>><?php echo $this->labels->get_label('reply-date'); ?></option>
                <option value="create-date" <?php selected($orderby, 'create-date'); ?>><?php echo $this->labels->get_label('create-date'); ?></option>
            </select>
            <input type="submit" class="wpast-filter wpast-btn wpast-btn-secondary" value="<?php echo $this->labels->get_label('filter'); ?>">
        </form>
    </div>
    <?php if (is_array($tickets) && count($tickets)): ?>
        <div class="wpast-tickets-list">
            <?php foreach ($tickets as $ticket): ?>
                <?php $replies = count((new WPAST_Reply_Manager($ticket->ID))->get_replies()); ?>
                <div class="wpast-ticket-item" id="wpast-ticket-<?php echo esc_attr($ticket->ID); ?>" style="<?php echo is_rtl() ? 'border-right-color' : 'border-left-color'; ?>: <?php echo esc_attr(wpast_get_status_color($ticket->status)); ?>">
                    <?php if ($this->options->get_option('tickets-list-title') || $this->options->get_option('tickets-list-department') || $this->options->get_option('tickets-list-rating')): ?>
                        <div class="wpast-item-title">
                            <div class="wpast-item-inner">
                                <?php if ($this->options->get_option('tickets-list-title')): ?>
                                    <a href="<?php echo WPAST_Ticket_Url::view($ticket->ID, null, $user_id, false); ?>" class="wpast-ticket-title"><?php echo esc_html($ticket->title); ?></a>
                                <?php endif; ?>
                                <div>
                                    <?php if ($this->options->get_option('tickets-list-department')): ?>
                                        <div class="wpast-ticket-department">
                                            <img src="<?php echo WPAST_IMG_URL; ?>menu.svg" width="12" height="12" alt="menu">
                                            <?php echo wpast_get_formatted_department($ticket->department_id, false); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ($this->options->get_option('tickets-list-rating')): ?>
                                        <span class="wpast-rating <?php echo $ticket->rating ? 'wpast-active' : null; ?>" <?php echo $ticket->rating ? 'title="' . esc_attr($ticket->rating) . '"' : null; ?>></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->options->get_option('tickets-list-user')): ?>
                        <div class="wpast-item-user">
                            <div class="wpast-item-inner">
                                <?php if ($this->options->get_option('tickets-list-user')): ?>
                                    <?php
                                    $user_data = get_userdata($ticket->creator_id);
                                    echo wpast_get_avatar($ticket->creator_id, 36);
                                    echo $user_data ? '<span class="wpast-creator">' . $user_data->display_name . '</span>' : null;
                                    ?>
                                    <?php if ($this->options->get_option('tickets-list-replies')): ?>
                                        <div class="wpast-reply-count wpast-reply-<?php echo $replies; ?>">
                                            <img src="<?php echo WPAST_IMG_URL; ?>message.svg" width="20" height="20" alt="message">
                                            <?php if ($replies > 0): ?>
                                                <span><?php echo $replies; ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->options->get_option('tickets-list-product')): ?>
                        <div class="wpast-item-product">
                            <div class="wpast-item-inner">
                                <?php
                                if (intval($ticket->product) && wpast_is_woocommerce_active()) {
                                    echo '<a href="' . get_permalink($ticket->product) . '" target="_blank">' . get_the_title($ticket->product) . '</a>';
                                } else {
                                    echo $ticket->product ? esc_html($ticket->product) : '__';
                                }
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->options->get_option('tickets-list-status')): ?>
                        <div class="wpast-item-status">
                            <div class="wpast-item-inner">
                                <?php echo wpast_get_status_html($ticket->status); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->options->get_option('tickets-list-date')): ?>
                        <div class="wpast-item-date">
                            <div class="wpast-item-inner">
                                <div class="wpast-date"><?php echo wpast_format_date(strtotime($ticket->create_date)); ?></div>
                                <div class="wpast-reply-date" title="<?php echo wpast_format_date(strtotime($ticket->reply_date)); ?>">
                                    <span><?php echo wpast_time_ago(strtotime($ticket->reply_date)); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->options->get_option('tickets-list-actions')): ?>
                        <div class="wpast-item-actions">
                            <div class="wpast-item-inner">
                                <a href="<?php echo WPAST_Ticket_Url::view($ticket->ID, null, $user_id, false); ?>" class="wpast-btn wpast-btn-secondary wpast-btn-small"><?php echo esc_html($this->labels->get_label('view-ticket')); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
        $per_page = $this->options->get_option('per-page');
        $per_page = $per_page ? esc_sql($per_page) : 10;
        $big = 999999999;
        $args = array(
            'base' => preg_replace('/\?.*/', '', get_pagenum_link()) . '%_%',
            'format' => '?page-number=%#%',
            'total' => ceil($total_count / $per_page),
            'current' => max(1, $page_num),
            'show_all' => false,
            'prev_next' => false,
            'type' => 'list',
        );
        echo paginate_links($args);
        ?>
    <?php else: ?>
        <div class="wpast-alert wpast-alert-danger">
            <p><?php echo $this->labels->get_label('no-item'); ?></p>
        </div>
    <?php endif; ?>
</div>