<?php
defined('ABSPATH') || exit('No Access!');

$product = wc_get_product($product_id);
if ($product) {
    if (is_admin()) {
        $product_url = get_edit_post_link($product_id);
    } else {
        $product_url = get_permalink($product_id);
        if ($product->get_type() == 'variation') {
            $product_url = get_permalink($product->get_parent_id());
        }
    }
    $validation = new WPAST_Ticket_Submit_Validation($user_id, $product_id);
    $expire_days = $validation->check_expire_days();
    $max_count = $validation->check_max_count();
    $extension_expire_days = get_post_meta($product_id, 'wpast_product_extension_expire_days', true);
    $extension_max_count = get_post_meta($product_id, 'wpast_product_extension_max_count', true);
    $extension_amount = get_post_meta($product_id, 'wpast_product_extension_amount', true);
    ?>
    <div class="wpast-product">
        <?php echo wpast_get_product_image($product); ?>
        <a href="<?php echo $product_url; ?>" class="wpast-product-title" target="_blank"><?php echo $product->get_name(); ?></a>
    </div>
    <div class="wpast-clearfix"></div>
    <div class="wpast-support-info">
        <div class="wpast-purchase-date">
            <?php echo '<span>' . $labels->get_label('purchase-date') . ': </span>' . '<span>' . wpast_format_date($orders->get_purchase_date($product_id)) . '</span>'; ?>
        </div>
        <span class="wpast-pipe">|</span>
        <div class="wpast-expire-date">
            <?php
            echo '<span>' . $labels->get_label('expire-date') . ': </span>';
            if ($expire_days === 1) {
                echo '<span>' . $labels->get_label('unlimited') . '</span>';
            } else {
                if ($expire_days > 0) {
                    echo '<span>' . wpast_format_date(time() + $expire_days) . '</span>';
                } else {
                    echo '<span>' . $labels->get_label('support-expired') . '</span>';
                }
            }
            ?>
        </div>
        <span class="wpast-pipe">|</span>
        <div class="wpast-max-count">
            <?php
            echo '<span>' . $labels->get_label('remaining-count') . ': </span>';
            if ($max_count === true) {
                echo '<span>' . $labels->get_label('unlimited') . '</span>';
            } else {
                echo $max_count > 0 ? '<span>' . number_format($max_count) . '</span>' : '<span>0</span>';
            }
            ?>
        </div>
        <?php if (!is_admin() && $options->get_option('wc-support') && $options->get_option('wc-extension') && !$validation->is_valid() && (($extension_expire_days || $extension_max_count) && $extension_amount)): ?>
            <a href="#" class="wpast-extension wpast-btn wpast-btn-small wpast-btn-success" data-pid="<?php echo esc_attr($product_id); ?>">
                <img src="<?php echo WPAST_IMG_URL; ?>oval.svg" class="wpast-loader" width="16" height="16" alt="loader">
                <?php echo $labels->get_label('extension'); ?>
            </a>
        <?php endif; ?>
    </div>
<?php }