<?php
defined('ABSPATH') || exit('No Access!');

$page = $_REQUEST['page'] ?? null;
$s = $_REQUEST['s'] ?? null;
$creator_id = $_REQUEST['creator-id'] ?? null;
$department_id = $_REQUEST['department-id'] ?? null;
$status = $_REQUEST['status'] ?? null;
$priority = $_REQUEST['priority'] ?? null;
$product = $_REQUEST['product'] ?? null;
$vendor_id = $params['vendor-id'] ?? ($_REQUEST['vendor-id'] ?? null);
$start_date = $params['start-date'] ?? ($_REQUEST['start-date'] ?? null);
$end_date = $params['end-date'] ?? ($_REQUEST['end-date'] ?? null);

$department_manager = new WPAST_Department_Manager();
$parent_departments = $department_manager->get_parent_departments();
?>
<div class="wpast-tickets wrap">
    <h1 class="wp-heading-inline"><?php _e('Tickets', 'wpast'); ?></h1>
    <a href="?page=wpast-submit-ticket" class="page-title-action"><?php _e('Submit new ticket', 'wpast'); ?></a>
    <a href="?page=wpast-tickets&action=wpast-exporter" class="page-title-action"><?php _e('Export', 'wpast'); ?></a>
    <?php if ($s): ?>
        <span class="subtitle"><?php _e('Search results for', 'wpast'); ?> “<?php echo esc_html($s); ?>”</span>
    <?php endif; ?>
    <hr class="wp-header-end">
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <div id="post-body-content">
                <div class="meta-box-sortables ui-sortable">
                    <ul class="subsubsub">
                        <li class="all">
                            <a href="admin.php?page=wpast-tickets" class="<?php echo !$status ? 'current' : null; ?>">
                                <?php _e('All', 'wpast'); ?>
                                <span class="count">(<?php echo $this->tickets_object->record_count(['status' => 'all']); ?>)</span>
                            </a>
                        </li>
                        <?php foreach ($this->statuses as $_status): ?>
                            <li class="<?php echo esc_attr($_status['slug']); ?>">
                                <span> | </span>
                                <a href="admin.php?page=wpast-tickets&status=<?php echo esc_attr($_status['slug']); ?>" class="<?php echo $status == $_status['slug'] ? 'current' : null; ?>">
                                    <?php echo esc_html($_status['name']); ?>
                                    <span class="count">(<?php echo $this->tickets_object->record_count(['status' => $_status['slug']]); ?>)</span>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <br class="clear">
                    <form method="get">
                        <div class="filter-box">
                            <?php wp_nonce_field('filter_security', 'filter_nonce', false); ?>
                            <input type="hidden" name="page" value="<?php echo $page; ?>">
                            <?php if ($creator_id): ?>
                                <input type="hidden" name="creator-id" value="<?php echo esc_attr($creator_id); ?>">
                            <?php endif; ?>
                            <?php if ($department_id): ?>
                                <input type="hidden" name="department-id" value="<?php echo esc_attr($department_id); ?>">
                            <?php endif; ?>
                            <?php if ($status): ?>
                                <input type="hidden" name="status" value="<?php echo esc_attr($status); ?>">
                            <?php endif; ?>
                            <?php if ($priority): ?>
                                <input type="hidden" name="priority" value="<?php echo esc_attr($priority); ?>">
                            <?php endif; ?>
                            <?php if ($product): ?>
                                <input type="hidden" name="product" value="<?php echo esc_attr($product); ?>">
                            <?php endif; ?>
                            <select name="department-id">
                                <option value=""><?php _e('All departments', 'wpast'); ?></option>
                                <?php if (count($parent_departments)): ?>
                                    <?php foreach ($parent_departments as $parent_department): ?>
                                        <optgroup label="<?php echo esc_attr($parent_department->name); ?>">
                                            <?php $child_departments = $department_manager->get_child_departments($parent_department->ID); ?>
                                            <?php if (count($child_departments)): ?>
                                                <?php foreach ($child_departments as $child_department): ?>
                                                    <option value="<?php echo esc_attr($child_department->ID); ?>" <?php selected($department_id, $child_department->ID); ?>><?php echo esc_html($child_department->name) . ' (' . $this->tickets_object->record_count(['department-id' => $child_department->ID]); ?>
                                                        )
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </optgroup>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <select name="priority">
                                <option value=""><?php _e('All priorities', 'wpast'); ?></option>
                                <option value="low" <?php selected($priority, 'low'); ?>><?php echo __('Low', 'wpast') . ' (' . $this->tickets_object->record_count(['priority' => 'low']); ?>
                                    )
                                </option>
                                <option value="medium" <?php selected($priority, 'medium'); ?>><?php echo __('Medium', 'wpast') . ' (' . $this->tickets_object->record_count(['priority' => 'medium']); ?>
                                    )
                                </option>
                                <option value="high" <?php selected($priority, 'high'); ?>><?php echo __('High', 'wpast') . ' (' . $this->tickets_object->record_count(['priority' => 'high']); ?>
                                    )
                                </option>
                            </select>
                            <select id="wpast-creator-id" name="creator-id">
                                <?php
                                if ($creator_id) {
                                    $user_data = get_userdata($creator_id);
                                    echo '<option value="' . esc_attr($creator_id) . '" selected>' . $user_data->user_login . '</option>';
                                }
                                ?>
                            </select>
                            <?php if (wpast_is_woocommerce_active()): ?>
                                <select id="wpast-product" name="product">
                                    <?php
                                    if ($product) {
                                        echo '<option value="' . esc_attr($product) . '" selected>' . get_the_title($product) . '</option>';
                                    }
                                    ?>
                                </select>
                            <?php else: ?>
                                <input type="text" id="wpast-product" name="product" value="<?php echo esc_attr($product); ?>" placeholder="<?php _e('Product', 'wpast'); ?>">
                            <?php endif; ?>
                            <?php if (wpast_is_dokan_active()): ?>
                                <select id="wpast-vendor-id" name="vendor-id">
                                    <?php
                                    if ($vendor_id) {
                                        $vendor_data = get_userdata($vendor_id);
                                        echo '<option value="' . esc_attr($vendor_id) . '" selected>' . $vendor_data->user_login . '</option>';
                                    }
                                    ?>
                                </select>
                            <?php endif; ?>
                            <input type="text" class="wpast-datepicker" name="start-date" value="<?php echo esc_attr($start_date); ?>" placeholder="<?php _e('Start date', 'wpast'); ?>" autocomplete="off">
                            <input type="text" class="wpast-datepicker" name="end-date" value="<?php echo esc_attr($end_date); ?>" placeholder="<?php _e('End date', 'wpast'); ?>" autocomplete="off">
                            <input type="search" name="s" value="<?php echo $s; ?>" placeholder="<?php _e('Search', 'wpast'); ?>">
                            <input type="submit" id="search-submit" class="button" value="<?php _e('Filter', 'wpast'); ?>">
                        </div>
                    </form>
                    <?php if ($status == 'trash'): ?>
                        <form method="post" onsubmit="return wpast_validate(this);">
                            <?php wp_nonce_field('delete_all_security', 'delete_all_nonce', false); ?>
                            <input type="submit" id="delete-all" name="delete-all" class="button" value="<?php _e('Empty trash', 'wpast'); ?>">
                        </form>
                    <?php endif; ?>
                    <form method="post">
                        <?php
                        $this->tickets_object->prepare_items();
                        $this->tickets_object->display();
                        WPAST_Flash_Message::show_message();
                        ?>
                    </form>
                </div>
            </div>
        </div>
        <br class="clear">
    </div>
</div>