<?php
defined('ABSPATH') || exit('No Access!');

$ds = $this->options->get_option('default-status');
?>
<div class="<?php echo $is_edit ? 'wpast-edit-ticket' : 'wpast-submit-ticket'; ?> wrap">
    <h1 class="wp-heading-inline"><?php echo $is_edit ? __('Edit ticket', 'wpast') . ' [' . $ticket->ID . ']' : __('Submit new ticket', 'wpast'); ?></h1>
    <a href="?page=wpast-tickets" class="page-title-action"><?php _e('All tickets', 'wpast'); ?></a>
    <hr class="wp-header-end">
    <?php WPAST_Flash_Message::show_message(); ?>
    <form method="post" class="ticket-form">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content">
                    <div class="wpast-content-inner">
                        <div id="titlediv">
                            <div id="titlewrap">
                                <input type="text" id="title" name="title" value="<?php echo $is_edit ? esc_attr($ticket->title) : null; ?>" placeholder="<?php _e('Enter title here', 'wpast'); ?>" autocomplete="off">
                            </div>
                        </div>
                        <div id="postdivrich">
                            <div id="wp-content-wrap" class="wp-core-ui wp-editor-wrap">
                                <?php
                                $content = $is_edit ? $ticket->content : null;
                                wp_editor($content, 'wpast-content', ['editor_height' => 326]);
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php if ($is_edit): ?>
                        <div class="wpast-start-ticket <?php echo $ticket->from_admin ? 'wpast-from-admin' : ''; ?>">
                            <div class="wpast-meta wpast-clearfix">
                                <?php echo wpast_get_avatar($ticket->creator_id); ?>
                                <span class="wpast-title"><?php echo esc_html($ticket->title); ?></span>
                                <div class="wpast-actions">
                                    <a href="#" class="wpast-toggle-edit"><?php _e('Edit', 'wpast') ?></a>
                                </div>
                            </div>
                            <div class="wpast-content">
                                <?php echo apply_filters('the_content', $ticket->content); ?>
                                <?php if ($ticket->voice_file): ?>
                                    <div class="wpast-voice-file">
                                        <?php $voice_file = explode(',', $ticket->voice_file); ?>
                                        <?php foreach ($voice_file as $file): ?>
                                            <audio src="<?php echo esc_attr($file); ?>" controls></audio>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="postbox" id="wpast-info-div">
                        <h2 class="hndle">
                            <span><?php _e('Ticket info', 'wpast'); ?></span>
                        </h2>
                        <div class="inside wpast-clearfix">
                            <ul class="wpast-info-tabs">
                                <li class="wpast-tab-general active">
                                    <a href="#">
                                        <span class="dashicons dashicons-admin-generic"></span>
                                        <?php _e('General', 'wpast'); ?>
                                    </a>
                                </li>
                                <li class="wpast-tab-fields">
                                    <a href="#">
                                        <span class="dashicons dashicons-menu"></span>
                                        <?php _e('Fields data', 'wpast'); ?>
                                    </a>
                                </li>
                                <?php if (wpast_is_woocommerce_active()): ?>
                                    <li class="wpast-tab-orders">
                                        <a href="#">
                                            <span class="dashicons dashicons-cart"></span>
                                            <?php _e('User orders', 'wpast'); ?>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li class="wpast-tab-rating">
                                    <a href="#">
                                        <span class="dashicons dashicons-star-filled"></span>
                                        <?php _e('Ratings', 'wpast'); ?>
                                    </a>
                                </li>
                            </ul>
                            <div class="wpast-tab-panel" id="wpast-panel-general">
                                <div>
                                    <table>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <label for="wpast-status"><?php _e('Status', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <select id="wpast-status" name="status">
                                                    <?php foreach ($statuses as $_status): ?>
                                                        <option value="<?php echo esc_attr($_status['slug']); ?>" <?php $is_edit ? selected($ticket->status, $_status['slug']) : null; ?>><?php echo esc_html($_status['name']); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <?php
                                                if ($ds) {
                                                    echo '<span style="cursor: help;" title="' . __('You can default status in settings > statuses.', 'wpast') . '">' . __('Default', 'wpast') . ': ' . wpast_get_status_html($ds, false) . '</span>';
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-priority"><?php _e('Priority', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <select id="wpast-priority" name="priority">
                                                    <option value="low" <?php $is_edit ? selected($ticket->priority, 'low') : null; ?>><?php _e('Low', 'wpast'); ?></option>
                                                    <option value="medium" <?php $is_edit ? selected($ticket->priority, 'medium') : null; ?>><?php _e('Medium', 'wpast'); ?></option>
                                                    <option value="high" <?php $is_edit ? selected($ticket->priority, 'high') : null; ?>><?php _e('High', 'wpast'); ?></option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-creator-id"><?php _e('Creator', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <?php
                                                if ($is_edit) {
                                                    if ($ticket->creator_id) {
                                                        $user_data = get_userdata($ticket->creator_id);
                                                        ?>
                                                        <select id="wpast-creator-id" name="creator-id">
                                                            <option value="<?php echo esc_attr($ticket->creator_id); ?>" selected><?php echo $user_data->user_login; ?></option>
                                                        </select>
                                                        <a href="<?php echo get_edit_user_link($ticket->creator_id); ?>"><?php _e('View profile', 'wpast'); ?></a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <input type="text" class="regular-text" name="user-name" value="<?php echo esc_attr($ticket->user_name); ?>" placeholder="<?php _e('Name', 'wpast'); ?>">
                                                        <br>
                                                        <input type="text" class="regular-text" name="user-email" value="<?php echo esc_attr($ticket->user_email); ?>" placeholder="<?php _e('Email', 'wpast'); ?>" style="margin: 3px 0;">
                                                        <br>
                                                        <input type="text" class="regular-text" name="user-mobile" value="<?php echo esc_attr($ticket->user_mobile); ?>" placeholder="<?php _e('Mobile', 'wpast'); ?>">
                                                        <?php
                                                    }
                                                } else {
                                                    $user_data = get_userdata($user_id);
                                                    ?>
                                                    <select id="wpast-creator-id" name="creator-id">
                                                        <option value="<?php echo esc_attr($user_id); ?>" selected><?php echo $user_data->user_login; ?></option>
                                                    </select>
                                                    <?php
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-user-id"><?php _e('User', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <?php
                                                if ($is_edit && $ticket->user_id) {
                                                    $user_data = get_userdata($ticket->user_id);
                                                    ?>
                                                    <select id="wpast-user-id" name="user-id">
                                                        <option value="<?php echo esc_attr($ticket->user_id); ?>" selected><?php echo $user_data->user_login; ?></option>
                                                    </select>
                                                    <a href="<?php echo get_edit_user_link($ticket->user_id); ?>"><?php _e('View profile', 'wpast'); ?></a>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <select id="wpast-user-id" name="user-id">
                                                        <option value="" selected></option>
                                                    </select>
                                                    <?php
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-product"><?php _e('Product', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <?php if (wpast_is_woocommerce_active()) : ?>
                                                    <select id="wpast-product" name="product">
                                                        <?php if ($is_edit && intval($ticket->product)): ?>
                                                            <option value="<?php echo esc_attr($ticket->product); ?>" selected><?php echo get_the_title($ticket->product); ?></option>
                                                        <?php endif; ?>
                                                    </select>
                                                    <?php if ($is_edit): ?>
                                                        <a href="<?php echo get_edit_post_link($ticket->product); ?>" target="_blank"><?php _e('View product', 'wpast'); ?></a>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <input type="text" class="regular-text" id="wpast-product" name="product" value="<?php echo $is_edit ? esc_attr($ticket->product) : null; ?>">
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-voice-file"><?php _e('Voice file', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <?php if ($is_edit): ?>
                                                    <input type="text" class="regular-text" id="wpast-voice-file" name="voice-file" value="<?php echo esc_attr($ticket->voice_file); ?>">
                                                <?php else: ?>
                                                    <?php include(WPAST_TPL_PATH . 'recorder.php'); ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-ath-file"><?php _e('Attachment file', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <input type="text" class="wpast-upload-file regular-text" id="wpast-ath-file" name="ath-file" value="<?php echo $is_edit ? esc_attr($ticket->ath_file) : null; ?>">
                                                <?php if ($is_edit && $ticket->ath_file): ?>
                                                    <?php
                                                    $ath_file = explode(',', $ticket->ath_file);
                                                    $i = 0;
                                                    ?>
                                                    <?php foreach ($ath_file as $file): ?>
                                                        <?php $i++ ?>
                                                        <a href="<?php echo esc_attr($file); ?>" target="_blank"><?php _e('View file', 'wpast'); ?></a>
                                                        <?php
                                                        if (count($ath_file) != $i) {
                                                            echo ' | ';
                                                        }
                                                        ?>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="wpast-tab-panel" id="wpast-panel-fields">
                                <div>
                                    <?php if ($is_edit && count($field_data)): ?>
                                        <table>
                                            <tbody>
                                            <?php foreach ($field_data as $data): ?>
                                                <tr>
                                                    <td>
                                                        <label for="wpast-field-<?php echo esc_attr($data->ID); ?>"><?php echo esc_html($data->label); ?></label>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="regular-text" id="wpast-field-<?php echo esc_attr($data->ID); ?>" name="field[<?php echo esc_attr($data->ID); ?>]" value="<?php echo esc_attr($data->value); ?>">
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
                                        <p><?php _e('No items found!', 'wpast'); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if (wpast_is_woocommerce_active() && $is_edit && $ticket->creator_id): ?>
                                <div class="wpast-tab-panel" id="wpast-panel-orders">
                                    <div>
                                        <a href="<?php echo esc_url(admin_url('edit.php?post_type=shop_order&_customer_user=' . $user_id)); ?>" target="_blank"><?php _e('View all user orders', 'wpast'); ?></a>
                                        <?php include(WPAST_TPL_PATH . 'customer-orders.php'); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="wpast-tab-panel" id="wpast-panel-rating">
                                <div>
                                    <table>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <label for="wpast-active-rating"><?php _e('Active', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <label>
                                                    <input type="checkbox" id="wpast-active-rating" name="active-rating" value="1" <?php $is_edit ? checked($ticket->active_rating, 1) : null; ?>>
                                                    <?php _e('Yes', 'wpast'); ?>
                                                </label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="wpast-rating"><?php _e('Registered rating', 'wpast'); ?></label>
                                            </td>
                                            <td>
                                                <input type="text" class="regular-text" id="wpast-rating" name="rating" value="<?php echo $is_edit ? esc_attr($ticket->rating) : null; ?>">
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if ($is_edit): ?>
                        <div class="postbox-container" id="wpast-submit-reply-div">
                            <div class="postbox">
                                <h2 class="hndle">
                                    <span><?php _e('Submit reply', 'wpast'); ?></span>
                                </h2>
                                <div class="inside">
                                    <?php if (count($pre_answers)): ?>
                                        <div class="wpast-pre-answer">
                                            <div class="wpast-inner">
                                                <?php foreach ($pre_answers as $pre_answer): ?>
                                                    <div class="wpast-pre-answer-item">
                                                        <span><?php echo esc_html($pre_answer->title); ?></span>
                                                        <div class="wpast-pre-answer-content"><?php echo apply_filters('the_content', $pre_answer->content); ?></div>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                            <a href="#" id="wpast-show-more"><?php _e('Show more', 'wpast'); ?></a>
                                        </div>
                                    <?php endif; ?>
                                    <?php wp_editor(null, 'wpast-reply-content', ['editor_height' => 256]); ?>
                                    <?php
                                    $voice_name = 'reply-voice-file';
                                    include(WPAST_TPL_PATH . 'recorder.php');
                                    ?>
                                    <input type="text" class="wpast-upload-file regular-text" name="reply-ath-file" placeholder="<?php _e('Attachment file', 'wpast'); ?>">
                                </div>
                            </div>
                            <?php if (count($replies)): ?>
                                <div id="wpast-replies">
                                    <?php foreach ($replies as $reply): ?>
                                        <div class="wpast-reply <?php echo $reply->from_admin ? 'wpast-from-admin' : ''; ?> <?php echo wpast_is_vendor_ticket($ticket, $support_departments, $reply->creator_id) ? 'wpast-from-vendor' : ''; ?>">
                                            <div class="wpast-meta wpast-clearfix">
                                                <?php
                                                echo wpast_get_avatar($reply->creator_id);
                                                $user_data = get_userdata($reply->creator_id);
                                                ?>
                                                <a href="<?php echo intval($reply->creator_id) ? get_edit_user_link($reply->creator_id) : '#'; ?>" class="wpast-user" target="_blank"><?php echo $user_data ? $user_data->display_name : ($reply->creator_id == null ? $labels->get_label('automation') : null); ?></a>
                                                <span class="wpast-date"><?php echo wpast_format_date(strtotime($reply->create_date)); ?></span>
                                            </div>
                                            <div class="wpast-content">
                                                <?php echo apply_filters('the_content', $reply->content); ?>
                                                <?php if ($reply->voice_file): ?>
                                                    <div class="wpast-voice-file">
                                                        <?php $voice_file = explode(',', $reply->voice_file); ?>
                                                        <?php foreach ($voice_file as $file): ?>
                                                            <audio src="<?php echo esc_attr($file); ?>" controls></audio>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="wpast-footer wpast-clearfix">
                                                <input type="text" class="wpast-upload-file regular-text" name="reply-ath-file-<?php echo esc_attr($reply->ID); ?>" value="<?php echo esc_attr($reply->ath_file); ?>" placeholder="<?php _e('Attachment file', 'wpast'); ?>">
                                                <?php if ($reply->ath_file): ?>
                                                    <?php
                                                    $ath_file = explode(',', $reply->ath_file);
                                                    $i = 0;
                                                    ?>
                                                    <?php foreach ($ath_file as $file): ?>
                                                        <?php $i++ ?>
                                                        <a href="<?php echo esc_attr($file); ?>" target="_blank"><?php _e('View file', 'wpast'); ?></a>
                                                        <?php
                                                        if (count($ath_file) != $i) {
                                                            echo ' | ';
                                                        }
                                                        ?>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                                <div class="wpast-actions">
                                                    <a href="#" class="wpast-toggle-edit"><?php _e('Edit', 'wpast'); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="wpast-editor">
                                            <?php wp_editor($reply->content, 'wpast-reply-content-' . $reply->ID, ['editor_height' => 256]); ?>
                                            <p>
                                                <input type="text" class="regular-text" name="reply-voice-file-<?php echo esc_attr($reply->ID); ?>" value="<?php echo esc_attr($reply->voice_file); ?>" placeholder="<?php _e('Voice file', 'wpast'); ?>">
                                            </p>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div id="postbox-container-1" class="postbox-container">
                    <div id="submitdiv" class="postbox">
                        <h2 class="hndle"><span><?php _e('Send', 'wpast'); ?></span></h2>
                        <div class="inside">
                            <div id="minor-publishing">
                                <div id="misc-publishing-actions">
                                    <div class="misc-pub-section"></div>
                                    <div class="misc-pub-section">
                                        <input type="checkbox" id="wpast-notification" name="notification" checked>
                                        <label for="wpast-notification"><?php _e('Send notification', 'wpast'); ?></label>
                                    </div>
                                    <div class="misc-pub-section">
                                        <span class="dashicons dashicons-calendar"></span>
                                        <?php
                                        $date = $is_edit ? strtotime($ticket->create_date) : time();
                                        echo wpast_format_date($date);
                                        ?>
                                        <a href="#" class="wpast-edit-date"><?php _e('Edit', 'wpast'); ?></a>
                                        <input type="text" class="regular-text" name="create-date" value="<?php echo date('Y-m-d H:i:s', $date); ?>">
                                    </div>
                                </div>
                            </div>
                            <div id="major-publishing-actions">
                                <div class="submitbox" id="submitpost">
                                    <div id="publishing-action">
                                        <input type="submit" name="publish" id="publish" class="button button-primary button-large" value="<?php _e('Save and send', 'wpast'); ?>">
                                    </div>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="postbox" id="wpast-department-div">
                        <h2 class="hndle">
                            <span><?php _e('Department', 'wpast'); ?></span>
                        </h2>
                        <div class="inside">
                            <div>
                                <?php if (count($parent_departments)): ?>
                                    <?php foreach ($parent_departments as $parent_department): ?>
                                        <p><?php echo esc_html($parent_department->name); ?></p>
                                        <?php $child_departments = $department_manager->get_child_departments($parent_department->ID); ?>
                                        <?php if (count($child_departments)): ?>
                                            <?php foreach ($child_departments as $child_department): ?>
                                                <label>
                                                    <input type="radio" name="department-id" value="<?php echo esc_attr($child_department->ID); ?>" <?php $is_edit ? checked($ticket->department_id, $child_department->ID) : null; ?>>
                                                    <?php echo esc_html($child_department->name); ?>
                                                </label>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if ($is_edit): ?>
                        <div class="postbox" id="wpast-process-div">
                            <h2 class="hndle">
                                <span><?php _e('Process', 'wpast'); ?></span>
                            </h2>
                            <div class="inside">
                                <div>
                                    <label>
                                        <input type="radio" name="process" value="none" checked>
                                        <?php _e('None', 'wpast'); ?>
                                    </label>
                                    <?php if (count($processes)): ?>
                                        <?php foreach ($processes as $process): ?>
                                            <label>
                                                <input type="radio" name="process" value="<?php echo esc_attr($process->ID); ?>">
                                                <?php echo esc_html($process->title); ?>
                                            </label>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                <?php include(WPAST_TPL_PATH . 'admin/processes.php'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($is_edit): ?>
                        <div class="postbox" id="wpast-annotation-div">
                            <h2 class="hndle">
                                <span><?php _e('Annotation', 'wpast'); ?></span>
                            </h2>
                            <div class="inside">
                                <textarea class="regular-text" id="wpast-annotation" name="annotation" rows="5"></textarea>
                                <a href="#" class="button" id="wpast-add-annotation" data-ticket-id="<?php echo esc_attr($ticket->ID); ?>"><?php _e('Add annotation', 'wpast'); ?></a>
                                <?php include(WPAST_TPL_PATH . 'admin/annotations.php'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <br class="clear">
        </div>
        <?php wp_nonce_field('ticket_security', 'ticket_nonce'); ?>
    </form>
</div>