<?php
defined('ABSPATH') || exit('No Access!');

$support_departments = $options->get_option('support-departments');
$expire_time = $options->get_option('expire-time');
$max_count = $options->get_option('max-count');
$disabled = $options->get_option('checkout-disabled');
$disabled = $disabled ? $disabled : [];
$vendor_departments = $options->get_option('vendor-departments');
$vendor_submit_departments = $options->get_option('vendor-submit-departments');
?>
<div class="wpast-settings-area wpast-settings-woocommerce">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="cart"></span></span>
        <strong><?php _e('Woocommerce', 'wpast'); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Support departments', 'wpast'); ?></label>
        <?php if (is_array($child_departments) && count($child_departments)): ?>
            <?php foreach ($child_departments as $child_department): ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="support-departments[]"
                               value="<?php echo esc_attr($child_department->ID); ?>" <?php echo is_array($support_departments) && in_array($child_department->ID, $support_departments) ? 'checked' : null; ?>>
                        <?php echo esc_html($child_department->name); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Products support', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="wc-support"
                       value="1" <?php echo checked($options->get_option('wc-support'), 1); ?>>
                <?php _e('This option allows you to provide support only for Woocommerce products that the user has purchased.', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="wc-only-customer"
                       value="1" <?php echo checked($options->get_option('wc-only-customer'), 1); ?>>
                <?php _e('Enabling this option only users who have purchased can submit ticket.', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-expire-time"><?php _e('Expire time', 'wpast'); ?></label>
        <div uk-form-custom="target: > * > span:first-child">
            <select name="expire-time" id="wpast-expire-time">
                <option value="unlimited" <?php selected($expire_time, 'unlimited'); ?>><?php _e('Unlimited', 'wpast'); ?></option>
                <option value="limited" <?php selected($expire_time, 'limited'); ?>><?php _e('Limited', 'wpast'); ?></option>
            </select>
            <button class="wpast-confirm uk-button uk-button-default" type="button" tabindex="-1">
                <span></span>
                <span uk-icon="icon: chevron-down"></span>
            </button>
        </div>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Selecting a limited option should set the expiration date for Woocommerce products.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-max-count"><?php _e('Maximum count', 'wpast'); ?></label>
        <div uk-form-custom="target: > * > span:first-child">
            <select name="max-count" id="wpast-max-count">
                <option value="unlimited" <?php selected($max_count, 'unlimited'); ?>><?php _e('Unlimited', 'wpast'); ?></option>
                <option value="limited" <?php selected($max_count, 'limited'); ?>><?php _e('Limited', 'wpast'); ?></option>
            </select>
            <button class="wpast-confirm uk-button uk-button-default" type="button" tabindex="-1">
                <span></span>
                <span uk-icon="icon: chevron-down"></span>
            </button>
        </div>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Selecting a limited option should set the maximum count for Woocommerce products.', 'wpast'); ?>
        </div>
    </div>
    <?php if (wpast_is_woocommerce_active()): ?>
        <div class="uk-margin">
            <label class="uk-form-label"><?php _e('Order statuses', 'wpast'); ?></label>
            <?php
            $statuses = $options->get_option('order-statutes');
            foreach (wc_get_order_statuses() as $status => $title) {
                ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="order-statutes[]"
                               value="<?php echo $status; ?>" <?php echo (is_array($statuses) && in_array($status, $statuses)) || ($statuses == null && $status == 'wc-completed') ? 'checked' : null; ?>>
                        <?php echo $title; ?>
                    </label>
                </div>
                <?php
            }
            ?>
            <div class="wpast-description">
                <span uk-icon="info"></span>
                <?php _e('Select the status of the order for which it is possible to send a ticket.', 'wpast'); ?>
            </div>
        </div>
    <?php endif; ?>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Support extension', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="bought-products"
                       value="1" <?php echo checked($options->get_option('bought-products'), 1); ?>>
                <?php _e('Show bought products item in user account', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="wc-extension"
                       value="1" <?php echo checked($options->get_option('wc-extension'), 1); ?>>
                <?php _e('Active', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="extension-coupon"
                       value="1" <?php echo checked($options->get_option('extension-coupon'), 1); ?>>
                <?php _e('Disable discount coupon', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Extension disabled fields', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[first-name]" value="1" <?php echo array_key_exists('first-name', $disabled) ? 'checked' : null; ?>>
                <?php _e('First name', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[last-name]" value="1" <?php echo array_key_exists('last-name', $disabled) ? 'checked' : null; ?>>
                <?php _e('Last name', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[company]" value="1" <?php echo array_key_exists('company', $disabled) ? 'checked' : null; ?>>
                <?php _e('Company', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[country]" value="1" <?php echo array_key_exists('country', $disabled) ? 'checked' : null; ?>>
                <?php _e('Country', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[address-1]" value="1" <?php echo array_key_exists('address-1', $disabled) ? 'checked' : null; ?>>
                <?php _e('Address 1', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[address-2]" value="1" <?php echo array_key_exists('address-2', $disabled) ? 'checked' : null; ?>>
                <?php _e('Address 2', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[city]" value="1" <?php echo array_key_exists('city', $disabled) ? 'checked' : null; ?>>
                <?php _e('City', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[state]" value="1" <?php echo array_key_exists('state', $disabled) ? 'checked' : null; ?>>
                <?php _e('State', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[postcode]" value="1" <?php echo array_key_exists('postcode', $disabled) ? 'checked' : null; ?>>
                <?php _e('Postcode', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[phone]" value="1" <?php echo array_key_exists('phone', $disabled) ? 'checked' : null; ?>>
                <?php _e('Phone', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[email]" value="1" <?php echo array_key_exists('email', $disabled) ? 'checked' : null; ?>>
                <?php _e('Email', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="checkout-disabled[note]" value="1" <?php echo array_key_exists('note', $disabled) ? 'checked' : null; ?>>
                <?php _e('Note', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Vendor support departments', 'wpast'); ?></label>
        <?php if (is_array($child_departments) && count($child_departments)): ?>
            <?php foreach ($child_departments as $child_department): ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-departments[]" value="<?php echo esc_attr($child_department->ID); ?>" <?php echo is_array($vendor_departments) && in_array($child_department->ID, $vendor_departments) ? 'checked' : null; ?>>
                        <?php echo esc_html($child_department->name); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Vendor submit ticket departments', 'wpast'); ?></label>
        <?php if (is_array($child_departments) && count($child_departments)): ?>
            <?php foreach ($child_departments as $child_department): ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-submit-departments[]" value="<?php echo esc_attr($child_department->ID); ?>" <?php echo is_array($vendor_departments) && in_array($child_department->ID, $vendor_submit_departments) ? 'checked' : null; ?>>
                        <?php echo esc_html($child_department->name); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>