<?php defined('ABSPATH') || exit('No Access!'); ?>
<div class="wpast-settings-area wpast-settings-upload">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="upload"></span></span>
        <strong><?php _e('Upload', 'wpast'); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('File upload', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="active-upload" value="1" <?php echo checked($options->get_option('active-upload'), 1); ?>>
                <?php _e('Active', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="advanced-uploader" value="1" <?php echo checked($options->get_option('advanced-uploader'), 1); ?>>
                <?php _e('Advanced', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <input type="number" class="uk-input" name="number-files" value="<?php echo $options->get_option('number-files'); ?>" placeholder="<?php _e('Maximum number of files', 'wpast'); ?>">
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox <?php echo !is_ssl() ? 'wpast-confirm' : null; ?>" type="checkbox" name="voice-message" <?php echo !is_ssl() ? 'data-toggle="voice-message"' : null; ?> value="1" <?php echo checked($options->get_option('voice-message'), 1); ?>>
                <?php _e('Voice message', 'wpast'); ?>
            </label>
            <?php echo wpast_update_notice(); ?>
        </div>
        <?php if (!is_ssl()): ?>
            <div class="wpast-confirm-activation" id="wpast-voice-message">
                <span uk-icon="warning"></span>
                <?php _e('SSL is required to use this feature.', 'wpast'); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-upload-max"><?php _e('Maximum size', 'wpast'); ?></label>
        <input type="number" class="uk-input" id="wpast-upload-max" name="upload-max" value="<?php echo $options->get_option('upload-max'); ?>">
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Enter the maximum file size in MB.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-extensions"><?php _e('Allowed extensions', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-extensions" name="extensions" value="<?php echo $options->get_option('extensions'); ?>">
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Separate allowed extensions with commas.', 'wpast'); ?>
        </div>
    </div>
</div>