<?php
defined('ABSPATH') || exit('No Access!');
$fags = $options->get_option('fags');
?>
<div class="wpast-settings-area wpast-settings-template">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="folder"></span></span>
        <strong><?php _e('Template', 'wpast'); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Tickets list', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-title" value="1" <?php echo checked($options->get_option('tickets-list-title'), 1); ?>>
                <?php _e('Title', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-department" value="1" <?php echo checked($options->get_option('tickets-list-department'), 1); ?>>
                <?php _e('Department', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-rating" value="1" <?php echo checked($options->get_option('tickets-list-rating'), 1); ?>>
                <?php _e('Rating', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-user" value="1" <?php echo checked($options->get_option('tickets-list-user'), 1); ?>>
                <?php _e('User', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-replies" value="1" <?php echo checked($options->get_option('tickets-list-replies'), 1); ?>>
                <?php _e('Replies', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-product" value="1" <?php echo checked($options->get_option('tickets-list-product'), 1); ?>>
                <?php _e('Product', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-status" value="1" <?php echo checked($options->get_option('tickets-list-status'), 1); ?>>
                <?php _e('Status', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-date" value="1" <?php echo checked($options->get_option('tickets-list-date'), 1); ?>>
                <?php _e('Date', 'wpast'); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="tickets-list-actions" value="1" <?php echo checked($options->get_option('tickets-list-actions'), 1); ?>>
                <?php _e('Actions', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-help-text"><?php _e('Help text', 'wpast'); ?></label>
        <?php wp_editor($options->get_option('help-text'), 'help-text', ['editor_height' => 256]); ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Fags', 'wpast'); ?></label>
        <div>
            <?php if (is_array($fags)): ?>
                <?php foreach ($fags as $fag): ?>
                    <div class="uk-margin-small">
                        <textarea class="uk-textarea" name="fags[]" rows="5"><?php echo esc_textarea($fag); ?></textarea>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
            <div class="wpast-description">
                <span uk-icon="info"></span>
                <?php _e('Enter in this format:', 'wpast'); ?>
                <code> <?php _e('Title:Content', 'wpast'); ?></code>
            </div>
            <a href="#" class="wpast-new-fag uk-button uk-button-default uk-button-small"><?php _e('New item', 'wpast'); ?></a>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('User ticket background color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="user-ticket-bg-color" value="<?php echo esc_attr($options->get_option('user-ticket-bg-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('User ticket text color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="user-ticket-text-color" value="<?php echo esc_attr($options->get_option('user-ticket-text-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Admin ticket background color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="admin-ticket-bg-color" value="<?php echo esc_attr($options->get_option('admin-ticket-bg-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Admin ticket text color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="admin-ticket-text-color" value="<?php echo esc_attr($options->get_option('admin-ticket-text-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Vendor ticket background color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="vendor-ticket-bg-color" value="<?php echo esc_attr($options->get_option('vendor-ticket-bg-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Vendor ticket text color', 'wpast'); ?></label>
        <br>
        <input type="text" class="wpast-color-field" name="vendor-ticket-text-color" value="<?php echo esc_attr($options->get_option('vendor-ticket-text-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-custom-css"><?php _e('Custom CSS', 'wpast'); ?></label>
        <textarea class="uk-textarea" id="wpast-custom-css" name="custom-css" rows="10" dir="ltr"><?php echo esc_textarea($options->get_option('custom-css')); ?></textarea>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-header-text"><?php _e('Header text', 'wpast'); ?></label>
        <?php wp_editor($options->get_option('header-text'), 'header-text', ['editor_height' => 128]); ?>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('This text is displayed on the admin\'s ticket header.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-footer-text"><?php _e('Footer text', 'wpast'); ?></label>
        <?php wp_editor($options->get_option('footer-text'), 'footer-text', ['editor_height' => 128]); ?>
    </div>
</div>