<?php
defined('ABSPATH') || exit('No Access!');

$statuses = $options->get_option('statuses');
$all_statuses = wpast_get_statuses();
?>
<div class="wpast-settings-area wpast-settings-statuses">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="nut"></span></span>
        <strong><?php _e('Statuses', 'wpast'); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Default status', 'wpast'); ?></label>
        <div uk-form-custom="target: > * > span:first-child">
            <select name="default-status">
                <option value=""><?php _e('None', 'wpast'); ?></option>
                <?php if (is_array($all_statuses)): ?>
                    <?php foreach ($all_statuses as $status): ?>
                        <option value="<?php echo esc_attr($status['slug']); ?>" <?php selected($status['slug'], $options->get_option('default-status')); ?>><?php echo esc_html($status['name']); ?></option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
            <button class="uk-button uk-button-default" type="button" tabindex="-1">
                <span></span>
                <span uk-icon="icon: chevron-down"></span>
            </button>
        </div>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Select the default status to respond to the admin panel.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-open-color"><?php _e('Open color', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-open-color" name="open-color" value="<?php echo esc_attr($options->get_option('open-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-closed-color"><?php _e('Closed color', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-closed-color" name="closed-color" value="<?php echo esc_attr($options->get_option('closed-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-answered-color"><?php _e('Answered color', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-answered-color" name="answered-color" value="<?php echo esc_attr($options->get_option('answered-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-finished-color"><?php _e('Finished color', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-finished-color" name="finished-color" value="<?php echo esc_attr($options->get_option('finished-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-trash-color"><?php _e('Trash color', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-trash-color" name="trash-color" value="<?php echo esc_attr($options->get_option('trash-color')); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Custom statuses', 'wpast'); ?></label>
        <div>
            <?php if (is_array($statuses)): ?>
                <?php foreach ($statuses as $status): ?>
                    <div class="uk-margin-small">
                        <input type="text" class="uk-input" name="statuses[]" value="<?php echo esc_attr($status); ?>" placeholder="<?php echo __('Slug', 'wpast') . ':' . __('Name', 'wpast') . ':' . __('Color HEX code', 'wpast'); ?>">
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <a href="#" class="wpast-new-status uk-button uk-button-default uk-button-small"><?php _e('New item', 'wpast'); ?></a>
    </div>
</div>