<?php
defined('ABSPATH') || exit('No Access!');

$sms_service = $options->get_option('sms-service');
$meta_keys = wpast_get_user_meta_keys();
$meta_key = $options->get_option('mobile-meta-key');
?>
<div class="wpast-settings-area wpast-settings-sms">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="tablet"></span></span>
        <strong><?php _e('SMS', 'wpast'); ?></strong>
    </h2>
    <ul uk-tab>
        <li class="uk-active"><a href="#"><?php _e('Global', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Create ticket', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Submit ticket', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Submit reply', 'wpast'); ?></a></li>
    </ul>
    <ul class="uk-switcher uk-margin">
        <li>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-sms-service"><?php _e('SMS service', 'wpast'); ?></label>
                <div uk-form-custom="target: > * > span:first-child">
                    <select id="wpast-sms-service" name="sms-service">
                        <option value=""><?php _e('Please select an item.', 'wpast'); ?></option>
                        <option value="melipayamak" data-pattern="1" <?php selected($sms_service, 'melipayamak'); ?>>Melipayamak</option>
                        <option value="newsms" <?php selected($sms_service, 'newsms'); ?>>Newsms</option>
                        <option value="smsir" data-pattern="1" <?php selected($sms_service, 'smsir'); ?>>SMS.IR</option>
                        <option value="payamresan" <?php selected($sms_service, 'payamresan'); ?>>Payam-resan</option>
                        <option value="farapayamak" <?php selected($sms_service, 'farapayamak'); ?>>Farapayamak</option>
                        <option value="payamkutah" <?php selected($sms_service, 'payamkutah'); ?>>Payamkutah</option>
                        <option value="zhiak" <?php selected($sms_service, 'zhiak'); ?>>Zhiak</option>
                        <option value="ippanel" data-pattern="1" <?php selected($sms_service, 'ippanel'); ?>>IPPanel</option>
                        <option value="sibsmspanel" <?php selected($sms_service, 'sibsmspanel'); ?>>Sibsmspanel</option>
                        <option value="maxsms" <?php selected($sms_service, 'maxsms'); ?>>Max-sms</option>
                        <option value="farazsms" data-pattern="1" <?php selected($sms_service, 'farazsms'); ?>>Farazsms</option>
                        <option value="kavenegar" data-pattern="1" <?php selected($sms_service, 'kavenegar'); ?>>Kavenegar</option>
                        <option value="candoosms" <?php selected($sms_service, 'candoosms'); ?>>Candoosms</option>
                        <option value="aradpayamak" <?php selected($sms_service, 'aradpayamak'); ?>>aradpayamak.net
                        </option>
                        <option value="parsgreen" <?php selected($sms_service, 'parsgreen'); ?>>Parsgreen</option>
                        <option value="raygansms" <?php selected($sms_service, 'raygansms'); ?>>Raygansms</option>
                        <option value="ssmss" <?php selected($sms_service, 'ssmss'); ?>>SSMSS.IR</option>
                        <option value="fullonline" <?php selected($sms_service, 'fullonline'); ?>>Fullonline</option>
                        <option value="niazpardaz" <?php selected($sms_service, 'niazpardaz'); ?>>Niazpardaz</option>
                        <option value="sabanovin" <?php selected($sms_service, 'sabanovin'); ?>>Sabanovin</option>
                        <option value="hostiran" <?php selected($sms_service, 'hostiran'); ?>>Hostiran</option>
                        <option value="parandsms" <?php selected($sms_service, 'parandsms'); ?>>Parandsms</option>
                        <option value="shayansms" <?php selected($sms_service, 'shayansms'); ?>>Shayan-sms</option>
                        <option value="tehsms" <?php selected($sms_service, 'tehsms'); ?>>Teh-sms</option>
                        <option value="shahvarpayam" <?php selected($sms_service, 'shahvarpayam'); ?>>Shahvarpayam
                        </option>
                        <option value="modirpayamak" <?php selected($sms_service, 'modirpayamak'); ?>>Modirpayamak
                        </option>
                        <option value="activepayamak" <?php selected($sms_service, 'activepayamak'); ?>>Activepayamak
                        </option>
                        <option value="smshooshmand" <?php selected($sms_service, 'smshooshmand'); ?>>Smshooshmand
                        </option>
                        <option value="rangine" data-pattern="1" <?php selected($sms_service, 'rangine'); ?>>Rangine</option>
                        <option value="_0098sms" <?php selected($sms_service, '_0098sms'); ?>>0098sms</option>
                        <option value="niksms" <?php selected($sms_service, 'niksms'); ?>>Niksms</option>
                        <option value="tsms" <?php selected($sms_service, 'tsms'); ?>>Tsms</option>
                        <option value="sunwaysms" <?php selected($sms_service, 'sunwaysms'); ?>>Sunwaysms</option>
                        <option value="panelsms20" <?php selected($sms_service, 'panelsms20'); ?>>Panelsms20</option>
                        <option value="asanak" <?php selected($sms_service, 'asanak'); ?>>Asanak</option>
                        <option value="elanak" <?php selected($sms_service, 'elanak'); ?>>Elanak</option>
                        <option value="tabansms" data-pattern="1" <?php selected($sms_service, 'tabansms'); ?>>Tabansms</option>
                    </select>
                    <button class="uk-button uk-button-default" type="button" tabindex="-1">
                        <span></span>
                        <span uk-icon="icon: chevron-down"></span>
                    </button>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-sms-username"><?php _e('SMS username', 'wpast'); ?></label>
                <input type="text" class="uk-input" id="wpast-sms-username" name="sms-username" value="<?php echo esc_attr($options->get_option('sms-username')); ?>">
            </div>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-sms-password"><?php _e('SMS password', 'wpast'); ?></label>
                <input type="text" class="uk-input" id="wpast-sms-password" name="sms-password" value="<?php echo esc_attr($options->get_option('sms-password')); ?>">
            </div>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-sms-from"><?php _e('SMS from', 'wpast'); ?></label>
                <input type="text" class="uk-input" id="wpast-sms-from" name="sms-from" value="<?php echo esc_attr($options->get_option('sms-from')); ?>">
            </div>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-mobile-meta-key"><?php _e('Mobile meta key', 'wpast'); ?></label>
                <div uk-form-custom="target: > * > span:first-child">
                    <select id="wpast-mobile-meta-key" name="mobile-meta-key">
                        <option value=""><?php _e('Please select an item.', 'wpast'); ?></option>
                        <?php if (is_array($meta_keys) && count($meta_keys)): ?>
                            <?php foreach ($meta_keys as $key): ?>
                                <option value="<?php echo esc_html($key); ?>" <?php selected($meta_key, $key); ?>><?php echo esc_html($key); ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <button class="uk-button uk-button-default" type="button" tabindex="-1">
                        <span></span>
                        <span uk-icon="icon: chevron-down"></span>
                    </button>
                </div>
                <div class="wpast-description">
                    <span uk-icon="info"></span>
                    <?php _e('User must register your mobile number in your profile to receive SMS. If you use another plugin to register a user\'s mobile number, select the mobile meta key.', 'wpast'); ?>
                </div>
            </div>
            <div class="uk-margin" style="display: none;">
                <button class="uk-button uk-button-secondary" uk-toggle="target: #wpast-send-sms-modal" type="button"><?php _e('Send SMS test', 'wpast'); ?></button>
                <div id="wpast-send-sms-modal" uk-modal>
                    <div class="uk-modal-dialog uk-modal-body">
                        <h2 class="uk-modal-title"><?php _e('Send SMS test', 'wpast'); ?></h2>
                        <div class="uk-margin-small">
                            <input type="text" class="uk-input" id="wpast-test-phone" placeholder="<?php _e('Phone number', 'wpast'); ?>">
                        </div>
                        <div class="uk-margin-small">
                            <div class="uk-alert-primary" uk-alert style="display: none;text-align: left;direction: initial;"></div>
                            <a href="#" class="uk-button uk-button-secondary" id="wpast-send-test-sms">
                                <?php _e('Send', 'wpast'); ?>
                                <img class="loader" src="<?php echo WPAST_IMG_URL; ?>oval.svg" width="26" height="26" alt="loader">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-margin wpast-pattern-wrapper">
                <label class="uk-form-label" for="wpast-sms-pattern-code"><?php _e('Pattern code', 'wpast'); ?></label>
                <input type="text" class="uk-input" id="wpast-sms-pattern-code" name="sms-pattern-code" value="<?php echo esc_attr($options->get_option('sms-pattern-code')); ?>">
            </div>
            <div class="uk-margin wpast-pattern-wrapper">
                <label class="uk-form-label" for="wpast-sms-pattern"><?php _e('Pattern', 'wpast'); ?></label>
                <textarea class="uk-textarea" id="wpast-sms-pattern" name="sms-pattern" rows="6"><?php echo esc_textarea($options->get_option('sms-pattern')); ?></textarea>
                <div class="wpast-description">
                    <span uk-icon="info"></span>
                    <?php _e('Put the code you used in the pattern into a separate line.', 'wpast'); ?>
                </div>
                <table class="wpast-code-table wpast-pattern-table">
                    <tbody>
                    <tr>
                        <td><?php _e('Ticket ID', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">ticket_id</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Token', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">token</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Title', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">title</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Content', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">content</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('User name', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">user_name</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Recipient name', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">recipient_name</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Department', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">department</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Status', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">status</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Priority', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">priority</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Date', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">date</code></td>
                    </tr>
                    </tbody>
                </table>
                <table class="wpast-code-table wpast-kavenegar">
                    <tbody>
                    <tr>
                        <td><?php _e('Ticket ID', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">token</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Title', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">token2</code></td>
                    </tr>
                    <tr>
                        <td><?php _e('Recipient name', 'wpast'); ?></td>
                        <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">token3</code></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <div class="wpast-description">
                    <span uk-icon="info"></span>
                    <?php _e('This notification will be sent to the ticket creator.', 'wpast'); ?>
                </div>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-create-sms" value="1" <?php echo checked($options->get_option('user-create-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="user-create-sms-content" rows="7"><?php echo esc_textarea($options->get_option('user-create-sms-content')); ?></textarea>
                    <table class="wpast-code-table">
                        <tbody>
                        <tr>
                            <td><?php _e('Ticket ID', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{ticket_id}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Token', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{token}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Title', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{title}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Content', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{content}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('User name', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{user_name}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Recipient name', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{recipient_name}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Department', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{department}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Status', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{status}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Priority', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{priority}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Date', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{date}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Product', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{product}}</code>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="user-create-sms-pattern-code" value="<?php echo esc_attr($options->get_option('user-create-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="user-create-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('user-create-sms-pattern')); ?></textarea>
                </div>
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Admin', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="admin-ticket-sms" value="1" <?php echo checked($options->get_option('admin-ticket-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="admin-ticket-sms-content" rows="7"><?php echo esc_textarea($options->get_option('admin-ticket-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="admin-ticket-sms-pattern-code" value="<?php echo esc_attr($options->get_option('admin-ticket-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="admin-ticket-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('admin-ticket-sms-pattern')); ?></textarea>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('User', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-ticket-sms" value="1" <?php echo checked($options->get_option('user-ticket-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="user-ticket-sms-content" rows="7"><?php echo esc_textarea($options->get_option('user-ticket-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="user-ticket-sms-pattern-code" value="<?php echo esc_attr($options->get_option('user-ticket-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="user-ticket-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('user-ticket-sms-pattern')); ?></textarea>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Vendor', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-ticket-sms" value="1" <?php echo checked($options->get_option('vendor-ticket-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="vendor-ticket-sms-content" rows="7"><?php echo esc_textarea($options->get_option('vendor-ticket-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="vendor-ticket-sms-pattern-code" value="<?php echo esc_attr($options->get_option('vendor-ticket-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="vendor-ticket-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('vendor-ticket-sms-pattern')); ?></textarea>
                </div>
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Admin', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="admin-reply-sms" value="1" <?php echo checked($options->get_option('admin-reply-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="admin-reply-sms-content" rows="7"><?php echo esc_textarea($options->get_option('admin-reply-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="admin-reply-sms-pattern-code" value="<?php echo esc_attr($options->get_option('admin-reply-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="admin-reply-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('admin-reply-sms-pattern')); ?></textarea>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('User', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-reply-sms" value="1" <?php echo checked($options->get_option('user-reply-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="user-reply-sms-content" rows="7"><?php echo esc_textarea($options->get_option('user-reply-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="user-reply-sms-pattern-code" value="<?php echo esc_attr($options->get_option('user-reply-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="user-reply-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('user-reply-sms-pattern')); ?></textarea>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Vendor', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-reply-sms" value="1" <?php echo checked($options->get_option('vendor-reply-sms'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small wpast-message-wrapper">
                    <textarea class="uk-textarea" name="vendor-reply-sms-content" rows="7"><?php echo esc_textarea($options->get_option('vendor-reply-sms-content')); ?></textarea>
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <input type="text" class="uk-input" name="vendor-reply-sms-pattern-code" value="<?php echo esc_attr($options->get_option('vendor-reply-sms-pattern-code')); ?>" placeholder="<?php _e('Pattern code', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small wpast-pattern-wrapper">
                    <textarea class="uk-textarea" name="vendor-reply-sms-pattern" rows="6" placeholder="<?php _e('Pattern', 'wpast'); ?>"><?php echo esc_textarea($options->get_option('vendor-reply-sms-pattern')); ?></textarea>
                </div>
            </div>
        </li>
    </ul>
</div>