<?php
defined('ABSPATH') || exit('No Access!');

$menus = get_registered_nav_menus();
$open_tickets_location = $options->get_option('open-tickets-location');
?>
<div class="wpast-settings-area wpast-settings-misc">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="database"></span></span>
        <strong><?php _e('Misc', 'wpast'); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-open-tickets-location"><?php _e('Open tickets location', 'wpast'); ?></label>
        <div uk-form-custom="target: > * > span:first-child">
            <select name="open-tickets-location" id="wpast-open-tickets-location">
                <option value=""><?php _e('None', 'wpast'); ?></option>
                <?php
                foreach ($menus as $location => $description) {
                    ?>
                    <option value="<?php echo $location; ?>" <?php selected($open_tickets_location, $location); ?>><?php echo $description; ?></option>
                    <?php
                }
                ?>
            </select>
            <button class="uk-button uk-button-default" type="button" tabindex="-1">
                <span></span>
                <span uk-icon="icon: chevron-down"></span>
            </button>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Advanced editor', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="advanced-editor" value="1" <?php echo checked($options->get_option('advanced-editor'), 1); ?>>
                <?php _e('Active', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-banned-users"><?php _e('Banned users', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-banned-users" name="banned-users" value="<?php echo esc_attr($options->get_option('blocked-users')); ?>">
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Separate the users ID who were banned from posting with the English comma.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-repair-date"><?php _e('Date options', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="wpast-confirm uk-checkbox" type="checkbox" name="repair-date" data-toggle="repair-date" value="1" <?php echo checked($options->get_option('repair-date'), 1); ?>>
                <?php _e('Repair date', 'wpast'); ?>
            </label>
        </div>
        <div class="wpast-confirm-activation" id="wpast-repair-date">
            <span uk-icon="warning"></span>
            <?php _e('Enable this option if you have problems with date.', 'wpast'); ?>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="wpast-confirm uk-checkbox" type="checkbox" name="repair-timezone" data-toggle="repair-timezone" value="1" <?php echo checked($options->get_option('repair-timezone'), 1); ?>>
                <?php _e('Repair timezone', 'wpast'); ?>
            </label>
        </div>
        <div class="wpast-confirm-activation" id="wpast-repair-timezone">
            <span uk-icon="warning"></span>
            <?php _e('Enable this option if you have problems with date.', 'wpast'); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-date-format"><?php _e('Date format', 'wpast'); ?></label>
        <input type="text" class="uk-input" id="wpast-date-format" name="date-format" value="<?php echo esc_attr($options->get_option('date-format')); ?>">
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <a href="https://www.php.net/manual/en/function.date.php" target="_blank"><?php _e('Get it from this link.', 'wpast'); ?></a>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e('Auto redirect', 'wpast'); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="auto-redirect" value="1" <?php echo checked($options->get_option('auto-redirect'), 1); ?>>
                <?php _e('Auto redirect after submitting the ticket', 'wpast'); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-words-filter"><?php _e('Words filter', 'wpast'); ?></label>
        <textarea class="uk-textarea" id="wpast-words-filter" name="words-filter" rows="10"><?php echo esc_textarea($options->get_option('words-filter')); ?></textarea>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <?php _e('Put each item in separate line.', 'wpast'); ?>
            <code><?php _e('original word:filtered word', 'wpast'); ?></code>
        </div>
    </div>
</div>