<?php
defined( 'ABSPATH' ) || exit( 'No Access!' );

$submit_type = $options->get_option('submit-type');
$default_department = $options->get_option( 'default-department' );
$department_manager = new WPAST_Department_Manager();
$child_departments = $department_manager->get_child_departments();
$blocked_departments = $options->get_option( 'blocked-departments' );
$admin_orderby = $options->get_option( 'admin-orderby' );
$icon_position = $options->get_option( 'icon-position' );
$icon_image = $options->get_option( 'icon-image' );
$orderby = $options->get_option( 'orderby' );
$replies_order = $options->get_option( 'replies-order' );
?>
<div class="wpast-settings-area wpast-settings-general wpast-active">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="settings"></span></span>
        <strong><?php _e( 'General', 'wpast' ); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Submit type', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="submit-type" value="single" <?php checked( $submit_type, 'single' ); ?>>
                <?php _e( 'Single step', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="submit-type" value="multi" <?php checked( $submit_type, 'multi' ); ?>>
                <?php _e( 'Multi step', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="submit-type" value="child-department" <?php checked( $submit_type, 'child-department' ); ?>>
                <?php _e( 'Only child department', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin default-department-wrapper">
        <label class="uk-form-label"><?php _e( 'Default department', 'wpast' ); ?></label>
        <?php if ( is_array( $child_departments ) && count( $child_departments ) ): ?>
            <?php foreach ( $child_departments as $child_department ): ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-radio default-department" type="radio" name="default-department" value="<?php echo esc_attr( $child_department->ID ); ?>" <?php checked($child_department->ID, $default_department) ?>>
                        <?php echo esc_html( $child_department->name ); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-ticket-page">
            <?php _e( 'Ticket page', 'wpast' ); ?>
            <?php echo '<a href="' . get_permalink($options->get_option('ticket-page')) . '" class="wpast-view-page uk-text-primary" target="_blank"> (' . __('View page', 'wpast') . ')</a>'; ?>
        </label>
        <div uk-form-custom="target: > * > span:first-child">
			<?php
			wp_dropdown_pages( [
				'post_type'        => 'page',
				'selected'         => $options->get_option( 'ticket-page' ),
				'name'             => 'ticket-page',
				'class'            => 'wpast-confirm',
				'show_option_none' => __( 'None', 'wpast' ),
				'echo'             => 1,
			] );
			?>
            <button class="wpast-confirm uk-button uk-button-default" type="button" tabindex="-1">
                <span></span>
                <span uk-icon="icon: chevron-down"></span>
            </button>
        </div>
        <div class="wpast-confirm-activation" id="wpast-ticket-page">
            <span uk-icon="warning"></span>
			<?php _e( 'Ticket item will be automatically added to the user panel on the woocommerce sites.', 'wpast' ); ?>
        </div>
        <div class="wpast-description">
            <span uk-icon="info"></span>
	        <?php _e( 'For none woocommerce sites and guest ticket put this shortcode in a page:', 'wpast' ); ?>
            <code class="wpast-clipboard" uk-tooltip="title: <?php _e( 'Click to copy in clipboard.', 'wpast' ); ?>">[wpast-ticket-panel]</code>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-panel-url"><?php _e( 'Panel URL', 'wpast' ); ?></label>
        <input type="text" class="uk-input" id="wpast-panel-url" name="panel-url" value="<?php echo esc_attr( $options->get_option( 'panel-url' ) ); ?>">
        <div class="wpast-description">
            <span uk-icon="info"></span>
		    <?php _e( 'If you use the user panel plugin, enter the panel link.', 'wpast' ); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-login-url"><?php _e( 'Login URL', 'wpast' ); ?></label>
        <input type="text" class="uk-input" id="wpast-login-url" name="login-url" value="<?php echo esc_attr( $options->get_option( 'login-url' ) ); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Blocked departments', 'wpast' ); ?></label>
		<?php if ( is_array( $child_departments ) && count( $child_departments ) ): ?>
			<?php foreach ( $child_departments as $child_department ): ?>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="blocked-departments[]" value="<?php echo esc_attr( $child_department->ID ); ?>" <?php echo is_array( $blocked_departments ) && in_array( $child_department->ID, $blocked_departments ) ? 'checked' : null; ?>>
						<?php echo esc_html( $child_department->name ); ?>
                    </label>
                </div>
			<?php endforeach; ?>
		<?php endif; ?>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Admin orderby', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="admin-orderby" value="creation-date" <?php checked( $admin_orderby, 'creation-date' ); ?>>
				<?php _e( 'Creation date', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="admin-orderby" value="last-reply" <?php checked( $admin_orderby, 'last-reply' ); ?>>
				<?php _e( 'Last reply date', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Support icon', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="support-icon" value="1" <?php echo checked( $options->get_option( 'support-icon' ), 1 ); ?>>
				<?php _e( 'Active', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <div uk-form-custom="target: > * > span:first-child">
                <select name="icon-position">
                    <option value="right" <?php selected( $icon_position, 'right' ); ?>><?php _e( 'Right', 'wpast' ); ?></option>
                    <option value="left" <?php selected( $icon_position, 'left' ); ?>><?php _e( 'Left', 'wpast' ); ?></option>
                </select>
                <button class="uk-button uk-button-default" type="button" tabindex="-1">
                    <span></span>
                    <span uk-icon="icon: chevron-down"></span>
                </button>
            </div>
        </div>
        <div class="uk-margin-small">
            <div class="wpast-upload-file-wrapper">
                <img src="<?php echo intval($icon_image) ? wp_get_attachment_url( $icon_image ) : WPAST_IMG_URL.'question.png'; ?>" class="wpast-image" alt="image">
                <input type="hidden" name="icon-image" value="<?php echo esc_attr( $icon_image ); ?>">
                <br>
                <button class="uk-button uk-button-primary wpast-upload-file"><?php _e('Select image', 'wpast'); ?></button>
                <button class="uk-button uk-button-default wpast-remove" data-default="<?php echo WPAST_IMG_URL.'question.png'; ?>"><?php _e('Remove image', 'wpast'); ?></button>
            </div>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Orderby', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="orderby" value="creation-date" <?php checked( $orderby, 'creation-date' ); ?>>
				<?php _e( 'Creation date', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-radio" type="radio" name="orderby" value="last-reply" <?php checked( $orderby, 'last-reply' ); ?>>
				<?php _e( 'Last reply date', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label" for="wpast-per-page"><?php _e( 'Tickets per page', 'wpast' ); ?></label>
        <input type="number" class="uk-input" id="wpast-per-page" name="per-page" value="<?php echo esc_attr( $options->get_option( 'per-page' ) ); ?>">
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Replies order', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <div uk-form-custom="target: > * > span:first-child">
                <select name="replies-order">
                    <option value="desc" <?php selected( $replies_order, 'desc' ); ?>><?php _e( 'Descending', 'wpast' ); ?></option>
                    <option value="asc" <?php selected( $replies_order, 'asc' ); ?>><?php _e( 'Ascending', 'wpast' ); ?></option>
                </select>
                <button class="uk-button uk-button-default" type="button" tabindex="-1">
                    <span></span>
                    <span uk-icon="icon: chevron-down"></span>
                </button>
            </div>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Auto close', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="auto-close" value="1" <?php echo checked( $options->get_option( 'auto-close' ), 1 ); ?>>
				<?php _e( 'Active', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <input type="number" class="uk-input" name="auto-close-period" value="<?php echo esc_attr( $options->get_option( 'auto-close-period' ) ); ?>" placeholder="<?php _e( 'Period', 'wpast' ); ?>">
            <div class="wpast-description">
                <span uk-icon="info"></span>
				<?php _e( 'The length of time since the last ticket reply exceeds this number of days.', 'wpast' ); ?>
            </div>
        </div>
        <div class="uk-margin-small">
            <textarea class="uk-textarea" name="auto-close-text" rows="5" placeholder="<?php _e( 'Text', 'wpast' ); ?>"><?php echo esc_textarea( $options->get_option( 'auto-close-text' ) ); ?></textarea>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Guest ticket', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="guest-ticket" value="1" <?php echo checked( $options->get_option( 'guest-ticket' ), 1 ); ?>>
				<?php _e( 'Active', 'wpast' ); ?>
            </label>
            <?php echo wpast_update_notice(); ?>
        </div>
        <div class="uk-margin-small">
            <input type="text" class="uk-input" name="recaptcha-site-key" value="<?php echo esc_attr( $options->get_option( 'recaptcha-site-key' ) ); ?>" placeholder="<?php _e( 'Public key', 'wpast' ); ?>">
        </div>
        <div class="uk-margin-small">
            <input type="text" class="uk-input" name="recaptcha-secret-key" value="<?php echo esc_attr( $options->get_option( 'recaptcha-secret-key' ) ); ?>" placeholder="<?php _e( 'Private key', 'wpast' ); ?>">
        </div>
        <div class="wpast-description">
            <span uk-icon="info"></span>
            <a href="https://www.google.com/recaptcha/admin" target="_blank"><?php _e( 'Get from this link.', 'wpast' ); ?></a>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Login form', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="login-form" value="1" <?php echo checked( $options->get_option( 'login-form' ), 1 ); ?>>
                <?php _e( 'Active', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Default rating', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="default-rating" value="1" <?php echo checked( $options->get_option( 'default-rating' ), 1 ); ?>>
                <?php _e( 'Active', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Auto answer', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="auto-answer" value="1" <?php echo checked( $options->get_option( 'auto-answer' ), 1 ); ?>>
                <?php _e( 'Active', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <?php wp_editor($options->get_option('auto-answer-content'), 'auto-answer-content', ['editor_height' => 256]); ?>
        </div>
    </div>
</div>