<?php
defined( 'ABSPATH' ) || exit( 'No Access!' );

$fields = $options->get_option( 'fields' );
$fields = $fields ? $fields : [];
?>
<div class="wpast-settings-area wpast-settings-fields">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="menu"></span></span>
        <strong><?php _e( 'Fields', 'wpast' ); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Name', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[name][guest]" value="1" <?php echo isset( $fields['name']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Mobile', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[mobile][guest]" value="1" <?php echo isset( $fields['mobile']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[mobile][register]" value="1" <?php echo isset( $fields['mobile']['register'] ) ? 'checked' : null; ?>>
				<?php _e( 'Register form', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Email', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[email][guest]" value="1" <?php echo isset( $fields['email']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[email][register]" value="1" <?php echo isset( $fields['email']['register'] ) ? 'checked' : null; ?>>
				<?php _e( 'Register form', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Priority', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[priority][logged-in]" value="1" <?php echo isset( $fields['priority']['logged-in'] ) ? 'checked' : null; ?>>
				<?php _e( 'Logged in user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[priority][guest]" value="1" <?php echo isset( $fields['priority']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Product', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[product][logged-in]" value="1" <?php echo isset( $fields['product']['logged-in'] ) ? 'checked' : null; ?>>
				<?php _e( 'Logged in user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[product][guest]" value="1" <?php echo isset( $fields['product']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Extra fields', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[fields][logged-in]" value="1" <?php echo isset( $fields['fields']['logged-in'] ) ? 'checked' : null; ?>>
				<?php _e( 'Logged in user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[fields][guest]" value="1" <?php echo isset( $fields['fields']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'File upload', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[file][logged-in]" value="1" <?php echo isset( $fields['file']['logged-in'] ) ? 'checked' : null; ?>>
				<?php _e( 'Logged in user', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="fields[file][guest]" value="1" <?php echo isset( $fields['file']['guest'] ) ? 'checked' : null; ?>>
				<?php _e( 'Guest user', 'wpast' ); ?>
            </label>
        </div>
    </div>
</div>