<?php defined('ABSPATH') || exit('No Access!'); ?>
<div class="wpast-settings-area wpast-settings-emails">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="mail"></span></span>
        <strong><?php _e('Emails', 'wpast'); ?></strong>
    </h2>
    <ul uk-tab>
        <li class="uk-active"><a href="#"><?php _e('Global', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Create ticket', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Submit ticket', 'wpast'); ?></a></li>
        <li><a href="#"><?php _e('Submit reply', 'wpast'); ?></a></li>
    </ul>
    <ul class="uk-switcher uk-margin">
        <li>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-email-from"><?php _e('Email from', 'wpast'); ?></label>
                <input type="email" class="uk-input" id="wpast-email-from" name="email-from" value="<?php echo esc_attr($options->get_option('email-from')); ?>">
            </div>
            <div class="uk-margin">
                <label class="uk-form-label" for="wpast-from-name"><?php _e('From name', 'wpast'); ?></label>
                <input type="text" class="uk-input" id="wpast-from-name" name="from-name" value="<?php echo esc_attr($options->get_option('from-name')); ?>">
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <div class="wpast-description">
                    <span uk-icon="info"></span>
                    <?php _e('This notification will be sent to the ticket creator.', 'wpast'); ?>
                </div>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-create-email" value="1" <?php echo checked($options->get_option('user-create-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="user-create-email-subject" value="<?php echo esc_attr($options->get_option('user-create-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('user-create-email-content'), 'user-create-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="user-create-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                    <?php include(WPAST_TPL_PATH . 'admin/settings/default-email.php'); ?>
                    <table class="wpast-code-table">
                        <tbody>
                        <tr>
                            <td><?php _e('Ticket ID', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{ticket_id}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Token', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{token}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Title', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{title}}</code></td>
                        </tr>
                        <tr>
                            <td><?php _e('Content', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{content}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('User name', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{user_name}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Recipient name', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{recipient_name}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Department', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{department}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Status', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{status}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Priority', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{priority}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Date', 'wpast'); ?></td>
                            <td><code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{date}}</code></td>
                        </tr>
                        <tr>
                            <td><?php _e('Product', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{product}}</code>
                            </td>
                        </tr>
                        <tr>
                            <td><?php _e('Reply link', 'wpast'); ?></td>
                            <td>
                                <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{reply_link}}</code>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Admin', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="admin-ticket-email" value="1" <?php echo checked($options->get_option('admin-ticket-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="admin-ticket-email-subject" value="<?php echo esc_attr($options->get_option('admin-ticket-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('admin-ticket-email-content'), 'admin-ticket-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="admin-ticket-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('User', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-ticket-email" value="1" <?php echo checked($options->get_option('user-ticket-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="user-ticket-email-subject" value="<?php echo esc_attr($options->get_option('user-ticket-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('user-ticket-email-content'), 'user-ticket-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="user-ticket-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Vendor', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-ticket-email" value="1" <?php echo checked($options->get_option('vendor-ticket-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="vendor-ticket-email-subject" value="<?php echo esc_attr($options->get_option('vendor-ticket-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('vendor-ticket-email-content'), 'vendor-ticket-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="vendor-ticket-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
        </li>
        <li>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Admin', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="admin-reply-email" value="1" <?php echo checked($options->get_option('admin-reply-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="admin-reply-email-subject" value="<?php echo esc_attr($options->get_option('admin-reply-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('admin-reply-email-content'), 'admin-reply-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="admin-reply-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('User', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="user-reply-email" value="1" <?php echo checked($options->get_option('user-reply-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="user-reply-email-subject" value="<?php echo esc_attr($options->get_option('user-reply-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('user-reply-email-content'), 'user-reply-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="user-reply-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label"><?php _e('Vendor', 'wpast'); ?></label>
                <div class="uk-margin-small">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="vendor-reply-email" value="1" <?php echo checked($options->get_option('vendor-reply-email'), 1); ?>>
                        <?php _e('Active', 'wpast'); ?>
                    </label>
                </div>
                <div class="uk-margin-small">
                    <input type="text" class="uk-input" name="vendor-reply-email-subject" value="<?php echo esc_attr($options->get_option('vendor-reply-email-subject')); ?>" placeholder="<?php _e('Subject', 'wpast'); ?>">
                </div>
                <div class="uk-margin-small">
                    <?php wp_editor($options->get_option('vendor-reply-email-content'), 'vendor-reply-email-content', ['editor_height' => 256]); ?>
                    <a href="#" class="wpast-default-email uk-button uk-button-secondary uk-button-small" data-toggle="vendor-reply-email-content"><?php _e('Insert default email', 'wpast'); ?></a>
                </div>
            </div>
        </li>
    </ul>
</div>