<?php
defined( 'ABSPATH' ) || exit( 'No Access!' );

$all_roles = wpast_get_editable_roles();
$roles = $options->get_option( 'user-roles' );
?>
<div class="wpast-settings-area wpast-settings-access">
    <h2 class="wpast-settings-title">
        <span class="wpast-title-icon"><span uk-icon="lock"></span></span>
        <strong><?php _e( 'Access', 'wpast' ); ?></strong>
    </h2>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'User roles', 'wpast' ); ?></label>
		<?php foreach ( $all_roles as $role => $details ): ?>
            <div class="uk-margin-small">
                <label>
                    <input class="uk-checkbox" type="checkbox" name="user-roles[]" value="<?php echo $role; ?>" <?php echo ( is_array( $roles ) && in_array( $role, $roles ) ) || $role == 'administrator' ? 'checked' : null; ?> <?php echo $role == 'administrator' ? 'disabled' : null; ?>>
					<?php echo translate_user_role( $details['name'] ); ?>
                </label>
            </div>
		<?php endforeach; ?>
        <div class="wpast-description">
            <span uk-icon="info"></span>
			<?php _e( 'Select the user roles to access the ticket panel in admin section.', 'wpast' ); ?>
        </div>
    </div>
    <div class="uk-margin">
        <label class="uk-form-label"><?php _e( 'Access limit', 'wpast' ); ?></label>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="access-limit" value="1" <?php echo checked( $options->get_option( 'access-limit' ), 1 ); ?>>
				<?php _e( 'By selecting this option, each answerable user will only have access to their own ticket.', 'wpast' ); ?>
            </label>
        </div>
        <div class="uk-margin-small">
            <label>
                <input class="uk-checkbox" type="checkbox" name="limit-submit" value="1" <?php echo checked( $options->get_option( 'limit-submit' ), 1 ); ?>>
				<?php _e( 'With this option enabled only the admin role can send new tickets.', 'wpast' ); ?>
            </label>
        </div>
    </div>
</div>