<?php defined( 'ABSPATH' ) || exit( 'No Access!' ); ?>
<?php if ( count( $_processes ) ): ?>
    <ul class="wpast-processes">
		<?php $i = 1; ?>
		<?php foreach ( $_processes as $process ): ?>
            <li>
                <div class="wpast-process-title">
                    <p><?php echo esc_html( $process['title'] ); ?></p>
                </div>
                <p class="meta">
					<?php $user_data = get_userdata( $process['user_id'] ); ?>
                    <a href="<?php echo get_edit_user_link( $process['user_id'] ); ?>" class="wpast-process-user" target="_blank"><?php echo $user_data->display_name; ?></a>
                    <abbr class="wpast-process-date" title="<?php echo esc_html( wpast_format_date( $process['date'] ) ); ?>"><?php echo esc_html( wpast_format_date( $process['date'], 'Y-m-d' ) ); ?></abbr>
                    <a href="#" class="wpast-delete-process" data-ticket-id="<?php echo esc_attr( $ticket->ID ); ?>" data-index="<?php echo $i; ?>" onclick="return confirm('<?php echo __( 'Are you sure you want to delete?', 'wpast' ); ?>')"><?php _e( 'Delete', 'wpast' ) ?></a>
                </p>
            </li>
			<?php $i ++; ?>
		<?php endforeach; ?>
    </ul>
<?php endif; ?>