<?php defined( 'ABSPATH' ) || exit( __( 'No Access!', 'wpast' ) ); ?>
<div class="wpast-fields wrap nosubsub">
    <h1 class="wp-heading-inline"><?php _e( 'Ticket fields', 'wpast' ); ?></h1>
    <hr class="wp-header-end">
    <div id="ajax-response"></div>
    <div id="col-container" class="wp-clearfix">
        <div id="col-left">
            <div class="col-wrap">
                <div class="form-wrap">
                    <h2><?php _e( 'Add new field', 'wpast' ); ?></h2>
                    <form id="wpast-add-field" method="post">
						<?php wp_nonce_field( 'add_field', 'add_field_nonce' ); ?>
                        <div class="form-field">
                            <label for="wpast-label"><?php _e( 'Label', 'wpast' ); ?></label>
                            <input type="text" class="regular-text" name="label" id="wpast-label">
                        </div>
                        <div class="form-field">
                            <label for="wpast-type"><?php _e( 'Type', 'wpast' ); ?></label>
                            <select name="type" id="wpast-type">
                                <option value="single-line-text"><?php _e( 'Single line text', 'wpast' ); ?></option>
                                <option value="multi-line-text"><?php _e( 'Multi line text', 'wpast' ); ?></option>
                                <option value="number"><?php _e( 'Number', 'wpast' ); ?></option>
                                <option value="dropdown"><?php _e( 'Dropdown', 'wpast' ); ?></option>
                                <option value="radio"><?php _e( 'Radio', 'wpast' ); ?></option>
                                <option value="checkbox"><?php _e( 'Checkbox', 'wpast' ); ?></option>
                            </select>
                        </div>
                        <div class="form-field">
                            <input type="checkbox" name="required" id="wpast-required">
                            <label for="wpast-required" style="display: inline-block;"><?php _e( 'Required', 'wpast' ); ?></label>
                        </div>
                        <div class="form-field">
                            <input type="checkbox" name="once" id="wpast-once">
                            <label for="wpast-once" style="display: inline-block;"><?php _e( 'Get value only once from user.', 'wpast' ); ?></label>
                        </div>
                        <div class="form-field">
                            <label for="wpast-options"><?php _e( 'Options', 'wpast' ); ?></label>
                            <textarea class="regular-text" name="options" id="wpast-options" rows="5"></textarea>
                            <p class="description"><?php _e( 'Put each item in a line.', 'wpast' ); ?></p>
                        </div>
                        <div class="form-field">
                            <label for="wpast-position"><?php _e( 'Position', 'wpast' ); ?></label>
                            <input type="number" class="small-text" name="position" id="wpast-position">
                        </div>
                        <p class="submit">
                            <input type="submit" name="submit" class="button button-primary" value="<?php _e( 'Add new', 'wpast' ); ?>">
                        </p>
                    </form>
                </div>
            </div>
        </div>
        <div id="col-right">
            <div class="col-wrap">
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                    <tr>
                        <th scope="col" class="manage-column"><?php _e( 'Label', 'wpast' ); ?></th>
                        <th scope="col" class="manage-column"><?php _e( 'Type', 'wpast' ); ?></th>
                        <th scope="col" class="manage-column"><?php _e( 'Position', 'wpast' ); ?></th>
                    </tr>
                    </thead>
                    <tbody id="the-list">
					<?php if ( is_array( $fields ) && count( $fields ) ): ?>
						<?php foreach ( $fields as $field ): ?>
                            <tr>
                                <td>
									<?php echo esc_html( $field->label ); ?>
                                    <br>
                                    <div class="row-actions">
                                        <span class="edit"><a href="<?php echo esc_url( admin_url( 'admin.php?page=wpast-fields&action=edit&id=' . $field->ID ) ); ?>"><?php _e( 'Edit', 'wpast' ); ?></a> | </span>
                                        <span class="delete"><a href="<?php echo wp_nonce_url( admin_url( 'admin.php?page=wpast-fields&action=delete&id=' . $field->ID ), 'delete-field', 'delete-field-nonce' ); ?>"><?php _e( 'Delete', 'wpast' ); ?></a></span>
                                    </div>
                                </td>
                                <td><?php _e( ucfirst( str_replace( '-', ' ', esc_html( $field->type ) ) ), 'wpast' ); ?></td>
                                <td><?php echo esc_html( $field->position ); ?></td>
                            </tr>
						<?php endforeach; ?>
					<?php endif; ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th scope="col" class="manage-column"><?php _e( 'Label', 'wpast' ); ?></th>
                        <th scope="col" class="manage-column"><?php _e( 'Type', 'wpast' ); ?></th>
                        <th scope="col" class="manage-column"><?php _e( 'Position', 'wpast' ); ?></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>