<?php defined( 'ABSPATH' ) || exit( 'No Access!' ); ?>
<div class="<?php echo $is_edit ? 'wpast-edit-process' : 'wpast-new-process'; ?> wrap">
    <h1 class="wp-heading-inline"><?php echo $is_edit ? __( 'Edit process', 'wpast' ) : __( 'New process', 'wpast' ); ?></h1>
    <a href="?page=wpast-processes" class="page-title-action"><?php _e( 'Processes', 'wpast' ); ?></a>
    <hr class="wp-header-end">
	<?php WPAST_Flash_Message::show_message(); ?>
    <form method="post" class="process-form">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content">
                    <div class="wpast-inner">
                        <div id="titlediv">
                            <div id="titlewrap">
                                <input type="text" id="title" name="title" value="<?php echo $is_edit ? esc_attr( $process->title ) : null; ?>" placeholder="<?php _e( 'Enter title here', 'wpast' ); ?>" autocomplete="off">
                            </div>
                        </div>
                        <div id="postdivrich">
                            <div id="wp-content-wrap" class="wp-core-ui wp-editor-wrap">
								<?php
								$email_content = $is_edit ? $process->email_content : null;
								wp_editor( $email_content, 'email-content', [ 'editor_height' => 326 ] );
								?>
                                <table class="wpast-code-table">
                                    <tbody>
                                    <tr>
                                        <td><?php _e( 'Ticket ID', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{ticket_id}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e('Token', 'wpast'); ?></td>
                                        <td>
                                            <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{token}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Title', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{title}}</code></td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Content', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{content}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'User name', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{user_name}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Recipient name', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{recipient_name}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Department', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{department}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Status', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{status}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Priority', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{priority}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Date', 'wpast' ); ?></td>
                                        <td><code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{date}}</code></td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Product', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{product}}</code>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php _e( 'Reply link', 'wpast' ); ?></td>
                                        <td>
                                            <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{reply_link}}</code>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="postbox-container" id="wpast-sms-div">
                                <div class="postbox">
                                    <h2 class="hndle">
                                        <span><?php _e( 'SMS content', 'wpast' ); ?></span>
                                    </h2>
                                    <div class="inside">
                                        <textarea class="regular-text" name="sms-content" rows="10"><?php echo $is_edit ? esc_textarea( $process->sms_content ) : null; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <table class="wpast-code-table">
                                <tbody>
                                <tr>
                                    <td><?php _e( 'Ticket ID', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{ticket_id}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e('Token', 'wpast'); ?></td>
                                    <td>
                                        <code uk-tooltip="title: <?php _e('Click to copy', 'wpast'); ?>">{{token}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Title', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{title}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Content', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{content}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'User name', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{user_name}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Recipient name', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{recipient_name}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Department', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{department}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Status', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{status}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Priority', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{priority}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Date', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{date}}</code>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php _e( 'Product', 'wpast' ); ?></td>
                                    <td>
                                        <code title="<?php _e( 'Click to copy', 'wpast' ); ?>">{{product}}</code>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="postbox-container-1" class="postbox-container">
                    <div id="submitdiv" class="postbox">
                        <h2 class="hndle"><span><?php _e( 'Save', 'wpast' ); ?></span></h2>
                        <div class="inside">
                            <div id="minor-publishing">
                                <div id="misc-publishing-actions">
                                    <div class="misc-pub-section">
                                        <label for="wpast-position"><?php _e( 'Position', 'wpast' ); ?></label>
                                        <input type="number" class="regular-text" id="wpast-position" name="position" value="<?php echo $is_edit ? esc_attr( $process->position ) : null; ?>">
                                    </div>
                                </div>
                            </div>
                            <div id="major-publishing-actions">
                                <div class="submitbox" id="submitpost">
                                    <div id="publishing-action">
                                        <input type="submit" name="publish" id="publish" class="button button-primary button-large" value="<?php _e( 'Save', 'wpast' ); ?>">
                                    </div>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br class="clear">
        </div>
		<?php wp_nonce_field( 'process_security', 'process_nonce' ); ?>
    </form>
</div>