<?php defined( 'ABSPATH' ) || exit( __( 'No Access!', 'wpast' ) ); ?>
<div class="wpast-edit-field wrap">
    <h1><?php _e( 'Edit field', 'wpast' ); ?></h1>
    <form id="wpast-edit-field" method="post">
		<?php wp_nonce_field( 'edit_field', 'edit_field_nonce' ); ?>
        <table class="form-table" role="presentation">
            <tbody>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-label"><?php _e( 'Label', 'wpast' ); ?></label>
                </th>
                <td>
                    <input type="text" name="label" id="wpast-label" value="<?php echo esc_attr( $field->label ); ?>">
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-type"><?php _e( 'Type', 'wpast' ); ?></label>
                </th>
                <td>
                    <select name="type" id="wpast-type">
                        <option value="single-line-text" <?php selected( $field->type, 'single-line-text' ); ?>><?php _e( 'Single line text', 'wpast' ); ?></option>
                        <option value="multi-line-text" <?php selected( $field->type, 'multi-line-text' ); ?>><?php _e( 'Multi line text', 'wpast' ); ?></option>
                        <option value="number" <?php selected( $field->type, 'number' ); ?>><?php _e( 'Number', 'wpast' ); ?></option>
                        <option value="dropdown" <?php selected( $field->type, 'dropdown' ); ?>><?php _e( 'Dropdown', 'wpast' ); ?></option>
                        <option value="radio" <?php selected( $field->type, 'radio' ); ?>><?php _e( 'Radio', 'wpast' ); ?></option>
                        <option value="checkbox" <?php selected( $field->type, 'checkbox' ); ?>><?php _e( 'Checkbox', 'wpast' ); ?></option>
                    </select>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row"><?php _e( 'Required', 'wpast' ); ?></th>
                <td>
                    <input type="checkbox" name="required" id="wpast-required" <?php checked( $field->required, 1 ); ?>>
                    <label for="wpast-required"><?php _e( 'Active', 'wpast' ); ?></label>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row"><?php _e( 'Once', 'wpast' ); ?></th>
                <td>
                    <input type="checkbox" name="once" id="wpast-once" <?php checked( $field->once, 1 ); ?>>
                    <label for="wpast-once"><?php _e( 'Get value only once from user.', 'wpast' ); ?></label>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-options"><?php _e( 'Options', 'wpast' ); ?></label>
                </th>
                <td>
                    <textarea class="regular-text" name="options" id="wpast-options" rows="5"><?php echo esc_textarea( $field->options ); ?></textarea>
                    <p class="description"><?php _e( 'Put each item in a line.', 'wpast' ); ?></p>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-position"><?php _e( 'Position', 'wpast' ); ?></label>
                </th>
                <td>
                    <input type="number" class="small-text" name="position" id="wpast-position" value="<?php echo esc_attr( $field->position ); ?>">
                </td>
            </tr>
            </tbody>
        </table>
        <input type="submit" name="submit" class="button button-primary" value="<?php _e( 'Update', 'wpast' ); ?>">
    </form>
</div>