<?php
defined('ABSPATH') || exit(__('No Access!', 'wpast'));

$answerable = $answerable_manager->get_by_department($department->ID);
$fields = $department->fields;
$fields = $fields ? unserialize($fields) : [];
?>
<div class="wpast-edit-department wrap">
    <h1><?php _e('Edit department', 'wpast'); ?></h1>
    <form id="wpast-edit-department" method="post">
        <?php wp_nonce_field('edit_department', 'edit_department_nonce'); ?>
        <table class="form-table" role="presentation">
            <tbody>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-name"><?php _e('Name', 'wpast'); ?></label>
                </th>
                <td>
                    <input type="text" name="name" id="wpast-name" value="<?php echo esc_attr($department->name); ?>">
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-parent"><?php _e('Parent', 'wpast'); ?></label>
                </th>
                <td>
                    <select name="parent" id="wpast-parent">
                        <option value="0"><?php _e('None', 'wpast'); ?></option>
                        <?php if (is_array($departments) && count($departments)): ?>
                            <?php foreach ($departments as $depart): ?>
                                <?php
                                if ($depart->ID == $id || $depart->parent) {
                                    continue;
                                }
                                ?>
                                <option value="<?php echo esc_attr($depart->ID); ?>" <?php selected($department->parent, $depart->ID); ?>><?php echo esc_html($depart->name); ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-answerable"><?php _e('Answerable users', 'wpast'); ?></label>
                </th>
                <td>
                    <select id="wpast-answerable" name="answerable[]" multiple>
                        <?php
                        if (count($answerable)) {
                            foreach ($answerable as $user_id) {
                                $user_data = get_userdata($user_id);
                                echo '<option value="' . esc_attr($user_id) . '" selected>' . $user_data->user_login . '</option>';
                            }
                        }
                        ?>
                    </select>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-position"><?php _e('Position', 'wpast'); ?></label>
                </th>
                <td>
                    <input type="number" class="small-text" name="position" id="wpast-position" value="<?php echo esc_attr($department->position); ?>">
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-description"><?php _e('Description', 'wpast'); ?></label>
                </th>
                <td>
                    <textarea name="description" id="wpast-description" rows="5" cols="40"><?php echo esc_textarea($department->description); ?></textarea>
                </td>
            </tr>
            <tr class="form-field">
                <th scope="row">
                    <label for="wpast-description"><?php _e('Fields', 'wpast'); ?></label>
                </th>
                <td>
                    <?php if ($department->parent && is_array($all_fields) && count($all_fields)): ?>
                        <?php foreach ($all_fields as $field): ?>
                            <div style="margin-bottom: 10px;">
                                <input type="checkbox" id="wpast-field-<?php echo esc_attr($field->ID); ?>" name="fields[]" value="<?php echo esc_attr($field->ID); ?>" <?php echo in_array($field->ID, $fields) ? 'checked' : ''; ?>>
                                <label for="wpast-field-<?php echo esc_attr($field->ID); ?>"><?php echo esc_html($field->label); ?></label>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <?php echo wpast_update_notice(); ?>
                </td>
            </tr>
            </tbody>
        </table>
        <input type="submit" name="submit" class="button button-primary" value="<?php _e('Update', 'wpast'); ?>">
    </form>
</div>