<?php defined( 'ABSPATH' ) || exit( 'No Access!' ); ?>
<div class="<?php echo $is_edit ? 'wpast-edit-pre-answer' : 'wpast-new-pre-answer'; ?> wrap">
    <h1 class="wp-heading-inline"><?php echo $is_edit ? __( 'Edit pre answer', 'wpast' ) : __( 'New pre answer', 'wpast' ); ?></h1>
    <a href="?page=wpast-pre-answers" class="page-title-action"><?php _e( 'Pre answers', 'wpast' ); ?></a>
    <hr class="wp-header-end">
	<?php WPAST_Flash_Message::show_message(); ?>
    <form method="post" class="pre-answer-form">
        <input type="hidden" name="user-id" value="<?php echo $user_id; ?>">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content">
                    <div class="wpast-inner">
                        <div id="titlediv">
                            <div id="titlewrap">
                                <input type="text" id="title" name="title" value="<?php echo $is_edit ? esc_attr( $pre_answer->title ) : null; ?>" placeholder="<?php _e( 'Enter title here', 'wpast' ); ?>" autocomplete="off">
                            </div>
                        </div>
                        <div id="postdivrich">
                            <div id="wp-content-wrap" class="wp-core-ui wp-editor-wrap">
								<?php
								$content = $is_edit ? $pre_answer->content : null;
								wp_editor( $content, 'wpast-content', [ 'editor_height' => 326 ] );
								?>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="postbox-container-1" class="postbox-container">
                    <div id="submitdiv" class="postbox">
                        <h2 class="hndle"><span><?php _e( 'Save', 'wpast' ); ?></span></h2>
                        <div class="inside">
                            <div id="minor-publishing">
                                <div id="misc-publishing-actions">
                                    <div class="misc-pub-section">
                                        <label for="wpast-position"><?php _e( 'Position', 'wpast' ); ?></label>
                                        <input type="number" class="regular-text" id="wpast-position" name="position" value="<?php echo $is_edit ? esc_attr( $pre_answer->position ) : null; ?>">
                                    </div>
                                </div>
                            </div>
                            <div id="major-publishing-actions">
                                <div class="submitbox" id="submitpost">
                                    <div id="publishing-action">
                                        <input type="submit" name="publish" id="publish" class="button button-primary button-large" value="<?php _e( 'Save', 'wpast' ); ?>">
                                    </div>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br class="clear">
        </div>
		<?php wp_nonce_field( 'answer_security', 'answer_nonce' ); ?>
    </form>
</div>