<?php defined('ABSPATH') || exit(__('No Access!', 'wpast')); ?>
<div class="wpast-departments wrap nosubsub">
    <h1 class="wp-heading-inline"><?php _e('Ticket departments', 'wpast'); ?></h1>
    <hr class="wp-header-end">
    <div id="ajax-response"></div>
    <div id="col-container" class="wp-clearfix">
        <div id="col-left">
            <div class="col-wrap">
                <div class="form-wrap">
                    <h2><?php _e('Add new department', 'wpast'); ?></h2>
                    <form id="wpast-add-department" method="post">
                        <?php wp_nonce_field('add_department', 'add_department_nonce'); ?>
                        <div class="form-field">
                            <label for="wpast-name"><?php _e('Name', 'wpast'); ?></label>
                            <input type="text" name="name" id="wpast-name">
                        </div>
                        <div class="form-field term-parent-wrap">
                            <label for="wpast-parent"><?php _e('Parent', 'wpast'); ?></label>
                            <select name="parent" id="wpast-parent">
                                <option value="0"><?php _e('None', 'wpast'); ?></option>
                                <?php if (is_array($departments) && count($departments)): ?>
                                    <?php foreach ($departments as $department): ?>
                                        <?php
                                        if ($department->parent) {
                                            continue;
                                        }
                                        ?>
                                        <option value="<?php echo esc_attr($department->ID); ?>"><?php echo esc_html($department->name); ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="form-field">
                            <label for="wpast-answerable"><?php _e('Answerable users', 'wpast'); ?></label>
                            <select id="wpast-answerable" name="answerable[]" multiple></select>
                        </div>
                        <div class="form-field">
                            <label for="wpast-position"><?php _e('Position', 'wpast'); ?></label>
                            <input type="number" class="small-text" name="position" id="wpast-position">
                        </div>
                        <div class="form-field">
                            <label for="wpast-description"><?php _e('Description', 'wpast'); ?></label>
                            <textarea name="description" id="wpast-description" rows="5" cols="40"></textarea>
                        </div>
                        <div class="form-field wpast-form-field-fields">
                            <label for="wpast-description"><?php _e('Fields', 'wpast'); ?></label>
                            <?php if (is_array($all_fields) && count($all_fields)): ?>
                                <?php foreach ($all_fields as $field): ?>
                                    <div class="wpast-field">
                                        <input type="checkbox" id="wpast-field-<?php echo esc_attr($field->ID); ?>" name="fields[]" value="<?php echo esc_attr($field->ID); ?>">
                                        <label for="wpast-field-<?php echo esc_attr($field->ID); ?>" style="display: inline-block;"><?php echo esc_html($field->label); ?></label>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <?php echo wpast_update_notice(); ?>
                        </div>
                        <p class="submit">
                            <input type="submit" name="submit" class="button button-primary" value="<?php _e('Add new', 'wpast'); ?>">
                        </p>
                    </form>
                </div>
            </div>
        </div>
        <div id="col-right">
            <div class="col-wrap">
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                    <tr>
                        <th scope="col" class="manage-column"><?php _e('Name', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Parent', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Answerable users', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Position', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Tickets', 'wpast'); ?></th>
                    </tr>
                    </thead>
                    <tbody id="the-list">
                    <?php if (is_array($departments) && count($departments)): ?>
                        <?php foreach ($departments as $department): ?>
                            <tr>
                                <td>
                                    <strong><?php echo esc_html($department->name); ?></strong>
                                    <br>
                                    <div class="row-actions">
                                        <span class="edit"><a href="<?php echo esc_url(admin_url('admin.php?page=wpast-departments&action=edit&id=' . $department->ID)); ?>"><?php _e('Edit', 'wpast'); ?></a> | </span>
                                        <span class="delete"><a href="<?php echo wp_nonce_url(admin_url('admin.php?page=wpast-departments&action=delete&id=' . $department->ID), 'delete-department', 'delete-department-nonce'); ?>"><?php _e('Delete', 'wpast'); ?></a></span>
                                    </div>
                                </td>
                                <td>
                                    <?php
                                    $parent = $this->get_department($department->parent);
                                    echo $parent ? $parent->name : '__';
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    if ($department->parent) {
                                        $answerable = $answerable_manager->get_by_department($department->ID);
                                        if (count($answerable)) {
                                            foreach ($answerable as $user_id) {
                                                $user_data = get_userdata($user_id);
                                                echo $user_data ? '<p><a href="' . get_edit_user_link($user_id) . '" target="_blank">' . $user_data->display_name . '</a></p>' : '<p class="wpast-no-answerable">' . __('No user found with this ID:', 'wpast') . ' <strong>' . esc_html($user_id) . '</strong></p>';
                                            }
                                        } else {
                                            echo '<p class="wpast-no-answerable">' . __('No answerable!', 'wpast') . '</p>';
                                        }
                                    } else {
                                        echo '__';
                                    }
                                    ?>
                                </td>
                                <td><?php echo esc_html($department->position); ?></td>
                                <td><?php echo esc_html(number_format($ticket_manager->record_count(['department-id' => $department->ID]))); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th scope="col" class="manage-column"><?php _e('Name', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Parent', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Answerable users', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Position', 'wpast'); ?></th>
                        <th scope="col" class="manage-column"><?php _e('Tickets', 'wpast'); ?></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>