<?php defined( 'ABSPATH' ) || exit( 'No Access!' ); ?>
<?php if ( count( $annotations ) ): ?>
    <ul class="wpast-annotations">
		<?php $i = 1; ?>
		<?php foreach ( $annotations as $annotation ): ?>
            <li>
                <div class="wpast-annotation-content">
                    <p><?php echo esc_html( $annotation['content'] ); ?></p>
                </div>
                <p class="meta">
					<?php $user_data = get_userdata( $annotation['author_id'] ); ?>
                    <a href="<?php echo get_edit_user_link( $annotation['author_id'] ); ?>" class="wpast-annotation-author" target="_blank"><?php echo $user_data->display_name; ?></a>
                    <abbr class="wpast-annotation-date" title="<?php echo esc_html( wpast_format_date( $annotation['date'] ) ); ?>"><?php echo esc_html( wpast_format_date( $annotation['date'], 'Y-m-d' ) ); ?></abbr>
                    <a href="#" class="wpast-delete-annotation" data-ticket-id="<?php echo esc_attr( $ticket->ID ); ?>" data-index="<?php echo $i; ?>" onclick="return confirm('<?php echo __( 'Are you sure you want to delete?', 'wpast' ); ?>')"><?php _e( 'Delete', 'wpast' ) ?></a>
                </p>
            </li>
			<?php $i ++; ?>
		<?php endforeach; ?>
    </ul>
<?php endif; ?>