<?php
/**
 * Plugin Name: WP Advanced Support Ticket
 * Plugin URI: https://zhaket.com/web/wp-advanced-support-ticket
 * Description: This is a powerful plugin to build and maintain better customer relationships.
 * Version: 13.9.3
 * Author: S.Reza Salehi
 * Author URI: http://sreza-salehi.ir
 * Text Domain: wpast
 * Domain Path: /languages/
 */

defined('ABSPATH') || exit('No Access!');

$options = get_option('wpast_options');
if (is_array($options) && isset($options['repair-timezone']) && $options['repair-timezone'] == '1' && is_admin()) {
    $page = $_GET['page'] ?? null;
    $pages = ['wpast-tickets', 'wpast-edit-ticket', 'wpast-submit-ticket'];
    if (in_array($page, $pages)) {
        date_default_timezone_set(get_option('timezone_string'));
    }
}

if (!function_exists('get_plugin_data')) {
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

$plugin_data = get_plugin_data(__FILE__);
define('WPAST_BASENAME', plugin_basename(__FILE__));
define('WPAST_NAME', $plugin_data['Name']);
define('WPAST_VER', $plugin_data['Version']);
define('WPAST_URI', $plugin_data['PluginURI']);
define('WPAST_AUTHOR_URI', $plugin_data['AuthorURI']);
define('WPAST_AUTHOR_NAME', $plugin_data['AuthorName']);

require(trailingslashit(plugin_dir_path(__FILE__)) . 'core.php');