let intervalId = null;
let hour = 0;
let minute = 0;
let seconds = 0;
let totalSeconds = 0;

function startTimer() {
    ++totalSeconds;
    hour = Math.floor(totalSeconds / 3600);
    minute = Math.floor((totalSeconds - hour * 3600) / 60);
    seconds = totalSeconds - (hour * 3600 + minute * 60);

    hour = hour < 10 ? "0" + hour : hour;
    minute = minute < 10 ? "0" + minute : minute;
    seconds = seconds < 10 ? "0" + seconds : seconds;

    document.getElementById("hour").innerHTML = hour;
    document.getElementById("minute").innerHTML = minute;
    document.getElementById("seconds").innerHTML = seconds;
}

//webkitURL is deprecated but nevertheless
URL = window.URL || window.webkitURL;

var gumStream; 						//stream from getUserMedia()
var rec; 							//Recorder.js object
var input; 							//MediaStreamAudioSourceNode we'll be recording

// shim for AudioContext when it's not avb.
var AudioContext = window.AudioContext || window.webkitAudioContext;
var audioContext //audio context to help us record

var recordButton = document.getElementById("recordButton");
var stopButton = document.getElementById("stopButton");
var pauseButton = document.getElementById("pauseButton");

//add events to those 2 buttons
if (recordButton) {
    recordButton.addEventListener("click", startRecording);
}
if (stopButton) {
    stopButton.addEventListener("click", stopRecording);
}
if (pauseButton) {
    pauseButton.addEventListener("click", pauseRecording);
}

function startRecording(e) {
    e.preventDefault();
    console.log("recordButton clicked");

    this.classList.add("wpast-pulse-button");

    /*
        Simple constraints object, for more advanced audio features see
        https://addpipe.com/blog/audio-constraints-getusermedia/
    */

    var constraints = {audio: true, video: false}

    /*
       Disable the record button until we get a success or fail from getUserMedia()
   */

    recordButton.disabled = true;
    stopButton.disabled = false;
    //pauseButton.disabled = false

    /*
        We're using the standard promise based getUserMedia()
        https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia
    */

    navigator.mediaDevices.getUserMedia(constraints).then(function (stream) {
        console.log("getUserMedia() success, stream created, initializing Recorder.js ...");

        /*
            create an audio context after getUserMedia is called
            sampleRate might change after getUserMedia is called, like it does on macOS when recording through AirPods
            the sampleRate defaults to the one set in your OS for your playback device

        */
        audioContext = new AudioContext();

        //update the format
        document.getElementById("formats").innerHTML = "1 channel pcm @ " + audioContext.sampleRate / 1000 + "kHz"

        /*  assign to gumStream for later use  */
        gumStream = stream;

        /* use the stream */
        input = audioContext.createMediaStreamSource(stream);

        /*
            Create the Recorder object and configure to record mono sound (1 channel)
            Recording 2 channels  will double the file size
        */
        rec = new Recorder(input, {numChannels: 1})

        //start the recording process
        rec.record()

        console.log("Recording started");

        intervalId = setInterval(startTimer, 1000);

    }).catch(function (err) {
        //enable the record button if getUserMedia() fails
        recordButton.disabled = false;
        stopButton.disabled = true;
        pauseButton.disabled = true
    });
}

function pauseRecording(e) {
    e.preventDefault();
    console.log("pauseButton clicked rec.recording=", rec.recording);

    recordButton.classList.remove("wpast-pulse-button");

    if (rec.recording) {
        //pause
        rec.stop();
        pauseButton.innerHTML = '<img src="' + WPAST_DATA.img_url + 'play.svg" width="12" height="12" alt="play">';
        recordButton.classList.remove("wpast-pulse-button");
    } else {
        //resume
        rec.record()
        pauseButton.innerHTML = '<img src="' + WPAST_DATA.img_url + 'pause.svg" width="12" height="12" alt="pause">';
        recordButton.classList.add("wpast-pulse-button");

    }
}

function stopRecording(e) {
    e.preventDefault();
    console.log("stopButton clicked");

    recordButton.classList.remove("wpast-pulse-button");

    //disable the stop button, enable the record too allow for new recordings
    stopButton.disabled = true;
    recordButton.disabled = false;
    //pauseButton.disabled = true;

    //reset button just in case the recording is stopped while paused
    //pauseButton.innerHTML = '<img src="' + WPAST_DATA.img_url + 'pause.svg" width="12" height="12" alt="pause">';

    //tell the recorder to stop the recording
    rec.stop();

    //stop microphone access
    gumStream.getAudioTracks()[0].stop();

    //create the wav blob and pass it on to createDownloadLink
    rec.exportWAV(createDownloadLink);

    if (intervalId) {
        clearInterval(intervalId);
        totalSeconds = 0;
    }
}

function createDownloadLink(blob) {

    var url = URL.createObjectURL(blob);
    var audioDiv = document.createElement('div');
    var nameDiv = document.createElement('div');
    var au = document.createElement('audio');
    var li = document.createElement('li');
    var link = document.createElement('a');

    //name of .wav file to use during upload and download (without extendion)
    var filename = 'Voice_' + Math.round(new Date().getTime() / 1000) + '.wav';

    //add controls to the <audio> element
    au.controls = true;
    au.src = url;

    //save to disk link
    link.href = url;
    link.className = "download";
    link.download = filename + ".wav"; //download forces the browser to donwload the file using the  filename
    link.innerHTML = WPAST_DATA.download;

    //add the new audio element to li
    audioDiv.appendChild(au);
    li.appendChild(audioDiv);

    //add the filename to the li
    nameDiv.appendChild(document.createTextNode(filename));
    //li.appendChild(nameDiv);

    //add the save to disk link to li
    //li.appendChild(link);

    //upload link
    var upload = document.createElement('a');
    upload.href = "#";
    upload.className = "upload";
    upload.innerHTML = WPAST_DATA.upload;
    upload.addEventListener("click", function (event) {
        event.preventDefault();
        var targetElement = event.target;
        upload.innerHTML = WPAST_DATA.upload + '<img src="' + WPAST_DATA.img_url + 'oval.svg" class="loader" width="18" height="18" alt="pause">';
        var xhr = new XMLHttpRequest();
        xhr.onload = function (e) {
            if (this.readyState === 4) {
                console.log("Server returned: ", e.target.responseText);

                upload.innerHTML = WPAST_DATA.upload;

                var results = JSON.parse(e.target.responseText);
                if (results.success === true && results.url) {
                    var voiceFile = document.getElementById("recordingsList").nextElementSibling;
                    if (!voiceFile.value) {
                        voiceFile.value = results.url;
                    } else {
                        voiceFile.value = voiceFile.value + ',' + results.url;
                    }

                    targetElement.innerHTML = WPAST_DATA.completed;
                }
            }
        };
        var fd = new FormData();
        fd.append("audio_data", blob, filename);
        fd.append('action', 'wpast_upload_voice');
        fd.append('nonce', document.getElementsByName("wpast-nonce")[0].getAttribute('content'));
        var ajaxURL = document.querySelector("body").classList.contains("wp-admin") ? ajaxurl : WPAST_DATA.ajax_url;
        xhr.open("POST", ajaxURL, true);
        xhr.send(fd);
    })
    li.appendChild(document.createTextNode(" "))//add a space in between
    li.appendChild(upload)//add the upload link to li

    //add the li element to the ol
    recordingsList.appendChild(li);
}