jQuery(document).ready(function ($) {

    var menuItem = $('.wpast-menu-item a');
    menuItem.click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var $toggle = $this.data('toggle');
        $('.wpast-menu-item a').removeClass('wpast-active');
        $this.addClass('wpast-active');
        $('.wpast-settings-area').removeClass('wpast-active');
        $('.wpast-settings-' + $toggle).addClass('wpast-active');
    });

    $(".wpast-confirm").click(function () {
        var $this = $(this);
        var $toggle = $this.data('toggle');
        if (this.checked) {
            $('#wpast-' + $toggle).slideDown();
        } else {
            $('#wpast-' + $toggle).slideUp();
        }
    });
    $(".wpast-confirm").each(function () {
        var $this = $(this);
        if ($this.is(':checked')) {
            var $toggle = $this.data('toggle');
            $('#wpast-' + $toggle).show();
        }
    });

    var nonce = $('meta[name="wpast-nonce"]').attr('content');

    $('#wpast-settings-form').submit(function (e) {
        e.preventDefault();
        var $this = $(this);
        tinyMCE.triggerSave();
        var button = $this.find('.wpast-save');
        var loader = button.find('.loader');
        button.prop('disabled', true);
        loader.show();

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 20000,
            data: {
                action: 'wpast_update_settings',
                nonce: nonce,
                formData: $this.serialize()
            },
            success: function (response) {
                if (response.result === true) {
                    UIkit.notification({
                        message: WPAST_DATA.settings_saved,
                        status: 'success',
                        pos: 'bottom-center',
                        timeout: 5000
                    });
                }
            },
            error: function () {
                UIkit.notification({
                    message: WPAST_DATA.error_occurred,
                    status: 'danger',
                    pos: 'bottom-center',
                    timeout: 5000
                });
            },
            complete: function (data) {
                button.prop('disabled', false);
                loader.hide();
            }
        });
    });

    $('.wpast-new-fag').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $this.prev('div').before('<div class="uk-margin-small"><textarea class="uk-textarea" name="fags[]" rows="5"></textarea></div>');
    });

    $('.wpast-clipboard').click(function () {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(this).text()).select();
        document.execCommand("copy");
        $temp.remove();
    });

    $('.wpast-upload-file').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var image = wp.media({
            multiple: false,
        }).open().on('select', function (e) {
            var uploadedImage = image.state().get('selection').first();
            var imageID = uploadedImage.toJSON().id;
            var imageURL = uploadedImage.toJSON().url;
            $this.val(imageURL);
            $this.prev('br').prev('input[type="hidden"]').val(imageID);
            $this.prev('br').prev('input[type="hidden"]').prev('img.wpast-image').attr('src', imageURL);
        });
    });

    $('.wpast-remove').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var $default = $this.data('default');
        var $image = $this.prev('button').prev('br').prev('input[type="hidden"]').prev('img.wpast-image');
        $this.prev('button').prev('br').prev('input[type="hidden"]').val('');
        $image.attr('src', $default);
    });

    $("select.wpast-confirm").change(function () {
        var $this = $(this);
        var $name = $this.attr('name');
        if ($this.val()) {
            $('#wpast-' + $name).slideDown();
        } else {
            $('#wpast-' + $name).slideUp();
        }
    });
    $("select.wpast-confirm").each(function () {
        var $this = $(this);
        if ($this.val()) {
            var $name = $this.attr('name');
            $('#wpast-' + $name).show();
        }
    });

    $('.wpast-new-status').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $this.prev('div').append('<div class="uk-margin-small"><input type="text" class="uk-input" name="statuses[]" placeholder="' + WPAST_DATA.slug + ':' + WPAST_DATA.name + ':' + WPAST_DATA.hex_code + '"></div>');
    });

    $('.wpast-code-table code').click(function () {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(this).text()).select();
        document.execCommand("copy");
        $temp.remove();
    });

    $('.wpast-tickets #bulk-action-selector-top').change(function () {
        var $this = $(this);
        var doAction = $('.wpast-tickets #doaction');
        if ($this.val() === 'bulk-delete') {
            doAction.attr("onclick", "return confirm('" + WPAST_DATA.sure_to_delete + "')");
        } else {
            doAction.attr("onclick", "");
        }
    });

    if ($('.wpast-datepicker').length) {
        if (WPAST_DATA.lang !== 'fa') {
            $(".wpast-datepicker").datepicker();
        } else {
            $('.wpast-datepicker').persianDatepicker({formatDate: "YYYY-MM-DD"});
        }
    }

    var creatorID = $('#wpast-creator-id');
    if (creatorID.length) {
        creatorID.select2({
            ajax: {
                url: ajaxurl,
                dataType: 'json',
                delay: 250,
                type: 'post',
                timeout: 20000,
                data: function (params) {
                    return {
                        term: params.term,
                        nonce: nonce,
                        action: 'wpast_search_creator'
                    };
                },
                processResults: function (data) {
                    var options = [];
                    if (data) {
                        $.each(data, function (index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options
                    };
                },
                cache: true
            },
            minimumInputLength: 2,
            placeholder: WPAST_DATA.creator,
            allowClear: true
        });
    }

    var userID = $('#wpast-user-id');
    if (userID.length) {
        userID.select2({
            ajax: {
                url: ajaxurl,
                dataType: 'json',
                delay: 250,
                type: 'post',
                timeout: 20000,
                data: function (params) {
                    return {
                        term: params.term,
                        nonce: nonce,
                        action: 'wpast_search_creator'
                    };
                },
                processResults: function (data) {
                    var options = [];
                    if (data) {
                        $.each(data, function (index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options
                    };
                },
                cache: true
            },
            minimumInputLength: 2,
            placeholder: WPAST_DATA.user,
            allowClear: true
        });
    }

    var vendorID = $('#wpast-vendor-id');
    if (vendorID.length) {
        vendorID.select2({
            ajax: {
                url: ajaxurl,
                dataType: 'json',
                delay: 250,
                type: 'post',
                timeout: 20000,
                data: function (params) {
                    return {
                        term: params.term,
                        nonce: nonce,
                        action: 'wpast_search_creator'
                    };
                },
                processResults: function (data) {
                    var options = [];
                    if (data) {
                        $.each(data, function (index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options
                    };
                },
                cache: true
            },
            minimumInputLength: 2,
            placeholder: WPAST_DATA.vendor,
            allowClear: true
        });
    }

    if (WPAST_DATA.woo_active) {
        var product = $('#wpast-product');
        if (product.length) {
            product.select2({
                ajax: {
                    url: ajaxurl,
                    dataType: 'json',
                    delay: 250,
                    type: 'post',
                    timeout: 20000,
                    data: function (params) {
                        return {
                            term: params.term,
                            nonce: nonce,
                            action: 'wpast_search_product'
                        };
                    },
                    processResults: function (data) {
                        var options = [];
                        if (data) {
                            $.each(data, function (index, text) {
                                options.push({id: text[0], text: text[1]});
                            });
                        }
                        return {
                            results: options
                        };
                    },
                    cache: true
                },
                minimumInputLength: 2,
                placeholder: WPAST_DATA.product,
                allowClear: true
            });
        }
    }

    $('#wpast-show-more').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $this.toggleClass('expand');
        if ($this.hasClass('expand')) {
            $this.text(WPAST_DATA.show_less);
        } else {
            $this.text(WPAST_DATA.show_more);
        }
        $('.wpast-pre-answer .wpast-inner').toggleClass('expand');
    });

    $('.wpast-pre-answer-item').click(function (e) {
        var $this = $(this);
        var $content = $this.find('.wpast-pre-answer-content').html();
        if (tinyMCE && tinyMCE.activeEditor) {
            tinyMCE.get('wpast-reply-content').selection.setContent($content);
        }
        $('#wpast-reply-content').val($content);
    });

    $('.wpast-start-ticket .wpast-toggle-edit').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $('#post-body-content .wpast-content-inner').slideToggle();
    });

    $('.wpast-reply .wpast-toggle-edit').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $this.parentsUntil('#wpast-replies').next('.wpast-editor').slideToggle();
    });

    $('#wpast-add-annotation').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var ticketID = parseInt($this.data('ticket-id'));
        var annotation = $('#wpast-annotation');
        if (!ticketID || !annotation.val()) {
            return false;
        }
        $this.addClass('disabled');

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 20000,
            data: {
                action: 'wpast_add_annotation',
                nonce: nonce,
                ticketID: ticketID,
                annotation: annotation.val()
            },
            success: function (response) {
                if (response.result === true) {
                    annotation.val('');
                    $('.wpast-annotations').remove();
                    $this.after(response._html);
                }
            },
            error: function () {
                alert(WPAST_DATA.error_occurred);
            },
            complete: function (data) {
                $this.removeClass('disabled');
            }
        });
    });

    $('.wpast-delete-annotation').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var ticketID = parseInt($this.data('ticket-id'));
        var $index = parseInt($this.data('index'));
        if (!ticketID || !$index) {
            return false;
        }

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 20000,
            data: {
                action: 'wpast_delete_annotation',
                nonce: nonce,
                ticketID: ticketID,
                index: $index
            },
            success: function (response) {
                if (response.result === true) {
                    $this.parentsUntil('.wpast-annotations').fadeOut();
                }
            },
            error: function () {
                alert(WPAST_DATA.error_occurred);
            },
            complete: function (data) {

            }
        });
    });

    $('#wpast-info-div .wpast-info-tabs a').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var $item = $this.parentsUntil('.wpast-info-tabs');
        var $class = $item.attr('class');
        var panel = $class.replace('wpast-tab-', '');
        $item.addClass('active');
        $item.siblings('li').removeClass('active');
        $('#wpast-info-div .wpast-tab-panel').hide();
        $('#wpast-info-div #wpast-panel-' + panel).show();
    });

    $('.wpast-edit-date').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        $this.next('input').toggle();
    });

    $('.wpast-delete-process').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var ticketID = parseInt($this.data('ticket-id'));
        var $index = parseInt($this.data('index'));
        if (!ticketID || !$index) {
            return false;
        }

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 20000,
            data: {
                action: 'wpast_delete_process',
                nonce: nonce,
                ticketID: ticketID,
                index: $index
            },
            success: function (response) {
                if (response.result === true) {
                    $this.parentsUntil('.wpast-processes').fadeOut();
                }
            },
            error: function () {
                alert(WPAST_DATA.error_occurred);
            },
            complete: function (data) {

            }
        });
    });

    try {
        $('.wpast-edit-ticket #post-body-content, .wpast-edit-ticket #postbox-container-1, .wpast-submit-ticket #post-body-content, .wpast-submit-ticket #postbox-container-1').theiaStickySidebar({
            additionalMarginTop: 40
        });
    } catch (e) {

    }

    var answerableID = $('#wpast-answerable');
    if (answerableID.length) {
        answerableID.select2({
            ajax: {
                url: ajaxurl,
                dataType: 'json',
                delay: 250,
                type: 'post',
                timeout: 20000,
                data: function (params) {
                    return {
                        term: params.term,
                        nonce: nonce,
                        action: 'wpast_search_creator'
                    };
                },
                processResults: function (data) {
                    var options = [];
                    if (data) {
                        $.each(data, function (index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options
                    };
                },
                cache: true
            },
            minimumInputLength: 2,
            placeholder: WPAST_DATA.users,
        });
    }

    $('a.wpast-default-email').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var editor_id = $this.data('toggle');
        var $content = $('#wpast-default-email').html();
        if (tinyMCE && tinyMCE.activeEditor) {
            tinyMCE.get(editor_id).selection.setContent($content);
        }
        $(editor_id).val($content);
    });

    $('#wpast-send-test-sms').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var phone = $('#wpast-test-phone');
        var loader = $this.find('.loader');
        var alert = $this.prev();
        if (phone.val() === '') {
            return false;
        }
        $this.prop('disabled', true);
        loader.show();
        alert.hide();

        $.ajax({
            url: ajaxurl,
            type: 'post',
            dataType: 'json',
            timeout: 20000,
            data: {
                action: 'wpast_send_test_sms',
                nonce: nonce,
                phone: phone.val(),
            },
            success: function (response) {
                alert.html(JSON.stringify(response.result)).show();
            },
            error: function () {
                UIkit.notification({
                    message: WPAST_DATA.error_occurred,
                    status: 'danger',
                    pos: 'bottom-center',
                    timeout: 5000
                });
            },
            complete: function (data) {
                $this.prop('disabled', false);
                loader.hide();
            }
        });
    });

    $("body[class*='wpast-tickets'] fieldset.metabox-prefs .hide-column-tog").change(function () {
        var $this = $(this);
        var $val = $this.val();
        if (!this.checked) {
            document.cookie = "wpast_hide_" + $val + "=1";
            return false;
        }
        document.cookie = "wpast_hide_" + $val + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT;";
    });

    $('#wpast-sms-service').on('change', function () {
        showPatternWrapper();
    });
    showPatternWrapper();

    function showPatternWrapper() {
        //var patternWrapper = $('.wpast-pattern-wrapper');
        //var messageWrapper = $('.wpast-message-wrapper');
        var codeTable = $('.wpast-code-table');
        var kavenegarTable = $('.wpast-kavenegar');
        var $selected = $('#wpast-sms-service').find(":selected");
        if ($selected.data('pattern') == 1) {
            //patternWrapper.show();
            //messageWrapper.hide();
            if ($selected.val() == 'kavenegar') {
                codeTable.hide();
                kavenegarTable.show();
            } else {
                codeTable.show();
                kavenegarTable.hide();
            }
        } else {
            //patternWrapper.hide();
            //messageWrapper.show();
            //codeTable.hide();
            //kavenegarTable.hide();
        }
    }

    $('.wpast-departments #wpast-parent').on('change', function () {
        var $this = $(this);
        var fields = $('.wpast-form-field-fields');
        if ($this.val() === '0') {
            fields.hide();
        } else {
            fields.show();
        }
    });

    if ($('.wpast-color-field').length) {
        $('.wpast-color-field').wpColorPicker();
    }

    var ddw = $('.default-department-wrapper');
    $('input[name="submit-type"]').change(function () {
        if ($(this).is(':checked') && $(this).val() == 'child-department') {
            ddw.slideDown();
        } else {
            ddw.slideUp();
            $('.default-department').prop('checked', false);
        }
    });

    if ($('input[name="submit-type"]:checked').val() == 'child-department') {
        ddw.show();
    } else {
        ddw.hide();
        $('.default-department').prop('checked', false);
    }
});

function wpast_validate() {
    return confirm(WPAST_DATA.sure_to_delete);
}