<?php

/*
  Plugin Name: Protect external download links
  Description: This plugin protects external download links by encrypting.
  Author: Javad Ahshamian
  Version: 3.4.1
  Plugin URI: https://www.zhaket.com/web/wc-protect-external-link
  Author URI: https://ham3da.ir/
  Text Domain: wcpl
  Domain Path: /lang
  VersionCode: 46
  LastRelease: 2023-03
  LastReleaseJalali: 1401-12
  code: 3a0b1eec81400c2c0730578392ca53f6
  WC requires at least: 4.0.0
  WC tested up to: 7.4.1
 */


if (!defined('ABSPATH'))
{
    die("access denied!");
}


define('WCPL_PLUGIN', __FILE__);
define('WCPL_PLUGIN_VER', '3.4.1');
define('WCPL_PLUGINDIR', plugin_dir_path(__FILE__));
define('WCPL_PLUGINURL', plugin_dir_url(__FILE__));

include_once WCPL_PLUGINDIR . 'inc/custom-functions.php';
include_once WCPL_PLUGINDIR . 'inc/site-links-protection.php';
include_once WCPL_PLUGINDIR . 'inc/admin.php';
include_once WCPL_PLUGINDIR . 'inc/woocommerce-metabox.php';

if (!class_exists('PEDL_License'))
{
    require_once( WCPL_PLUGINDIR . 'inc/lic.class.php' );
}
require_once WCPL_PLUGINDIR . 'inc/functions.php';

register_deactivation_hook(__FILE__, 'we_protect_link_deactivation');

function we_protect_link_deactivation()
{
    wp_clear_scheduled_hook('we_protect_link_chk_validate');
}

register_activation_hook(__FILE__, 'we_protect_link_activation');

function we_protect_link_activation()
{

    $plugin_version = get_option('we-plugin_version', '1.0');
    if (version_compare($plugin_version, '3.1.0', '<'))
    {
        $protect_method = get_option('we-protect_method', false);
        if ($protect_method && $protect_method == 2)
        {
            $nginx_secret = get_option('we-nginx_secret', '');
            if (!empty($nginx_secret))
            {
                update_option('we-protect_sk', $nginx_secret);
            }

            delete_option('we-nginx_secret');
        }
    }
    update_option('we-plugin_version', WCPL_PLUGIN_VER);

    if (!wp_next_scheduled('we_protect_link_chk_validate'))
    {
        wp_schedule_event(time(), 'daily', 'we_protect_link_chk_validate');
    }
}

add_action('upgrader_process_complete', 'wcpl_upgrade_function', 10, 2);

function wcpl_upgrade_function($upgrader_object, $options)
{
    $current_plugin_path_name = plugin_basename(WCPL_PLUGIN);

    if (isset($options['plugins']) && $options['action'] == 'update' && $options['type'] == 'plugin')
    {

        foreach ($options['plugins'] as $each_plugin)
        {
            if ($each_plugin == $current_plugin_path_name)
            {
                we_protect_link_activation();
            }
        }
    }
}

add_action('we_protect_link_chk_validate', 'do_we_protect_link_chk_validate_daily');
add_action('admin_init', 'do_we_protect_link_chk_validate');

add_action('plugins_loaded', 'wc_protect_external_func');

function wc_protect_external_func()
{
    load_plugin_textdomain('wcpl', false, basename(dirname(__FILE__)) . '/lang');
    new WPPDL_SITE();
}