<?php

class WPPDL_METABOX
{

    public function __construct() {
        $dlm_check = get_option('we-woo_check', '1') == 1;
        if ($dlm_check)
        {
            add_action('add_meta_boxes_product', array($this, 'add_meta_box_dls'));
        }
    }

    public function add_meta_box_dls($post) {

        add_meta_box(
                'my-meta-box',
                __('Protected download links', 'wcpl'),
                [$this, 'render_meta_box_dl_links'],
                'product',
                'normal',
                'default'
        );
    }

    function render_meta_box_dl_links($post) {
        $product_object = wc_get_product($post->ID);
        echo '<p>' . __('New download links will be available after saving the product update.', 'wcpl') . '</p>';
        
        if ($product_object->is_type('simple') && $product_object->is_downloadable('yes'))
        {
            if ($product_object->has_file())
            {
                $downloadable_files = $product_object->get_downloads();

                $links = array();
                foreach ($downloadable_files as $download)
                {
                    $encoded_url = apply_filters('wcpl_download_url', $download->get_file());
                    $links[] = $download->get_name() . ': <a href="' . $encoded_url . '">' . __('Download File', 'wcpl') . '</a>';
                }
                if (count($links) > 0)
                {
                    echo "<ul><li>" . implode("</li><li>", $links) . "</li></ul>";
                }
            }
        }
        elseif ($product_object->is_type('variable'))
        {
            $available_variations = $product_object->get_available_variations();
            
            foreach ($available_variations as $variation) 
    { 
       
           $product = new WC_Product_Variation( $variation['variation_id']);
            if ($product->is_downloadable('yes') && $product->has_file())
                {
                    $item_downloads = $product->get_downloads();
                    $links = array();
                    foreach ($item_downloads as $item_download)
                    {
                        $encoded_url = apply_filters('wcpl_download_url', $item_download->get_file());
                        $links[] = $item_download->get_name() . ': <a href="' . $encoded_url . '">' . __('Download File', 'wcpl') . '</a>';
                    }
                    if (count($links) > 0)
                    {
                        echo "<ul><li>" . implode("</li><li>", $links) . "</li></ul>";
                    }
                }
            }

        }
    }

}

new WPPDL_METABOX();
