<?php
$protect_method = get_option('we-protect_method', '1');
$wcpl_sites = get_option('we-external-sites', '');
$secret_key = get_option('we-protect_sk', 'xswtvbbny1k');
$secret_iv = get_option('we-protect_iv', 'cshtvjbnl1q');
$defult_expiry = get_option('we-defult_expiry', '24');
$login_requred = get_option('we-login_requred', '0');

$video_protect = get_option('we-video_protect', '0');
$audio_protect = get_option('we-audio_protect', '0');
$post_protect = get_option('we-post_protect', '0');

$nginx_secret = get_option('we-nginx_secret', '');
$image_protect = get_option('we-image_protect', '0');

$ip_check = get_option('we-ip_check', '1');

$edd_check = get_option('we-edd_check', '1');
$woo_check = get_option('we-woo_check', '1');

$dlm_check = get_option('we-dlm_check', '1');

$expir_var = get_option('we-expir_var', 'hours');

$root_folder = get_option('we-root_folder', 'files');

$expir_vars = array("hours" => __("hour(s)", "wcpl"),
    "minutes" => __("minute(s)", "wcpl"),
    "seconds" => __("second(s)", "wcpl"),
    "days" => __("day(s)", "wcpl"),
    "weeks" => __("week(s)", "wcpl"),
    "month" => __("month(s)", "wcpl"),
);
?>
<script type="text/javascript">
    jQuery(document).ready(function ($)
    {
        jQuery(document).ready(function ($)
        {
            $("input[name='we-protect_method']").change(function ()
            {
                onchnage_method();
            });

            function onchnage_method()
            {
                var val1 = $("input[name='we-protect_method']:checked").val();
                if (val1 === '1')//LiteSpeed
                {
                    $('.description-method').html("<?php _e('In this web server, the links will be protected by using htaccess and php files.', 'wcpl') ?>");
                    $('.description-sk').html("<?php _e('You must also enter this key in the ENCRYPTION_KEY constant in the config.php file (in the download host).', 'wcpl') ?>");
                    $('.description-iv').html("<?php _e('You must also enter this key in the ENCRYPTION_IV constant in the config.php file (in the download host).', 'wcpl') ?>");
                    $('.description-iv, .wcpl_standard').show();


                } else//nginx secure link method
                {
                    $('.description-iv, .wcpl_standard').hide();
                    $('.description-method').html("<?php _e('In this web server, the links will be protected by using the ngx_http_secure_link_module module.', 'wcpl') ?>");
                    $('.description-sk').html("<?php _e('You must also enter this key in your download host\'s config code.', 'wcpl') ?>");
                }
            }

            onchnage_method();
        });
    });
</script>
<style>
</style>
<div class="wrap wcpl_export_users">
    <form method="post">
        <?php wp_nonce_field('wcpl_nonce_action', 'wcpl_nonce_field'); ?>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="we-protect_smt_standard"><?= __('Web server(download host)', 'wcpl') ?></label>
                    </th>
                    <td>
                        <label>
                            <input name="we-protect_method" <?php checked($protect_method, 1) ?> id="we-protect_smt_standard" type="radio" value="1" /> <?= __('LiteSpeed', 'wcpl'); ?>
                        </label>

                        <label>
                            <input name="we-protect_method" <?php checked($protect_method, 2) ?> id="we-protect_smt_nginx" type="radio" value="2" /> <?= __('Nginx', 'wcpl'); ?>
                        </label>
                        <p class="description description-method">
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="we-protect_sk"><?= __('Encryption Key', 'wcpl') ?></label>
                    </th>
                    <td>
                        <input name="we-protect_sk" id="we-protect_sk" type="text" class="regular-text code" value="<?= $secret_key ?>" />

                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="padding: 0 0 10px 0">
                        <p class="description description-sk">
                        </p>
                    </td>
                </tr>

                <tr class="wcpl_standard">
                    <th scope="row">
                        <label for="we-protect_iv"><?= __('Encryption Vector', 'wcpl') ?></label>
                    </th>
                    <td>
                        <input name="we-protect_iv" id="we-protect_iv" type="text" class="regular-text code" value="<?= $secret_iv ?>" />
                    </td>
                </tr>
                <tr class="wcpl_standard">
                    <td colspan="2" style="padding: 0 0 10px 0">
                        <p class="description description-iv">
                            <?php _e('If your download host webserver is litespeed this key should also be added to the ENCRYPTION_IV constant in the config.php file that will be uploaded to your download host.', 'wcpl') ?>
                        </p>
                    </td>
                </tr>
                <tr class="wcpl_standard">
                    <th scope="row">
                        <label for="we-root_folder"><?= __('Root folder', 'wcpl') ?></label>
                    </th>
                    <td>
                        <input name="we-root_folder" id="we-root_folder" type="text" class="regular-text code" value="<?= $root_folder ?>" />
                        <p class="description">
                            <?php
                            _e('Downloadable files will be uploaded to this folder.', 'wcpl');
                            ?>
                        </p>
                    </td>
                </tr>


                <tr>
                    <th scope="row">
                        <label for="wcpl_sites"><?= __('External Domains', 'wcpl') ?></label>
                    </th>
                    <td>
                        <textarea name="wcpl_sites" id="wcpl_sites" class="regular-text code"><?= $wcpl_sites ?></textarea>
                        <p class="description">
                            <?php _e('Separator: Comma.', 'wcpl') ?><br><?= __('Example: ', 'wcpl') ?><br>

                            <span dir="ltr">dl.sample.com,dl2.sample.com</span>            
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="we-defult_expiry"><?= __('Download expiry', 'wcpl') ?></label>
                    </th>
                    <td>
                        <?= __("After", "wcpl") ?>
                        <input name="we-defult_expiry" id="we-defult_expiry" type="number" class="number regular-text code samll" value="<?= $defult_expiry ?>" />
                        &nbsp;
                        <select class="samll" name="we-expir_var" id="we-expir_var">
                            <?php
                            foreach ($expir_vars as $key => $value)
                            {
                                ?>
                                <option <?php selected($expir_var, $key) ?> value="<?= $key ?>" ><?= $value ?></option>
                                <?php
                            }
                            ?>
                        </select>

                    </td>
                </tr>
                <?php
                if (function_exists('EDD'))
                {

                    $this->draw_check_box("we-edd_check", __('Protect EDD links', 'wcpl'), __('Enable', 'wcpl'),
                            __("Easy digital downloads plugin download links will be protected.", 'wcpl'), $edd_check, "1");
                    $this->draw_check_box("we-login_requred", __('Access restriction', 'wcpl'), __('Downloads require login', 'wcpl'),
                            __("For Easy Digital Downloads plugin", 'wcpl'), $login_requred, "1");
                }
                if (class_exists('WooCommerce'))
                {
                    $this->draw_check_box("we-woo_check", __('Protect WooCommerce links', 'wcpl'), __('Enable', 'wcpl'),
                            __("WooCommerce plugin download links will be protected.", 'wcpl'), $woo_check, "1");
                }

                if (class_exists("WP_DLM"))
                {
                    $this->draw_check_box("we-dlm_check", __('Protect Download Monitor links', 'wcpl'), __('Enable', 'wcpl'),
                            __("Download Monitor plugin download links will be protected.", 'wcpl'), $dlm_check, "1");
                }


                $this->draw_check_box("we-ip_check", __('IP check', 'wcpl'), __('Enable', 'wcpl'),
                        __("The user's IP will be checked before downloading the file.", 'wcpl'), $ip_check, "1");

                $this->draw_check_box("we-video_protect", __('Video protection', 'wcpl'), __('Enable', 'wcpl'),
                        __("Protect video file links in video player(Links in video shortcode)", 'wcpl'), $video_protect, "1");

                $this->draw_check_box("we-audio_protect", __('Audio protection', 'wcpl'), __('Enable', 'wcpl'),
                        __("Protect audio file links in audio player(Links in audio shortcode)", 'wcpl'), $audio_protect, "1");

                $this->draw_check_box("we-image_protect", __('Image protection', 'wcpl'), __('Enable', 'wcpl'),
                        __("Protect image URLs in posts or pages", 'wcpl'), $image_protect, "1");

                $this->draw_check_box("we-post_protect", __('Post content protection', 'wcpl'), __('Enable', 'wcpl'),
                        __("Protect links in the text of posts and pages", 'wcpl'), $post_protect, "1");

                do_action('wppdl_admin_form_items');
                ?>  


                <tr>
                    <td colspan="2" style="padding: 0 0 10px 0">
                        <label for="we-shortcode"><?php _e('Shortcode', 'wcpl') ?></label>
                        <p class="description">
                            <?php _e('If you need, you can use the following shortcode to create an encrypted link:', 'wcpl') ?>
                        </p>
                        <textarea dir="ltr">[wp_pl_link link="Your URL" title="<?php _e('Download', 'wcpl') ?>" expire="1" generate="1"]</textarea>
                        <p>
                        link: <?php _e('URL of the file', 'wcpl') ?> <br>
                        title: <?php _e('Link title', 'wcpl') ?> <br>
                        expire: <?php _e('Download expiry', 'wcpl') ?> <br>
                        generate: <?php _e('1 = Create link, 0 = Plain text', 'wcpl') ?>
                        </p>
                    </td>
                </tr>



            </tbody>
        </table>
        <div class="btn_div">
            <?php
            submit_button(__('Save', 'wcpl'), 'large', 'submit', false);
            ?>
        </div>
        <p class="version">
            <?php ?>
            <?php echo '<a href="' . $plugin_data['PluginURI'] . '">' . $plugin_data['Name'] . '</a> - ' . $plugin_data['Version'] ?>
        </p>
    </form>
</div>
<?php
