<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options'))
{
    die("access denied!");
}


?>
<script type="text/javascript">
    var ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>";
    var registrationSuccess = "<?php _e('Plugin license registration successful.', 'wcpl'); ?>";
    var failed_error = "<?php _e('Error: The request failed!', 'wcpl'); ?>";
    var errorString = "<?php _e('Error: ', 'wcpl'); ?>";

    var admin_url = "<?= admin_url('admin.php?page=wcpl'); ?>";


    function dis_submitForm()
    {
        return false;
    }
    function submit_any_form(form_id)
    {
        var form_pay = jQuery('#' + form_id);


        var user_licence = form_pay.find('#we_user_licence').val();

        var my_action = form_pay.find('#action').val();

        var send_data = {action: my_action, user_licence: user_licence};
        try
        {
            var postData = send_data;
            var form_pay = jQuery('#' + form_id);

            form_pay.find('#loading_pb').show();
            jQuery('#red_dialog').hide(200);

            var request = jQuery.ajax({method: "POST", data: postData, dataType: "json", url: ajax_url});
            request.done(function (response)
            {
                form_pay.find('#loading_pb').hide(200);
                if (response)
                {
                    var res = response.res;
                    if (res === true)
                    {
                        jQuery("#red_dialog").html(registrationSuccess);
                        jQuery('#red_dialog').css('color', 'green');
                        jQuery('#red_dialog').show(200);
                        window.location = admin_url;

                    } else
                    {
                        console.log("response1 = %o", response);
                        jQuery('#red_dialog').html(errorString + response.msg);
                        jQuery('#red_dialog').css('color', 'red');
                        jQuery('#red_dialog').show(300);
                    }

                } else
                {

                    jQuery("#red_dialog").html(failed_error);
                    jQuery('#red_dialog').css('color', 'red');
                    jQuery('#red_dialog').show(300);
                    console.log("response2 = %o", response);
                }
            });
            request.fail(function (jqXHR, textStatus, errorThrown)
            {
                form_pay.find('#loading_pb').hide(200);
                console.log("jqXHR = %o", jqXHR);
                console.log("textStatus = %o", textStatus);
                console.log("errorThrown = %o", errorThrown);
                jQuery('#red_dialog').html(failed_error + '<br/>' + errorThrown);
                jQuery('#red_dialog').css('color', 'red');
                jQuery('#red_dialog').show(300);

                return;
            });
        } catch (err)
        {
            alert(err.message);
        }
    }
    jQuery(document).ready(function ($)
    {
        $('#wcpl_submit').click(function ()
        {

            if ($('#we_user_licence').val().length >= 1)
            {
                submit_any_form('reg_wcpl_form');
            } else
            {
                $('#red_dialog').html("<?php _e('Please enter the activation code!', 'wcpl') ?>");
                $('#red_dialog').css('color', 'red');
                $('#red_dialog').show(300);
            }
        });
    });

</script>


<div class="wrap wcpl_export_users">
    <form id="reg_wcpl_form" method="post" onsubmit="return dis_submitForm()">
        <input type="hidden" name="action" id="action" value="we_protect_link_check_register" />
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row">
                        <label><?= __('Status:', 'wcpl') ?></label>
                    </th>
                    <td>
                        <p>
                            <?php
                            $input_status = "";
                            if (we_check_activation())
                            {
                                $input_status = 'readonly="readonly"';
                                echo '<span style="color:green;">';
                                _e('Congratulations! This plugin is active.', 'wcpl');
                                echo '</span>';
                            } else
                            {
                                $input_status = "";
                                echo '<span style="color:red;">';
                                _e('This plugin requires a license to use it.', 'wcpl');
                                echo '</span>';
                            }
                            ?>  
                        </p>
                    </td>
                </tr>

                <tr>
                    <?php
                    if (WPPDL_Custom_Functions::WCPL_HAM3DA == 1)
                    {
                        ?>
                    <td colspan="2" style="text-align: center;">
                            <p><hr>
                        <?= __('You are using the unlimited version of the plugin.', 'wcpl'); ?></p>
                        <hr>
                        </td>
                        <?php
                    } else
                    {
                        ?>
                        <th scope="row">
                            <label for="we-user_licence"><?= __('License Key', 'wcpl') ?></label>
                        </th>
                        <td>
                            <input <?= $input_status ?> name="we_user_licence" id="we_user_licence" type="text" class="regular-text code" value="<?= $license_token ?>" />
                            <p class="description"><span class="dashicons dashicons-warning"></span> 
                                <?php
                                printf(__('When you purchase this product from %s, a license key is assigned to your order and you can see it in your User Panel.', 'wcpl'), '<a href="https://www.zhaket.com/web/wc-protect-external-link/">zhaket.com</a>');
                                ?>
                            </p>
                        </td>
                        <?php
                    }
                    ?>
                </tr>
            </tbody>
        </table>

        <?php
        if (!we_check_activation())
        {
            ?>   
            <div class="btn_div">
                <?php
                submit_button(__('Submit', 'wcpl'), 'large', 'wcpl_submit', false);
                ?>
                &nbsp;<img id="loading_pb" style="width: 28px; display: none;" src="<?php echo admin_url('images/spinner-2x.gif') ?>" />
            </div>
            <?php
        }
        ?>

        <p style="display: none;" id="red_dialog"></p> 
        <p class="version">
            <?php printf(__('Version: %s', 'wcpl'), $plugin_data['Version'])   ?>
        </p>

    </form>
</div>