<?php

/*
 * By javad ahshamian since 2020
 */

class WPPDL_SITE
{

    private $external_sites = array();
    private $login_requred = false, $video_protect = false,
            $audio_protect = false, $post_protect = false, $image_protect = false;
    private $secret_key = "";
    private $defult_expiry = "24";
    private $ip_check = true;
    private $expir_var = "hours";
    private $edd_check = true,
            $woo_check = true,
            $dlm_check = true;

    function __construct()
    {
        $this->video_protect = get_option('we-video_protect', '0') == 1;
        $this->audio_protect = get_option('we-audio_protect', '0') == 1;
        $this->login_requred = get_option('we-login_requred', '0') == 1;
        $this->image_protect = get_option('we-image_protect', '0') == 1;

        $this->post_protect = get_option('we-post_protect', '0');

        $this->secret_key = get_option('we-protect_sk', 'xswtvbbny1k');

        $this->ip_check = get_option('we-ip_check', '1') == 1;
        $this->edd_check = get_option('we-edd_check', '1') == 1;
        $this->woo_check = get_option('we-woo_check', '1') == 1;
        $this->dlm_check = get_option('we-dlm_check', '1') == 1;
        $this->expir_var = get_option('we-expir_var', 'hours');
        $this->defult_expiry = get_option('we-defult_expiry', '24');

        if (we_check_activation())
        {
            //Lesson Studiare
            add_filter('wcpl_download_lesson', [$this, 'encode_url']);

            //Lesson Megafile
            add_filter('mf_download_lesson_url', [$this, 'encode_url']);

            //course digiacademy
            add_filter('mweb_private_course_link', [$this, 'encode_url']);

            //Woocommerce
            if ($this->woo_check)
            {
                add_filter('woocommerce_product_file_download_path', [$this, 'wc_file_download_path'], 100, 3);
                add_action('woocommerce_download_file_force', [$this, 'download_file_force'], 1, 2);
                add_action('woocommerce_download_file_xsendfile', [$this, 'download_file_xsendfile'], 1, 2);
                add_action('woocommerce_download_file_redirect', [$this, 'download_file_redirect_wc'], 1, 2);
                //Free Downloads WooCommerce
                add_action('somdn_do_download', [$this, 'somdn_woo_download'], 1, 3);
            }

            //edd download headers
            if ($this->edd_check)
            {
                add_action('edd_process_download_headers', [$this, 'edd_process_download_headers_def'], 11, 4);
            }

            //Download Monitor
            if ($this->dlm_check)
            {
                add_action('dlm_downloading', [$this, 'dlm_downloading'], 1, 3);
            }

            // special hook download url
            add_filter('wcpl_download_url', array($this, 'encode_url'));
            if (!has_filter('wcpl_limit_download_url'))
            {
                add_filter('wcpl_limit_download_url', array($this, 'encode_url'));
            }


            if (!is_admin())
            {

                if ($this->video_protect)
                {
                    //wp video shortcode
                    add_filter('wp_video_shortcode', [$this, 'shortcode_atts_video_def'], 10, 2);
                    add_filter('the_content', function ($post_content) {
                        $post_content = $this->pro_link_the_content($post_content, 'video', 'src');
                        return $post_content;
                    });
                }
                if ($this->audio_protect)
                {
                    //wp audio shortcode
                    add_filter('wp_audio_shortcode', [$this, 'shortcode_atts_audio_def'], 10, 2);
                    add_filter('the_content', function ($post_content) {
                        return $this->pro_link_the_content($post_content, 'audio', 'src');
                    });

                    add_filter('audioigniter_playlist_endpoint_track', function ($track_response, $track) {
                        return $this->audioigniter_playlist_endpoint_track($track_response);
                    }, 10, 2);
                }
                if ($this->image_protect)
                {
                    add_filter('the_content', function ($post_content) {
                        return $this->pro_link_the_content($post_content, 'img', 'src');
                    });

                    add_filter('wp_get_attachment_image_src', function ($image) {

                        $img_src = isset($image[0]) ? $image[0] : false;
                        if ($img_src)
                        {
                            $image[0] = $this->encode_url($img_src);
                        }
                        return $image;
                    });
                }


                add_shortcode('wp_pl_link', [$this, 'wp_pl_link_func']);

                add_filter('wcpl_filter_content', function ($content) {
                    $content = $this->pro_link_the_content($content, 'a', 'href');
                    $content = $this->pro_link_the_content($content, 'video', 'src');
                    $content = $this->pro_link_the_content($content, 'audio', 'src');
                    $content = $this->pro_link_the_content($content, 'img', 'src');
                    return $content;
                });

                add_filter('embed_oembed_html', [$this, 'wrap_oembed_html'], 99, 4);

                add_filter('llms_lesson_video', [$this, 'protect_llms_course'], 10, 4);
                add_filter('llms_lesson_audio', [$this, 'protect_llms_course'], 10, 4);

                add_filter('presto_player_block_data', [$this, 'presto_player_block_data'], 10, 1);

                //post content filter
                if ($this->post_protect)
                {
                    add_filter('the_content', function ($post_content) {
                        return $this->pro_link_the_content($post_content, 'a', 'href');
                    }, 101);
                }
            }
        }



        $sites = get_option('we-external-sites', '');
        if (!empty($sites))
        {
            $this->external_sites = explode(',', $sites);
        }

        add_action('wp_enqueue_scripts', [$this, 'custom_enqueue']);
    }

    function audioigniter_playlist_endpoint_track($track_response)
    {
        $track_response['audio'] = $this->encode_url($track_response['audio']);
        $track_response['downloadUrl'] = $this->encode_url($track_response['downloadUrl']);
        return $track_response;
    }

    /**
     * 
     * @param array $atts
     * @param PrestoPlayer\Support\Block $PrestoPlayer
     * @return array
     */
    function presto_player_block_data($atts)
    {

        if (isset($atts['src']) && !empty($atts['src']))
        {
            $atts['src'] = $this->encode_url($atts['src']);
        }

        return $atts;
    }

    function protect_llms_course($embed_html, $llms_post, $type, $prop)
    {

        if ($type == 'video')
        {
            $content = $this->pro_link_the_content($embed_html, 'source', 'src');
            $content = $this->pro_link_the_content($embed_html, 'video', 'src');
        } elseif ($type == 'audio')
        {
            $content = $this->pro_link_the_content($embed_html, 'audio', 'src');
        } else
        {
            $content = $embed_html;
        }

        return $content;
    }

    function custom_enqueue()
    {
        wp_enqueue_script('wcpl', WCPL_PLUGINURL . 'js/utliti.js', array('jquery'), WCPL_PLUGIN_VER);
    }

    function wrap_oembed_html($cached_html, $url, $attr, $post_id)
    {
        $current_url = $url;
        if (!$this->is_encrypted($current_url))
        {
            $new_url = $this->encode_url($current_url); //skip ok
            $output = str_replace($current_url, $new_url, $cached_html);
        } else
        {
            $output = $current_url;
        }

        return $output;
    }

    /**
     * limit long string for link title
     * @since  2.2.0
     * @param string $value string value
     * @param int $limit limit
     * @param int $from_start start from char index
     * @param int $from_end start from end char index
     * @param string $appender append string
     * @return string
     */
    function limit_string($value, $limit = 30, $from_start = 20, $from_end = -10, $appender = '...')
    {
        if (mb_strwidth($value, 'UTF-8') <= $limit)
        {
            return $value;
        }

        $start = mb_substr($value, 0, $from_start, 'UTF-8');
        $end = mb_substr($value, $from_end, NULL, 'UTF-8');
        return $start . $appender . $end;
    }

    /**
     * Encrypt links in post content
     * @since  2.2.0 
     * @param string $post_content post_content
     * @return string
     */

    /**
     * Encrypt links in post content
     * @param string $post_content post_content
     * @param string $tag tag
     * @param string $attr Attribute
     * @return type
     */
    function pro_link_the_content($post_content, $tag, $attr)
    {
        if (empty($post_content) || !$this->contains($tag, $post_content))
        {
            return $post_content;
        }

        try
        {
            $url_list1 = array();
            $url_list2 = array();

            $post_content2 = $post_content;
            $dom = new DomDocument();
            libxml_use_internal_errors(true);
            $dom->loadHTML($post_content);
            foreach ($dom->getElementsByTagName($tag) as $item)
            {
                $link = $item->getAttribute($attr);
                $ext = pathinfo($link, PATHINFO_EXTENSION);
                if ($link && $ext && !$this->is_encrypted($link))
                {
                    $new_link = $this->encrypt_file_link($link);
                    $url_list1[] = $link;
                    $url_list2[] = $new_link;
                }
            }
            libxml_clear_errors();

            if (count($url_list1))
            {
                $url_list1 = array_unique($url_list1);
                $url_list2 = array_unique($url_list2);
                $post_content2 = str_replace($url_list1, $url_list2, $post_content2);
            }
        } catch (Exception $exc)
        {
            $post_content2 = $post_content;
        }
        return $post_content2;
    }

    function is_encrypted($link_url)
    {

        if ($this->contains('?md5', $link_url) && $this->contains('&expires', $link_url))
        {
            return true;
        } else
        {
            return false;
        }
    }

    /**
     * check link marked to encryption
     * @since  2.2.0 
     * @param string $file_url file URL
     * @return boolean
     */
    function check_is_skip_protect($file_url)
    {
        $file_site = parse_url($file_url, PHP_URL_HOST);
        $protocol = parse_url($file_url, PHP_URL_SCHEME);
        $url_query = parse_url($file_url, PHP_URL_QUERY);
        $skip_protect = 0;
        parse_str($url_query, $url_query_array);
        if (count($url_query_array) > 0)
        {
            $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
        }
        if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) && $skip_protect == 1)
        {

            return true;
        } else
        {

            return false;
        }
    }

    /**
     * Shortcode encrypt one link
     * @since  2.0.0
     * @param array $atts User defined attributes in shortcode tag
     * @return string
     */
    function wp_pl_link_func($atts)
    {
        $param_shortcode = shortcode_atts(
                array('link' => false, 'expire' => 0, 'title' => __('Download', 'wcpl'), 'generate' => 1, $target = "_self"),
                $atts);

        $file_url = $param_shortcode['link'];
        $expire = $param_shortcode['expire'];

        $file_url2 = $this->encode_url($file_url, $expire);

        $str = "";
        if ($param_shortcode['generate'] == 1)
        {
            $str = '<a class="pl_link" href="' . $file_url2 . '" target="' . $target . '">' . $param_shortcode['title'] . '</a>';
        }
        return $str;
    }

    /**
     * @since  2.2.0
     * @param string $file_url file URL
     * @param int $expire expire
     * @return string
     */
    function encrypt_file_link($file_url, $expire = null)
    {
        $file_site = parse_url($file_url, PHP_URL_HOST);
        $protocol = parse_url($file_url, PHP_URL_SCHEME);
        $url_query = parse_url($file_url, PHP_URL_QUERY);

        $ext = pathinfo($file_url, PATHINFO_EXTENSION);

        if (!empty($this->external_sites) &&
                in_array($file_site, $this->external_sites) &&
                !$this->is_encrypted($file_url) &&
                !$this->check_is_skip_protect($file_url) && $ext)
        {
            //$from_date = current_time('mysql', true);
            $defult_expiry = empty($expire) ? $this->defult_expiry : $expire;

            $expire2 = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);

            $base_url = $protocol . '://' . $file_site;

            $file_url = $this->generat_link($file_url, $expire2, $this->GetRealIp(),
                    get_option('gmt_offset'), 1, $base_url);
        }


        return $file_url;
    }

    /**
     * Protect Audio files
     * @since 1.9.0
     * @param String $output HTML output
     * @param array $atts
     * @return String
     */
    function shortcode_atts_audio_def($output, $atts)
    {

        if (isset($atts['src']) && !empty($atts['src']))
        {
            $current_url = $atts['src'];

            if (!$this->is_encrypted($current_url))
            {
                $new_url = $this->encode_url($current_url); //skip ok
                $output = str_replace($current_url, $new_url, $output);
            }
        } else
        {
            $old_urls = array();
            $default_types = wp_get_audio_extensions();
            foreach ($default_types as $type)
            {
                if (!empty($atts[$type]))
                {
                    $current_url = $atts[$type];
                    if (!$this->is_encrypted($current_url))
                    {
                        $new_url = $this->encode_url($current_url); //skip ok

                        $old_urls[] = $current_url;
                        $new_urls[] = $new_url;
                        $atts[$type] = $new_url;
                    }
                }
            }

            if (count($old_urls) > 0)
            {
                $output = str_replace($old_urls, $new_urls, $output);
            }
        }

        return $output;
    }

    /**
     * Protect Video files
     * @since 1.9.0
     * @param string $output HTML output
     * @param array $atts
     * @return String
     */
    function shortcode_atts_video_def($output, $atts)
    {
        if (isset($atts['src']) && !empty($atts['src']))
        {
            $current_url = $atts['src'];
            if (!$this->is_encrypted($current_url))
            {
                $new_url = $this->encode_url($current_url); //skip ok
                $output = str_replace($current_url, $new_url, $output);
            }
        } else
        {
            $old_urls = array();
            $default_types = wp_get_video_extensions();
            foreach ($default_types as $type)
            {
                if (!empty($atts[$type]))
                {
                    $current_url = $atts[$type];
                    if (!$this->is_encrypted($current_url))
                    {
                        $new_url = $this->encode_url($current_url); //skip ok
                        $old_urls[] = $current_url;
                        $new_urls[] = $new_url;
                        $atts[$type] = $new_url;
                    }
                }
            }
            if (count($old_urls) > 0)
            {
                $output = str_replace($old_urls, $new_urls, $output);
            }
        }

        return $output;
    }

    function wcpl_download_lesson_def($download_lesson_url)
    {
        return $this->encode_url($download_lesson_url);
    }

    /**
     * Protect Links in your themes or other
     * @param string encode_url URL
     * @return string
     */
    function encode_url($url, $expir_time = null)
    {

        $file_url = $url;
        if ($this->is_encrypted($file_url))
        {
            return $file_url;
        }

        $file_site = parse_url($file_url, PHP_URL_HOST);
        $protocol = parse_url($file_url, PHP_URL_SCHEME);
        $url_query = parse_url($file_url, PHP_URL_QUERY);

        $skip_protect = 0;
        parse_str($url_query, $url_query_array);
        if (count($url_query_array) > 0)
        {
            $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
        }

        $ext = pathinfo($file_url, PATHINFO_EXTENSION);
        $defult_expiry = empty($expir_time) ? $this->defult_expiry : $expir_time;

        if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) && $ext)
        {

            if ($skip_protect == 1)
            {
                return $file_url;
            }

            $baseUrl = $protocol . '://' . $file_site;

            //$from_date = current_time('mysql', true);
            $expire = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);

            $file_url2 = $this->generat_link($file_url, $expire, $this->GetRealIp(),
                    get_option('gmt_offset'), 1, $baseUrl);

            return $file_url2;
        } else
        {
            return $file_url;
        }
    }

    /**
     * @param $baseUrl - non protected part of the URL including hostname, e.g. http://example.com
     * @param $path - protected path to the file, e.g. /downloads/myfile.zip
     * @param $secret - the shared secret with the nginx server. Keep this info secure!!!
     * @param $expire - expire time
     * @param $userIp - ip of the user allowed to download
     * @return string
     */
    function buildSecureLink($baseUrl, $path, $secret, $expire, $userIp)
    {
        $encrypted = $this->is_encrypted($baseUrl . $path);
        if ($encrypted)
        {
            return $baseUrl . $path;
        }

        $path2 = urldecode($path);
        $expires = $expire;
        if ($this->ip_check == 1)
        {
            $md5 = md5("$expires$path2$userIp $secret", true);
        } else
        {
            $md5 = md5("$expires$path2 $secret", true);
        }
        $md5 = base64_encode($md5);
        $md5 = strtr($md5, '+/', '-_');
        $md5 = str_replace('=', '', $md5);

        return add_query_arg(array('md5' => $md5, 'expires' => $expires), $baseUrl . $path);
    }

    /**
     * 
     * @param type $file_url  file URL 
     * @param type $expire expire time
     * @param type $ip User IP
     * @param type $gmt_offset gmt offset
     * @param type $remaining remaining
     * @param type $baseUrl base URI
     * @return type string URL
     */
    function generat_link($file_url, $expire, $ip, $gmt_offset, $remaining = 1, $baseUrl = '')
    {

        $encrypted = $this->is_encrypted($file_url);
        if ($encrypted)
        {
            return $file_url;
        }

        $expire = apply_filters('wppdl_link_expire', $expire);
        $file = parse_url(strtok($file_url, '?'), PHP_URL_PATH);

        return $this->buildSecureLink($baseUrl, $file, $this->secret_key, $expire, $ip);
    }

    /**
     * Protect EDD Download Links
     * @param string $requested_file
     * @param object $download
     * @param string $email
     * @param object $payment
     */
    function edd_process_download_headers_def($requested_file, $download, $email, $payment)
    {
        $file_path = $requested_file;
        if (!$this->is_encrypted($file_path))
        {
            $file_site = parse_url($file_path, PHP_URL_HOST);
            $protocol = parse_url($file_path, PHP_URL_SCHEME);
            $dl_obj = edd_get_download($download);
            $expire = isset($_GET['expire']) ? $_GET['expire'] : '';
            $user = wp_get_current_user();

            ///
            $url_query = parse_url($file_path, PHP_URL_QUERY);
            $ext = pathinfo($file_path, PATHINFO_EXTENSION);

            $skip_protect = 0;
            parse_str($url_query, $url_query_array);
            if (count($url_query_array) > 0)
            {
                $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
            }

            if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) &&
                    $skip_protect != 1 && $ext)
            {

                if (!is_user_logged_in() && $this->login_requred)
                {
                    wp_die(__('You must be logged in to download files.', 'wcpl'), __('Login error', 'wcpl'));
                }

                if ($user->user_email != $email && intval($this->login_requred) == 1)
                {
                    wp_die(__('This is not your download link.', 'wcpl'), __('Download error', 'wcpl'));
                }

                $dl_url = $protocol . '://' . $file_site;

                if (empty($expire))
                {
                    $defult_expiry = $this->defult_expiry;
                    //$from_date = current_time('mysql', true);
                    $expire = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);
                }

                $file_path2 = $this->generat_link($file_path, $expire, $this->GetRealIp(),
                        get_option('gmt_offset'), 1, $dl_url);

                $this->download_file_redirect($file_path2);
            }
        }
    }

    /**
     * simple method to encrypt or decrypt a plain text string
     * initialization vector(IV) has to be the same when encrypting and decrypting
     * @since 1.0.0
     * @param string $string string to encrypt or decrypt
     * @param int $action can be <b>'1: encrypt'</b> or  <b>'2: decrypt'</b>
     *
     * @return string
     */
    private function encrypt_decrypt($string, $action = 1)
    {
        $output = false;
        $encrypt_method = "AES-256-CBC";

        $secret_key = $this->secret_key;
        $secret_iv = get_option('we-protect_iv', 'cshtvjbnl1q');
// hash
        $key = hash('sha256', $secret_key);

// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ($action == 1)
        {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if ($action == 2)
        {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }

    /**
     * Get current user IP Address.
     * @since 1.0.0
     * @return string IP
     */
    function GetRealIp()
    {
//        $ip = '';
//
//        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"]))
//        {
//            $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
//        } elseif (isset($_SERVER['HTTP_X_REAL_IP']))
//        {
//            $ip = $_SERVER['HTTP_X_REAL_IP'];
//        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
//        {
//            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
//        } elseif (isset($_SERVER['HTTP_CLIENT_IP']))
//        {
//            $ip = $_SERVER['HTTP_CLIENT_IP'];
//        } else
//        {
//            $ip = $_SERVER['REMOTE_ADDR'];
//        }
        
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        return $ip;
    }

    /**
     * Create a log if logging is enabled
     *
     * @param string $type
     * @param string $status
     * @param string $message
     * @param DLM_Download $download
     * @param DLM_Download_Version $version
     */
    function dlm_log($type, $status, $message, $download, $version)
    {

        // Logging object
        $logging = new DLM_Logging();

        // Check if logging is enabled and if unique ips is enabled
        if ($logging->is_logging_enabled() && false === DLM_Cookie_Manager::exists($download))
        {

            // set create_log to true
            $create_log = true;

            // check if requester downloaded this version before
            if ($logging->is_count_unique_ips_only() && true === $logging->has_ip_downloaded_version($version))
            {
                $create_log = false;
            }

            // check if we need to create the log
            if ($create_log)
            {

                // setup new log item object
                $log_item = new DLM_Log_Item();
                $log_item->set_user_id(absint(get_current_user_id()));
                $log_item->set_user_ip(DLM_Utils::get_visitor_ip());
                $log_item->set_user_agent(DLM_Utils::get_visitor_ua());
                $log_item->set_download_id(absint($download->get_id()));
                $log_item->set_version_id(absint($version->get_id()));
                $log_item->set_version($version->get_version());
                $log_item->set_download_date(new DateTime(current_time('mysql')));
                $log_item->set_download_status($status);
                $log_item->set_download_status_message($message);

                // persist log item
                download_monitor()->service('log_item_repository')->persist($log_item);
            }
        }
    }

    /**
     * Protect Download Monitor Links
     * @param type $download
     * @param type $version
     * @param string $file_path
     */
    function dlm_downloading($download, $version, $file_path)
    {

        if (!$this->is_encrypted($file_path))
        {
            $file_site = parse_url($file_path, PHP_URL_HOST);
            $protocol = parse_url($file_path, PHP_URL_SCHEME);

            $user = wp_get_current_user();

            ///
            $url_query = parse_url($file_path, PHP_URL_QUERY);
            $ext = pathinfo($file_path, PATHINFO_EXTENSION);

            $skip_protect = 0;
            parse_str($url_query, $url_query_array);
            if (count($url_query_array) > 0)
            {
                $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
            }

            if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) &&
                    $skip_protect != 1 && $ext)
            {
                // Set cookie to prevent double logging

                $dl_url = $protocol . '://' . $file_site;
                $defult_expiry = $this->defult_expiry;
                //$from_date = current_time('mysql', true);
                $expire = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);

                $file_path2 = $this->generat_link($file_path, $expire, $this->GetRealIp(),
                        get_option('gmt_offset'), 1, $dl_url);

                // Set cookie to prevent double logging
                //DLM_Cookie_Manager::set_cookie($download);
                $this->dlm_log('download', 'redirected', __('Redirected to file', 'download-monitor'), $download, $version);

                $this->download_file_redirect($file_path2);
            }
        }
    }

    /**
     * Protect Free Downloads WooCommerce download Links
     * @param type $file_path
     * @param type $product_id
     * @param type $force
     */
    function somdn_woo_download($file_path, $product_id, $force = false)
    {
        if (!$this->is_encrypted($file_path))
        {
            $file_site = parse_url($file_path, PHP_URL_HOST);
            $protocol = parse_url($file_path, PHP_URL_SCHEME);
            ///
            $url_query = parse_url($file_path, PHP_URL_QUERY);
            $ext = pathinfo($file_path, PATHINFO_EXTENSION);

            $skip_protect = 0;
            parse_str($url_query, $url_query_array);
            if (count($url_query_array) > 0)
            {
                $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
            }

            if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) && $skip_protect != 1 && $ext)
            {

                $dl_url = $protocol . '://' . $file_site;
                $defult_expiry = $this->defult_expiry;
                //$from_date = current_time('mysql', true);
                $expire = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);

                $file_path2 = $this->generat_link($file_path, $expire, $this->GetRealIp(),
                        get_option('gmt_offset'), 1, $dl_url);

                // Add 1 to the download count for this product
                do_action('somdn_count_download', $product_id);
                $this->download_file_redirect($file_path2);
            }
        }
    }

    /**
     * Redirect to a file to start the download.
     *
     * @param string $file_path File path.
     * @param string $filename  File name.
     */
    public function download_file_redirect_wc($file_path, $filename = '')
    {
        $this->download_file_force($file_path, $filename);
    }

    /**
     * redirect X-Sendfile, X-Lighttpd-Sendfile, or X-Accel-Redirect if available.
     * @since 1.0.0
     * @param string $file_path File path.
     * @param string $filename  File name.
     */
    public function download_file_xsendfile($file_path, $filename)
    {
        $file_site = parse_url($file_path, PHP_URL_HOST);
        $protocol = parse_url($file_path, PHP_URL_SCHEME);
        $url_query = parse_url($file_path, PHP_URL_QUERY);
        $skip_protect = 0;
        parse_str($url_query, $url_query_array);
        if (count($url_query_array) > 0)
        {
            $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
        }

        if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) && $skip_protect != 1)
        {
            $this->download_file_redirect($file_path);
        }
    }

    // returns true if $needle is a substring of $haystack
    function contains($needle, $haystack)
    {
        return strpos($haystack, $needle) !== false;
    }

    /**
     * redirect Force download
     * @since 1.0.0
     * @param string $file_path File path.
     * @param string $filename  File name.
     */
    public function download_file_force($file_path, $filename)
    {

        $file_site = parse_url($file_path, PHP_URL_HOST);
        $protocol = parse_url($file_path, PHP_URL_SCHEME);

        $url_query = parse_url($file_path, PHP_URL_QUERY);
        $skip_protect = 0;
        parse_str($url_query, $url_query_array);
        if (count($url_query_array) > 0)
        {
            $skip_protect = isset($url_query_array['skp']) ? intval($url_query_array['skp']) : 0;
        }

        if (!empty($this->external_sites) && in_array($file_site, $this->external_sites) && $skip_protect != 1)
        {
            if (!$this->is_encrypted($file_path))
            {
                $file_path = $this->encode_url($file_path);
            }
            $this->download_file_redirect($file_path);
        }
    }

    /**
     * Redirect to a file to start the download.
     *
     * @param string $file_path File path.
     * @param string $filename  File name.
     */
    public function download_file_redirect($file_path, $filename = '')
    {
        header('Location: ' . $file_path);
        exit();
    }

    /**
     * 
     * @param type $file_path
     * @since 1.0.0
     * @param Class $WC_Product Abstract Product Class
     * @param type $download_id
     */
    public function wc_file_download_path($file_path, $WC_Product, $download_id)
    {
        if ($this->is_encrypted($file_path))
        {
            return $file_path;
        }
        if (!isset($_GET['order']))
        {
            return $file_path;
        }

        $files = $WC_Product->get_downloads();
        $file_path = isset($files[$download_id]) ? $files[$download_id]->get_file() : '';

        $file_site = parse_url($file_path, PHP_URL_HOST);
        $protocol = parse_url($file_path, PHP_URL_SCHEME);

        $url_query = parse_url($file_path, PHP_URL_QUERY);

        $ext = pathinfo($file_path, PATHINFO_EXTENSION);

        $dl_url = $protocol . '://' . $file_site;

        if (!empty($this->external_sites) &&
                in_array($file_site, $this->external_sites) &&
                !$this->check_is_skip_protect($file_path) && $ext)
        {

            $order_id = wc_get_order_id_by_order_key(wc_clean(wp_unslash($_GET['order']))); // WPCS: input var ok, CSRF ok.
            $order = wc_get_order($order_id);

            $data_store = WC_Data_Store::load('customer-download');

            $download_ids = $data_store->get_downloads(
                    array(
                        // 'user_email'  => sanitize_email(str_replace(' ', '+', $email_address)),
                        'order_key' => wc_clean(wp_unslash($_GET['order'])), // WPCS: input var ok, CSRF ok.
                        'product_id' => $WC_Product->get_id(),
                        'download_id' => $download_id, // WPCS: input var ok, CSRF ok, sanitization ok.
                        'orderby' => 'downloads_remaining',
                        'order' => 'DESC',
                        'limit' => 1,
                        'return' => 'ids',
                    )
            );
            $download = new WC_Customer_Download(current($download_ids));

            $expire = !is_null($download->get_access_expires()) ? $download->get_access_expires()->getTimestamp() : 0;

            if (empty($expire) || $expire == 0)
            {
                $defult_expiry = $this->defult_expiry;
                //$from_date = current_time('mysql', true);
                $expire = strtotime('now + ' . $defult_expiry . ' ' . $this->expir_var);
            }

            $remaining = !empty($download->get_downloads_remaining()) ? $download->get_downloads_remaining() : '-1';
            $file_path = $this->generat_link($file_path, $expire, $this->GetRealIp(),
                    get_option('gmt_offset'), $remaining, $dl_url);

            return $file_path;
        } else
        {
            return $file_path;
        }
    }

}
