<?php

class PEDL_License
{

    static $check_url = 'https://guard.zhaket.com/api/';

    // Constructor of PEDL_License class
    public function __construct()
    {
        
    }

    //-------------------------------------------------
    // This method sends GET request to specific url and returns the result
    public static function sendRequest($method, $params = array())
    {
        $param_string = http_build_query($params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, self::$check_url . $method . '?' . $param_string
        );
        $content = curl_exec($ch);
        return json_decode($content);
    }

    //-------------------------------------------------
    public static function isValid($license_token)
    {
        $result = self::sendRequest('validation-license', array('token' => $license_token, 'domain' => self::getHost()));
        return $result;
    }

    //-------------------------------------------------
    public static function install($license_token, $product_token)
    {

        $result = self::sendRequest('install-license', array('product_token' => $product_token, 'token' => $license_token, 'domain' => self::getHost()));
        return $result;
    }

    //-------------------------------------------------
    public static function getHost()
    {
        $host = parse_url(get_site_url(), PHP_URL_HOST);
        $host = preg_replace('/:\d+$/', '', $host);
        $host = str_ireplace('www.', '', $host);
        return trim($host);
    }

}
