<?php
$secret_key = get_option('we-protect_sk', 'xswtvbbny1k');
$secret_iv = get_option('we-protect_iv', 'cshtvjbnl1q');
$ip_check = get_option('we-ip_check', '1');
$root_folder = get_option('we-root_folder', 'files');
?>
<h3>1) <?php _e('Upload php and htaccess files', 'wcpl') ?></h3>
<p>
    <?php _e('Inside the product folder, go to Addons\uptohost and upload the files in it to the public_html or www folder of your download host.', 'wcpl') ?>
</p>

<h3>2) <?php _e('Configure', 'wcpl') ?></h3>
<h4>
    2-1) <?php _e('The following items must be set in the config.php file:', 'wcpl') ?>
</h4>
<ul>
    <ol>- <?php _e('Enter the name of your web server:', 'wcpl') ?>
        <p dir="ltr">
        <pre dir="ltr" class="pel_code">
        define('WEB_SERVER', 'litespeed');
        </pre>
        </p>
    </ol>
    <ol>- <?php _e('Enter security keys:', 'wcpl'); ?>
        <p dir="ltr">
        <pre dir="ltr" class="pel_code">
        define('ENCRYPTION_KEY', '<?php echo sanitize_text_field($secret_key)  ?>');
        define('ENCRYPTION_IV', '<?php echo sanitize_text_field($secret_iv) ?>');
        </pre>
        </p>
    </ol>
    <ol>- <?php _e('IP check:', 'wcpl'); ?>
        <p dir="ltr">
        <pre dir="ltr" class="pel_code">
        define('CHECK_IP', <?php echo $ip_check == 1 ? 'true' : 'false' ?>);
        </pre>
        </p>
    </ol>
    <ol>- <?php _e('Set the root folder for the files:', 'wcpl'); ?>
        <p dir="ltr">
        <pre dir="ltr" class="pel_code">
        define('FILES_ROOT', '<?php echo sanitize_text_field($root_folder) ?>');
        </pre>
        </p>
    </ol>
</ul>
<h4>
    2-2) <?php _e('<span dir="ltr">.htaccess</span> file should contain the following codes:', 'wcpl') ?>
</h4>
<p>
<pre dir="ltr" class="pel_code">
    ## The <?php echo sanitize_text_field($root_folder) ?> folder and the FILES_ROOT variable must be the same.
    &#60;IfModule mod_rewrite.c&#62;
        RewriteEngine On
        RewriteCond %{REQUEST_FILENAME}  -f [OR]
        RewriteCond %{REQUEST_FILENAME} !-f
        RewriteCond %{REQUEST_URI} !/<?php echo sanitize_text_field($root_folder) ?>&#13;
        RewriteRule ^(.*)$ index.php?path=$1 [L,QSA]
    &#60;/IfModule&#62;
        <br>
    ## Prevent access to desired extensions. You can add or remove extensions.
    &#60;FilesMatch "\.(zip|rar|mp4)$"&#62;
        Order Allow,Deny
        Deny from all
    &#60;/FilesMatch&#62;
</pre>
</p>

<h3>
    3) <?php _e('Create the root folder', 'wcpl') ?>
</h3>
<p>
    <?php printf(__('Create a root folder named %s in the public_html path and upload your downloadable files to it.', 'wcpl'), $root_folder) ?>
</p>
<p><b><?php _e('Done!', 'wcpl') ?></b></p>