<?php
if (!defined('ABSPATH'))
{
    die('Access denied!');
}

function we_check_activation()
{
    $active_state = get_option('ham3da_we_protect_link_active', '0');
    if (intval($active_state) === 1 || WPPDL_Custom_Functions::WCPL_HAM3DA == 1)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**
 *  Check licence from db
 */
function do_we_protect_link_chk_validate()
{
    //$active_state = get_option('ham3da_we_protect_link_active', '0');
    if (!we_check_activation())
    {
        //note to user: Active your sadad plugin
        add_action('admin_notices', 'we_protect_link_show_active_note');
    }
}

/**
 *  Check licence from Zhaket.com every day
 */
function do_we_protect_link_chk_validate_daily()
{
    //$active_state = get_option('ham3da_we_protect_link_active', '0');
    if (we_check_activation())
    {
        //check licence online
        $LicenseisValid = LicenseisValid_we_protect_link();
        if ($LicenseisValid === false && WPPDL_Custom_Functions::WCPL_HAM3DA == 0)
        {
            update_option('ham3da_we_protect_link_active', '0');
            $admin_email = get_option('admin_email');

            $subject = __("Protect WPDL License Expiration", "wcpl");
            $plName  = __("Protect WordPress download links", "wcpl");

            $dir      = is_rtl() ? 'rtl' : 'ltr';
            $message  = '<p dir="' . $dir . '">' . sprintf(__('Hi, dear user, %s Plugin License has expired on your site. Please reactivate it.', 'wcpl'), $plName) . '</p>';
            $message  .= '<p dir="' . $dir . '">' . sprintf(__('If you think this is a mistake, please contact %s support.', 'wcpl'), '<a href="https://www.zhaket.com/">zhaket.com/</a>') . '</p>';
            $site_url = get_site_url();
            $message  .= '<p><a href="' . $site_url . '">' . $site_url . '</a></p>';
            $headers  = array('Content-Type: text/html; charset=UTF-8');
            wp_mail($admin_email, $subject, $message, $headers);
        }
    }
}

function ajax_check_register_we_protect_link_plugin()
{
    $user_licence = filter_input(INPUT_POST, 'user_licence');
    if ($user_licence != null)
    {
        $res = we_protect_link_install_validate($user_licence);
        die(json_encode($res));
    }
}

add_action('wp_ajax_we_protect_link_check_register', 'ajax_check_register_we_protect_link_plugin');

function we_protect_link_show_active_note()
{
    $user   = wp_get_current_user();
    $plName = __("Protect WordPress download links", "wcpl");
    $msg    = sprintf(__('Hi %s, to Register %s Plugin click %s.', 'wcpl'), $user->display_name, "<b>" . $plName . "</b>", '<a href="' . admin_url('admin.php?page=wcpl&tab=activation') . '">' . __('Here', 'wcpl') . '</a>');
    if (isset($_GET['page']) && $_GET['page'] == 'wcpl_active')
    {
        //
    }
    else
    {
        echo we_show_admin_notice($msg, 'warning');
    }
}

/**
 * Return Notice Message
 * @param string $msg message
 * @param string $type error, success, warning
 * @return string
 */
function we_show_admin_notice($msg = '', $type = 'success')
{
    return '<div class="notice notice-' . $type . ' is-dismissible">
            <p>' . $msg . '</p>
        </div>';
}

/**
 * Register license and return result as array
 * @param string $license_token User License
 * @return array 'res' => boolean, 'msg'=> string
 */
function we_protect_link_install_validate($license_token)
{
    $produc_token = base64_decode('MjUwMDg1YWUtYThiYS00MzMxLTgyNTEtZTYzYmZmZGQyYTQw'); // Your product token
    /*
      @param1 : license_token
      @param2 : product_token
      replace it with your own license token and product token :)
     */
    $result       = PEDL_License::install($license_token, $produc_token);

    if (!isset($result->status))
    {
        return array('res' => false, 'msg' => __('Error checking license status!', 'wcpl'));
    }

    if ($result->status == 'successful')
    {
        //echo $result->message; // License installed successful
        update_option('ham3da_we_protect_link_license_token', base64_encode($license_token));
        update_option('ham3da_we_protect_link_active', '1');

        return array('res' => true, 'msg' => $result->message);
    }
    else
    {
        update_option('ham3da_we_protect_link_active', '0');

        // License not installed / show message
        if (!is_object($result->message))
        {
            // License is Invalid
            //echo $result->message;
            return array('res' => false, 'msg' => $result->message);
        }
        else
        {
            $message_res = "";
            foreach ($result->message as $message)
            {
                foreach ($message as $msg)
                {
                    $message_res .= $msg . '<br/>';
                }
            }
            return array('res' => false, 'msg' => $message_res);
        }
    }
}



/**
 * Check License is Valid or No
 * @return boolean|int if License is Valid return true else false and if error return 0
 */
function LicenseisValid_we_protect_link()
{
    $license_token = get_option('ham3da_we_protect_link_license_token', '0'); // Your license token
    $result        = PEDL_License::isValid(base64_decode($license_token));
    if (isset($result->status))
    {
        if ($result->status == 'successful')
        {
            return true;
        }
        else
        {
            // License not valid / show message
            if (!is_object($result->message))
            {
                // License is Invalid
                return false;
            }
            else
            {
                return -1;
            }
        }
    }
    else
    {
        return -2;
    }
}
