<?php
class WPPDL_Custom_Functions
{


   public const WCPL_HAM3DA = 0;

    public function __construct()
    {
        if (class_exists('Restrict_Content_Pro'))
        {
            add_action('wppdl_admin_form_items', [$this, 'admin_form_items_func']);
            add_filter('wppdl_link_expire', [$this, 'filter_expire']);
            add_filter('wppdl_option_keys', [$this, 'filter_wppdl_option_keys']);
        }
    }

    function filter_wppdl_option_keys($params)
    {

        $params[] = 'we-integrat_rcp';
        return $params;
    }

    function admin_form_items_func()
    {
        $integrat_rcp = get_option('we-integrat_rcp', '0');
        WPPDL_ADMIN::draw_check_box("we-integrat_rcp", __('Integration with rcp', 'wcpl'), __('Enable', 'wcpl'),
                __("Get the expiration date of the restrict content pro plugin", 'wcpl'), $integrat_rcp, "1");
    }

    function filter_expire($expire_time)
    {
        $integrat_rcp = get_option('we-integrat_rcp', '0');
        if ($integrat_rcp != 1)
        {
            return $expire_time;
        }
        global $post;
        if (!is_a($post, 'WP_Post'))
        {
            return $expire_time;
        }
        $post_id = $post->ID;

        $user_id = get_current_user_id();
        if (rcp_user_can_access($user_id))
        {

            if (rcp_has_post_restrictions($post_id))
            {
                $restrictions = rcp_get_post_restrictions($post_id);
                $membership_levels = $restrictions["membership_levels"];

                $user_level_id = false;
                if (is_array($membership_levels))
                {
                    foreach ($membership_levels as $level_id)
                    {
                        $res = $this->rcp_get_membe_ship_exire($user_id, $level_id);
                        if ($res)
                        {
                            $expire_time = $res;
                            break;
                        }
                    }
                }
            }
        }
        return $expire_time;
    }

    function rcp_get_membe_ship_exire($user_id, $level_id)
    {

        $res = false;
        $customer = rcp_get_customer_by_user_id($user_id);
        $memberships = $customer->get_memberships();

        foreach ($memberships as $membership)
        {

            if ($membership->is_active() && $level_id == $membership->get_object_id())
            {
                $res = $membership->get_expiration_time();
                break;
            }
        }
        return $res;
    }

}

new WPPDL_Custom_Functions();
