<?php
if (!defined('ABSPATH'))
{
    die("access denied!");
}

class WPPDL_ADMIN
{

    public function __construct()
    {
        add_action('admin_menu', [$this, 'admin_menu_func']);
        add_action('admin_enqueue_scripts', [$this, 'admin_style']);
        add_action('admin_init', [$this, 'admin_option_save_func']);
    }

    /**
     * Register a custom menu page.
     */
    function admin_menu_func()
    {
        add_menu_page(
                __('Protect WordPress download links', 'wcpl'),
                __('Download Protection', 'wcpl'),
                'manage_options',
                'wcpl',
                [$this, 'admin_option_func'],
                'dashicons-admin-links'
        );
    }

    function admin_style()
    {
        wp_enqueue_style('wcpl_style', WCPL_PLUGINURL . "css/style.css", array(), WCPL_PLUGIN_VER);
    }

    function admin_option_save_func()
    {
        //save post
        if (isset($_POST['wcpl_nonce_field']))
        {
            if (!isset($_POST['wcpl_nonce_field']) || !wp_verify_nonce($_POST['wcpl_nonce_field'], 'wcpl_nonce_action'))
            {
                wp_die(__('Sorry, your nonce did not verify.', 'wcpl'), __('Error', 'wcpl'));
            } else
            {
                $wcpl_sites1 = filter_input(INPUT_POST, 'wcpl_sites');
                $wcpl_sites = str_replace(' ', '', $wcpl_sites1);
                update_option('we-external-sites', $wcpl_sites);

                $option_keys = ['we-protect_sk', 'we-protect_iv', 'we-root_folder', 'we-defult_expiry', 'we-login_requred', 'we-video_protect',
                    'we-image_protect', 'we-audio_protect', 'we-post_protect', 'we-nginx_secret', 'we-protect_method', 'we-ip_check',
                    'we-expir_var', 'we-edd_check', 'we-woo_check', 'we-dlm_check'];

                $option_keys = apply_filters("wppdl_option_keys", $option_keys);

                foreach ($option_keys as $key)
                {
                    $save_op = filter_input(INPUT_POST, $key);
                    update_option($key, $save_op);
                }

                add_action('admin_notices', [$this, 'wcpl_admin_notice__success']);
                // process form data
            }
        }
    }

    function wcpl_admin_notice__success()
    {
        ?>
        <div class="notice notice-success is-dismissible">
            <p><?php _e('Settings saved successfully.', 'wcpl'); ?></p>
        </div>
        <?php
    }

    public static function draw_check_box($name, $label, $label2, $description, $checked, $current)
    {
        ?>
        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr($name) ?>"><?php echo esc_html($label) ?></label>
            </th>
            <td>
                <label>
                    <input <?php checked($checked, $current, true) ?> name="<?php echo esc_attr($name) ?>" id="<?php echo esc_attr( $name) ?>" type="checkbox" value="1" />
                    <?= $label2 ?>
                </label>
                <?php
                if (!empty($description))
                {
                    ?>
                    <p class="description">
                        <?php echo esc_html($description) ?>     
                    </p>
                    <?php
                }
                ?>
            </td>
        </tr>
        <?php
    }

    /**
     * Display a custom menu page
     */
    function admin_option_func()
    {

        $plugin_data = get_plugin_data(WCPL_PLUGIN);

        $active_state = get_option('ham3da_we_protect_link_active', '0');
        $license_token = get_option('ham3da_we_protect_link_license_token', ''); // Your license token
        if (!empty($license_token))
        {
            $license_token = base64_decode($license_token);
        }

        $curr_tab = $_GET['tab'] ?? 'main';

        $main_params = array('page' => 'wcpl', 'tab' => 'main');
        $activation_params = array('page' => 'wcpl', 'tab' => 'activation');
        $products_params = array('page' => 'wcpl', 'tab' => 'products');
        $help_params = array('page' => 'wcpl', 'tab' => 'help');

        $tabs = array(
            'main' => ['url' => add_query_arg($main_params, admin_url('admin.php')), 'title' => __('Settings', 'wcpl')],
            'activation' => ['url' => add_query_arg($activation_params, admin_url('admin.php')), 'title' => __('License', 'wcpl')],
            'products' => ['url' => add_query_arg($products_params, admin_url('admin.php')), 'title' => __('More products', 'wcpl')],
            'help' => ['url' => add_query_arg($help_params, admin_url('admin.php')), 'title' => __('Help', 'wcpl')],
        );
        ?>
        <div class="wrap">
            <h1><?= __('Protect WordPress External Download links', 'wcpl') ?></h1>
            <nav class="nav-tab-wrapper">
        <?php
        foreach ($tabs as $key => $tab_item)
        {
            ?>
                    <a href="<?php echo esc_url($tab_item['url']) ?>" class="nav-tab <?php echo ($curr_tab == $key) ? 'nav-tab-active' : '' ?>"><?= esc_html($tab_item['title']) ?></a>
                    <?php
                }
                ?>
            </nav>
                <?php
                if (file_exists(WCPL_PLUGINDIR . "inc/tabs/$curr_tab.php"))
                {
                    include WCPL_PLUGINDIR . "inc/tabs/$curr_tab.php";
                }
                ?>
        </div>
            <?php
        }

    }

    new WPPDL_ADMIN();
    