<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

define('IRPP_LICENSE_SERVER', 'https://intellywp.com/');
define('IRPP_EDD_NAME', 'Inline Related Posts PRO');

class IRPP_License {

    public function __construct() {
    }
    public function init() {
        //add_filter( 'cron_schedules', array( $this, 'add_schedules'   ) );
        //add_action( 'wp',             array( $this, 'schedule_Events' ) );
        add_action('admin_init', array($this, 'pluginUpdater'));
        add_action('irpp_daily_scheduled_events', array($this, 'checkLicense'));
    }

    function pluginUpdater() {
        global $irpp;
        $args=array(
            'version' => IRPP_PLUGIN_VERSION
            , 'license'=> $irpp->Options->getLicenseKey()
            , 'item_name' => IRPP_EDD_NAME
            , 'author' 	=> IRPP_PLUGIN_AUTHOR
        );
        $irppUpdater = new IRPP_EDD_SL_Plugin_Updater(IRPP_LICENSE_SERVER, IRPP_PLUGIN_FILE, $args);
    }

    //activate the new license key
    function activate($key) {
        global $irpp;

        $old=$irpp->Options->getLicenseKey();
        if($old!==FALSE && $old!='') {
            $this->deactivate();
        }

        $options = array(
            'edd_action'=> 'activate_license'
            , 'license'=> $key
            , 'item_name'=> urlencode(IRPP_EDD_NAME)
            , 'url'=> home_url()
        );
        $result=FALSE;
        $data=$irpp->Utils->remoteGet(IRPP_LICENSE_SERVER, $options);
        $irpp->Options->setLicense(FALSE);
        if($data!==FALSE && isset($data->license)) {
            $result=strtolower($data->license)=='valid';
            $irpp->Options->setLicense($data);
            $irpp->Options->setLicenseSuccess($result);
            if($result) {
                $irpp->Options->setLicenseKey($key);
            }
        }
        return $result;
    }

    //deactivate the installed license
    function deactivate() {
        global $irpp;

        // data to send in our API request
        $options = array(
            'edd_action'=> 'deactivate_license'
            , 'license'=> $irpp->Options->getLicenseKey()
            , 'item_name' => urlencode(IRPP_EDD_NAME) // the name of our product in EDD
            , 'url' => home_url()
        );
        $result=FALSE;
        $data=$irpp->Utils->remoteGet(IRPP_LICENSE_SERVER, $options);
        $irpp->Options->setLicense(FALSE);
        if($data!==FALSE && isset($data->license)) {
            $irpp->Options->setLicense($data);
            $irpp->Options->setLicenseKey('');
            $irpp->Options->setLicenseSuccess(FALSE);
            $result=TRUE;
        }
        return $result;
    }

    //retrieve if the current license used is stil valid or not
    public function hasPremium($override=FALSE) {
		if( lic_inline_zhk::is_activated() === true ) {
			return true ;
			   global $irpp;

        $result=FALSE;
        if($irpp->Options->getLicenseKey()=='') {
            $result=FALSE;
        } else {
            $check=$irpp->Options->getLicenseLastCheck();
            if(!$override && $check>strtotime('-1 day')) {
                $result=$irpp->Options->isLicenseSuccess();
            } else {
                $result=$this->check();
            }
        }
        return $result;
			} else {
			print "لطفا ابتدا با ثبت لایسنس دریافتی از سایت ژاکت محصول را فعال کنید" ;
			Exit() ;
		}
     
    }
    public function check() {
        global $irpp;

        $result=FALSE;
        if($irpp->Options->getLicenseKey()=='') {
            $result=FALSE;
        } else {
            $options = array(
                'edd_action' => 'check_license'
                , 'license' => $irpp->Options->getLicenseKey()
                , 'item_name' => urlencode(IRPP_EDD_NAME)
                , 'url' => home_url()
            );
            $irpp->Options->setLicense(FALSE);
            $data=$irpp->Utils->remoteGet(IRPP_LICENSE_SERVER, $options);
            if($data!==FALSE && isset($data->license)) {
                $irpp->Options->setLicense($data);
                if($data->license == 'valid') {
                    $irpp->Options->setLicenseSuccess(TRUE);
                    $result=TRUE;
                } else {
                    $irpp->Options->setLicenseSuccess(FALSE);
                }
                $irpp->Options->setLicenseLastCheck(time());
            }
        }
        return $result;
    }
}