<?php
if (!defined('ABSPATH')) exit;

class IRPP_MainTag extends IRPP_HTMLTag {
    public function __construct() {
        parent::__construct();
    }

    public function write(IRPP_HTMLContext $context) {
        global $irpp;
        foreach ($this->tags as $tag) {
            $tag->write($context);
        }

        //try to write the last box only if no boxes are written before
        //this prevent from inserting at the end a box due to tipically
        //marketer insert a CTA box (for instance download free book)
        if($irpp->Options->isRewriteAtEnd() && $irpp->Options->getRewriteBoxesWritten()==0) {
            $context->clearSkipNext();
            $context->setUncuttable(FALSE);
            $context->writeRelatedBox(TRUE);
        } elseif(!$irpp->Options->isRewriteAtEnd()) {
            $args=array('last'=>TRUE);
            $context->popRelatedBox($args);
        }
    }
}
