<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class IRPP_Manager {

    public function __construct() {

    }

    public function getRelatedPostsIds($args) {
        global $irpp;

        $ids=array();
        if(IRPP_DISABLE_RELATED || !$irpp->Options->isActive()) {
            return $ids;
        }

        $defaults=array('postId'=>0
            , 'posts'=>array(), 'cats'=>array(), 'tags'=>array()
            , 'count'=>10
            , 'shuffle'=>FALSE);
        $args=$irpp->Utils->parseArgs($args, $defaults);

        $args['posts']=$irpp->Utils->toCommaArray($args['posts']);
        $args['cats']=$irpp->Utils->toCommaArray($args['cats']);
        $args['tags']=$irpp->Utils->toCommaArray($args['tags']);
        $args['postId']=intval($args['postId']);
        if($args['postId']>0) {
            $options=array('orderby' => 'name', 'order' => 'ASC', 'fields' => 'ids');
            $args['tags']=wp_get_post_tags($args['postId'], $options);
            $args['cats']=wp_get_post_categories($args['postId']);
        }

        if(count($args['posts'])>0) {
            $ids=$args['posts'];
        } else {
            $ids=array();
            switch ($irpp->Options->getEngineSearch()) {
                case IRPP_ENGINE_SEARCH_CATEGORIES:
                    $ids=$this->queryRelatedPostsIds($args, 'category__in', $args['cats']);
                    break;
                case IRPP_ENGINE_SEARCH_TAGS:
                    $ids=$this->queryRelatedPostsIds($args, 'tag__in', $args['tags']);
                    break;
                case IRPP_ENGINE_SEARCH_CATEGORIES_TAGS:
                    //if we execute this query with the 2 parameters togheter category__in
                    //and tag__in WP do an AND query and not an OR query as we need
                    $cats=$this->queryRelatedPostsIds($args, 'category__in', $args['cats']);
                    $tags=$this->queryRelatedPostsIds($args, 'tag__in', $args['tags']);
                    $ids=array_merge($cats, $tags);
                    $ids=array_unique($ids);
                    break;
            }
        }

        if($args['shuffle']) {
            shuffle($ids);
        }
        return $ids;
    }

    private function queryRelatedPostsIds($args, $optionKey, $optionArray) {
        global $irpp;

        $ids=array();
        if(!is_array($optionArray) || count($optionArray)==0) {
            return $ids;
        }

        $postTypes = $irpp->Utils->getSelectedPostTypes();

        $post=$irpp->Options->getPostShown();
        $options=array(
            'post_type' => $postTypes //'post_type'=>$post->post_type
            //, 'nopaging'=>TRUE
            , 'posts_per_page'=>10
            , 'post_status'=>'publish'
            , 'post__not_in'=>array($post->ID)
            , 'orderby'=>'rand'
        );
        $days=$irpp->Options->getRewritePostsDays();
        if($days>0) {
            $options['date_query'] = array(
                'column' => 'post_date'
                , 'after' => '- '.$days.' days'
            );
        }
        $options[$optionKey]=$optionArray;

        $q=new WP_Query();
        $irpp->Log->debug('RELATED POSTS QUERY=%s', $options);
        $posts=$q->query($options);

        $irpp->Log->debug('RELATED POSTS RESULT COUNT=%s', count($posts));
        foreach($posts as $p) {
            if($args['postId']<=0 || $args['postId']!=$p->ID) {
                $ids[]=$p->ID;
            }
        }
        return $ids;
    }
}