<?php
function irpp_ui_tracking($override=FALSE) {
    global $irpp;
    if(!$irpp->License->hasPremium()) {
        return;
    }

    $track=$irpp->Utils->qs('track', '');
    if($track!='') {
        $track=intval($track);
        $irpp->Options->setTrackingEnable($track);
        $irpp->Tracking->sendTracking(TRUE);
    }

    $uri=IRPP_TAB_SETTINGS_URI.'&track=';
    if($irpp->Options->isTrackingEnable()) {
        if($override) {
            $uri.='0';
            $irpp->Options->pushSuccessMessage('EnableAllowTrackingNotice', $uri);
        }
    } else {
        $uri.='1';
        $irpp->Options->pushWarningMessage('DisableAllowTrackingNotice', $uri);
    }
    $irpp->Options->writeMessages();
}
function irpp_io_first_time() {
    global $irpp;
    if($irpp->Options->isShowActivationNotice()) {
        $irpp->Options->pushSuccessMessage('FirstTimeActivation');
        $irpp->Options->writeMessages();
        $irpp->Options->setShowActivationNotice(FALSE);
    }
}
function irpp_ui_box_preview() {
    global $irpp;

    $count=$irpp->Options->getRewritePostsInBoxCount();
    $count=$irpp->Utils->iqs('rewritePostsInBoxCount', $count);
    $args=array(
        'orderby'=>'rand'
        , 'numberposts'=>$count
    );

    $days=$irpp->Options->getRewritePostsDays();
    $days=$irpp->Utils->iqs('rewritePostsDays', $days);
    if($days>0) {
        $args['date_query'] = array(
            'column' => 'post_date'
            , 'after' => '- '.$days.' days'
        );
    }
    $posts=get_posts($args);
    $ids=array();
    foreach($posts as $p) {
        $ids[]=$p->ID;
    }
    if(count($ids)==0) {
        echo "<b>No posts available. Check settings and try again</b>";
        die();
    }

    $defaults=$irpp->Options->getTemplateStyle();
    $args=$irpp->Utils->aqs('template-', $defaults);
    $args['includeCss']=TRUE;
    $args['preview']=TRUE;
    $box=irpp_ui_get_box($ids, $args);
    echo $box;
    die();
}
function irpp_ui_settings() {
    global $irpp;
    irpp_ui_tracking(FALSE);

    ?>
    <script>
        var IRPP_preview=true;
        var IRPP_defaults={};
        <?php
            $defaults=$irpp->HtmlTemplate->getDefaults();
            foreach($defaults as $k=>$v) {
                $buffer='';
                foreach($v as $kk=>$vv) {
                    if($buffer!='') {
                        $buffer.=', ';
                    }

                    if(stripos($kk, 'label')!==FALSE) {
                        $vv=$irpp->Lang->L('Settings.Color.'.$vv);
                    } elseif(stripos($kk, 'color')!==FALSE) {
                        $vv=$irpp->Options->getColor($vv);
                    }

                    $buffer.=$kk.': "'.$vv.'"';
                }
                ?>
                IRPP_defaults["<?php echo $k?>"]={<?php echo $buffer?>};
            <?php }
        ?>

        function IRPP_changeRelatedBox() {
            if(!IRPP_preview) {
                return;
            }

            var t=IRPP_val('template-template');
            t=IRPP_defaults[t].borderColorLabel;
            jQuery('#template-borderColorLabel').text(t);

            data=IRPP_aval('template-');
            data=jQuery.extend({
                'action': 'do_action'
                , 'irpp_action': 'ui_box_preview'
                , 'rewritePostsDays': IRPP_val('irpRewritePostsDays')
            }, data);
            //console.log(data);

            var request=jQuery.ajax({
                url: ajaxurl
                , method: "POST"
                , data: data
                , dataType: "html"
            });

            request.done(function(html) {
                jQuery("#relatedBoxExample").html(html);
            });
        }

        jQuery(function() {
            var array=['irpRewritePostsDays', 'irpRewritePostsInBoxCount', 'irpRewriteBoxesCount'];
            for(i=0; i<array.length; i++) {
                if(jQuery('[name='+array[i]+']').length>0) {
                    jQuery('[name='+array[i]+']').change(function() {
                        IRPP_changeRelatedBox();
                    });
                }
            }
            jQuery("[name^='template-']").change(function() {
                var $self=jQuery(this);
                var name=$self.attr('name');
                if(name=='template-template') {
                    IRPP_preview=false;
                    t=IRPP_val('template-template');
                    t=IRPP_defaults[t];
                    jQuery.each(t, function(k,v) {
                        if(IRPP_stripos(k, 'color')!==false) {
                            var $k=jQuery('[name=template-'+k+']');
                            $k.select2("val", v);
                        }
                    });
                    IRPP_preview=true;
                }
                IRPP_changeRelatedBox();
            });
            IRPP_changeRelatedBox();
        });
    </script>
    <?php

    $c=wp_count_posts()->publish;
    $t=$irpp->Options->getMaxExecutionTime();
    if($t>0) {?>
        <p style="width:auto; font-style: italic;"><?php $irpp->Lang->P('PreviewSectionMaxTime', $t, $c)?></p>
    <?php }
	
	
	
    $irpp->Form->prefix='Settings';
    $irpp->Form->helps = FALSE;
    $irpp->Form->formStarts();
    //$irpp->Form->p('LicenseSection');
    //$irpp->Form->text('key', $irpp->Options->getLicenseKey());

    if($irpp->License->hasPremium() && $irpp->Check->nonce('irpp_settings')
        && $irpp->Utils->iqs('onlyLicense',0)==0) {

        $irpp->Options->resetMaxExecutionTime();
        $irpp->Options->setActive($irpp->Utils->iqs('irpActive'));

        $defaults=array(
            'hasShadow'=>0
            , 'hasPoweredBy'=>0
        );
        $template=$irpp->Utils->aqs('template-', $defaults);
        $irpp->Options->setTemplateStyle($template);

        $irpp->Options->setMarginTop($irpp->Utils->qs('marginTop', '0em'));
        $irpp->Options->setMarginBottom($irpp->Utils->qs('marginBottom', '1em'));

        $irpp->Options->setRewriteActive($irpp->Utils->iqs('irpRewriteActive'));
        $irpp->Options->setRewriteBoxesCount($irpp->Utils->iqs('irpRewriteBoxesCount', 1));
        //$irpp->Options->setRewritePostsInBoxCount($irpp->Utils->iqs('irpRewritePostsInBoxCount', 1));
        $irpp->Options->setRewritePostsDays($irpp->Utils->iqs('irpRewritePostsDays', 0));
        $irpp->Options->setRewriteThreshold($irpp->Utils->iqs('irpRewriteThreshold', 300));
        $irpp->Options->setHookPriority($irpp->Utils->iqs('irpHookPriority', 99999));
        $irpp->Options->setClassDivExclude($irpp->Utils->qs('irpClassDivExclude', ''));
        $irpp->Options->setRewriteAtEnd($irpp->Utils->iqs('irpRewriteAtEnd'));

        $irpp->Options->setEngineSearch($irpp->Utils->iqs('irpEngineSearch', IRPP_ENGINE_SEARCH_CATEGORIES_TAGS));

        $options = $irpp->Options->getRewritePostTypes();
        foreach ($options as $k => $template) {
            $template = intval($irpp->Utils->qs('irpRewritePostType_' . $k, 0));
            $options[$k] = $template;
        }
        $irpp->Options->setRewritePostTypes($options);

        $options = $irpp->Options->getMetaboxPostTypes();
        foreach ($options as $k => $template) {
            $template = intval($irpp->Utils->qs('metabox_' . $k, 0));
            $options[$k] = $template;
        }
        $irpp->Options->setMetaboxPostTypes($options);
    }

    if($irpp->License->hasPremium()) {
        $irpp->Form->p('GeneralSection');
        $args=array(
            'class'=>'irpp-hideShow irpp-checkbox'
            , 'irpp-hideIfTrue'=>'false'
            , 'irpp-hideShow'=>'irpp-active-box'
        );
        $irpp->Form->checkbox('irpActive', $irpp->Options->isActive(), 1, $args);
        $args=array(
            'id'=>'irpp-active-box'
            , 'name'=>'irpp-active-box'
            , 'style'=>'margin-top:10px;'
        );
        $irpp->Form->divStarts($args);
        {
            $template=$irpp->Options->getTemplateStyle();
            $prefix='template-';
            $irpp->Form->text($prefix.'ctaText', $irpp->Utils->get($template, 'ctaText'));
            $options=$irpp->HtmlTemplate->getTemplatesNames();
            $irpp->Form->select($prefix.'template', $irpp->Utils->get($template, 'template'), $options);
            $irpp->Form->number($prefix.'boxOpacity', $irpp->Utils->get($template, 'boxOpacity'));
            $irpp->Form->text('marginTop', $irpp->Options->getMarginTop());
            $irpp->Form->text('marginBottom', $irpp->Options->getMarginBottom());
            //$options=array('none', 'capitalize', 'uppercase', 'lowercase');
            //$irpp->Form->select($t.'textTransform', $irpp->Utils->get($v, 'textTransform'), $options);
            $array=array('ctaTextColor', 'postTitleColor', 'boxColor', 'borderColor');
            $blanks=array('(Default)', '(Default)', '(Trasparent)', '(Without)');
            for($i=0; $i<count($array); $i++) {
                $k=$array[$i];
                $v=$blanks[$i];
                $colors=$irpp->Options->getColors($v);

                $v=$irpp->Utils->get($template, $k);
                $v=$irpp->Options->getColor($v);
                $irpp->Form->colorSelect($prefix.$k, $v, $colors);
            }
            $array=array('hasShadow', 'hasPoweredBy');
            foreach($array as $k) {
                $irpp->Form->checkbox($prefix.$k, $irpp->Utils->iget($template, $k));
            }
            ?>
            <div style="padding-left:10px; padding-right:10px; border:1px dashed #444444">
                <?php $irpp->Form->p('PreviewSection'); ?>
                <p id="relatedBoxExample" style="width:auto;"></p>
            </div>
            <?php
            $irpp->Form->p('RewriteSection');
            $args=array(
                'class'=>'irpp-hideShow irpp-checkbox'
                , 'irpp-hideIfTrue'=>'false'
                , 'irpp-hideShow'=>'irpp-rewrite-box'
            );
            $irpp->Form->checkbox('irpRewriteActive', $irpp->Options->isRewriteActive(), 1, $args);
            $args=array('id'=>'irpp-rewrite-box', 'name'=>'irpp-rewrite-box', 'style'=>'margin-top:10px;');
            $irpp->Form->divStarts($args);
            {
                $irpp->Form->number('irpRewriteBoxesCount', $irpp->Options->getRewriteBoxesCount());
                $irpp->Form->number('irpRewritePostsDays', $irpp->Options->getRewritePostsDays());
                $irpp->Form->number('irpRewriteThreshold', $irpp->Options->getRewriteThreshold(), $args);
				
                $irpp->Form->number('irpHookPriority', $irpp->Options->getHookPriority());

                $irpp->Form->textarea('irpClassDivExclude', $irpp->Options->getClassDivExclude(), array('rows'=>5));
				
                $irpp->Form->checkbox('irpRewriteAtEnd', $irpp->Options->isRewriteAtEnd());
                $irpp->Form->p('');

                $options=$irpp->Options->getRewritePostTypes();
                $types=$irpp->Utils->query(IRPP_QUERY_POST_TYPES);
                foreach($types as $v) {
                    $v=$v['name'];
                    $irpp->Form->checkbox('irpRewritePostType_'.$v, $options[$v]);
                }
            }
            $irpp->Form->divEnds();

            $irpp->Form->p('EngineSection');
            $irpp->Form->divStarts();
            {
                $options=array(
                    IRPP_ENGINE_SEARCH_CATEGORIES_TAGS
                    , IRPP_ENGINE_SEARCH_CATEGORIES
                    , IRPP_ENGINE_SEARCH_TAGS
                );
                $irpp->Form->select('irpEngineSearch', $irpp->Options->getEngineSearch(), $options);
                $options=array();
                $options[]=array('id'=>'follow', 'name'=>'follow');
                $options[]=array('id'=>'dofollow', 'name'=>'dofollow');
                $k='linkRel';

                $irpp->Form->select($prefix.$k, $irpp->Utils->get($template, $k), $options);
                $options=array();
                $options[]=array('id'=>'_blank', 'name'=>'_blank');
                $options[]=array('id'=>'_self', 'name'=>'_self');
                $k='linkTarget';
                $irpp->Form->select($prefix.$k, $irpp->Utils->get($template, $k), $options);
            }
            $irpp->Form->divEnds();

            $irpp->Form->p('MetaboxSection');
            $irpp->Form->divStarts();
            {
                $metaboxes=$irpp->Options->getMetaboxPostTypes();
                $types=$irpp->Utils->query(IRPP_QUERY_POST_TYPES);
                foreach($types as $template) {
                    $template=$template['name'];
                    $irpp->Form->checkbox('metabox_'.$template, $metaboxes[$template]);
                }
            }
            $irpp->Form->divEnds();
        }
        $irpp->Form->divEnds();
    } else {
        $irpp->Form->hidden('onlyLicense', 1);
    }

    $irpp->Form->nonce('irpp_settings');
    $irpp->Form->submit('Save');
    $irpp->Form->formEnds(false);
    $irpp->Form->helps=FALSE;

	$args=array('id'=>'irpp-sidebar', 'style'=>'float:left; max-width: 250px; margin-left:10px');
	$irpp->Form->divStarts($args);

	$count=$irpp->Tabs->getPluginsCount();
	$plugins=array();
	while(count($plugins)<1) {
		$id=rand(1, $count);
		if(!isset($plugins[$id])) {
			$plugins[$id]=$id;
		}
	}

	$count=$irpp->Tabs->drawContactUsWidget();
	foreach($plugins as $id) {
		$count=$irpp->Tabs->drawPluginWidget($id);
	}

    $irpp->Form->divEnds();
	
}
function irpp_notice_pro_features() {
    global $irpp;

    ?>
    <br/>
    <div class="message updated below-h2" style="max-width:600px;">
        <div style="height:10px;"></div>
        <?php
        $i=1;
        while($irpp->Lang->H('Notice.ProHeader'.$i)) {
            $irpp->Lang->P('Notice.ProHeader'.$i);
            echo '<br/>';
            ++$i;
        }
        $i=1;
        ?>
        <br/>
        <?php
        /*
        $options = array('public' => TRUE, '_builtin' => FALSE);
        $q=get_post_types($options, 'names');
        if(is_array($q) && count($q)>0) {
            sort($q);
            $q=implode(', ', $q);
            $q='(<b>'.$q.'</b>)';
        } else {
            $q='';
        }*/

        while($irpp->Lang->H('Notice.ProFeature'.$i)) { ?>
            <div style="clear:both; margin-top: 2px;"></div>
            <div style="float:left; vertical-align:middle; height:24px; margin-right:5px;">
                <img src="<?php echo IRPP_PLUGIN_IMAGES?>tick.png" />
            </div>
            <div style="float:left; vertical-align:middle; height:24px;">
                <?php $irpp->Lang->P('Notice.ProFeature'.$i)?>
            </div>
            <?php ++$i;
        }
        ?>
        <div style="clear:both;"></div>
        <div style="height:10px;"></div>
    </div>
    <br/>
<?php }
