<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('init', 'irpp_do_action');
add_action('wp_ajax_do_action', 'irpp_do_action');
function irpp_do_action() {
    global $irpp;
    
    $action = $irpp->Utils->qs('irpp_action');
    $irpp->Log->info('[actions::irpp_do_action] Action: %s', $action);
    switch($action) {
        case 'ui_button_editor':
            call_irpp_ui_button_editor($irpp);
            break;
        case 'ui_box_preview':
            call_irpp_ui_box_preview($irpp);
            break;
        case 'manager_trackingOn':
            call_irpp_manager_trackingOn($irpp);
            break;
        case 'manager_trackingOff':
            call_irpp_manager_trackingOff($irpp);         
            break;
        case '':
            break; // blank strings are okay. We just want to ignore them.
        default:
            $irpp->Log->fatal('Attempting to execute unknown function %s', $action);
            break;
    }
}

function call_irpp_ui_button_editor($irpp)
{
    if (current_user_can('edit_posts')
        || current_user_can('edit_pages')
        || current_user_can('edit_published_posts')
        || current_user_can('edit_published_pages')
        || current_user_can('edit_others_posts')
        || current_user_can('edit_others_pages')
        || current_user_can('edit_private_posts')
        || current_user_can('edit_private_pages')
        ) {
        irpp_ui_button_editor();
    }
}

function call_irpp_ui_box_preview($irpp)
{
    if (current_user_can('activate_plugins')) {
        irpp_ui_box_preview();
    }
}

function call_irpp_manager_trackingOn($irpp)
{
    if (current_user_can('activate_plugins')) {
        $irpp->Tracking->enableTracking();
    }
}

function call_irpp_manager_trackingOff($irpp)
{
    if (current_user_can('activate_plugins')) {
        $irpp->Tracking->disableTracking();
    }
}
