<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $wpdb;
?>

<div class="status-user-widget">
<div class="row">

		<div class="col-12 col-sm-12 col-md-4">
			<div class="user_info_ds user_cm"><i class="fal fa-cabinet-filing"></i><p>تعداد کل محصولات : <span>
				<?php

				function product_count_shortcode( ) {
				$count_posts = wp_count_posts( 'product' );
				return $count_posts->publish;
				}
					add_shortcode( 'product_count', 'product_count_shortcode' );
					echo do_shortcode('[product_count]');
					?>
			</span></p></div>
		</div>

		<div class="col-12 col-sm-12 col-md-4">
			<div class="user_info_ds user_order"><i class="fal fa-shopping-bag"></i><p>محصول خریداری شده : <span>
				<?php
					// GET USER ORDERS (COMPLETED + PROCESSING)
					$customer_orders = get_posts( array(
							'numberposts' => -1,
							'meta_key'    => '_customer_user',
							'meta_value'  => $current_user->ID,
							'post_type'   => wc_get_order_types(),
					'post_status' => array('wc-completed'),
					) );


					// LOOP THROUGH ORDERS AND GET PRODUCT IDS
					$product_ids = array();
					foreach ( $customer_orders as $customer_order ) {
							$order = new WC_Order( $customer_order->ID );
							$items = $order->get_items();
							foreach ( $items as $item ) {
									$product_id = $item->get_product_id();
									$product_ids[] = $product_id;
							}
					}
					$product_ids = array_unique( $product_ids );

					// QUERY PRODUCTS
					$args = array(
						 'post_type' => 'product',
						 'post__in' => $product_ids,
					);

					echo count( $product_ids );
				?>
			</span></p></div>
		</div>

		<div class="col-12 col-sm-12 col-md-4">
			<div class="user_info_ds user_wallet"><i class="fal fa-wallet"></i><p>کیف پول : <span><span class="woocommerce-Price-amount amount">
				<?php


				if ( is_plugin_active( 'woo-wallet/woo-wallet.php' ) ) {

					$title  = __( 'Current wallet balance', 'woo-wallet' );
					$menu_item  = '<a class="woo-wallet-menu-contents" href="' . esc_url( wc_get_account_endpoint_url( get_option( 'woocommerce_woo_wallet_endpoint', 'woo-wallet' ) ) ) . '" title="' . $title . '">';
					$menu_item .= woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
					$menu_item .= '</a>';

					echo $menu_item;
					} else {
						echo '<span class="wc-Symbol">0 تومان</span>';
					}
				?>
			</span></span></p></div>
		</div>
</div>
</div>



<?php $loop = new WP_Query(
	array(
		'post_type' => 'slider',
		'posts_per_page' => -1,
		'orderby'=> 'ASC'));
	?>

<?php if($loop->have_posts()): ?>
<div class="slider-posts-holder">
		<div class="owl-carousel" data-autoplay="true" data-slider-items="1" data-pagination="true" data-navigation="true" data-loop="ture">
				<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
							<?php get_template_part( '/inc/templates/slider-content' ); ?>
					<?php endwhile; ?>
		</div> <!-- End the Recent Post div -->
</div>
<?php endif;
wp_reset_postdata();
?>
<div class="row">
<div class="col-12 col-sm-12 col-md-6">
	<div class="product-reviews dash-box">
		<div class="product-review-title">
      	<h3 class="inner">آخرین مقالات</h3>
    </div>
		<div class="dash-inner">
		  <ul class="dash-blog">
					<?php $the_query = new WP_Query( 'posts_per_page=5' ); ?>

					<?php while ($the_query -> have_posts()) : $the_query -> the_post(); ?>

						<li><a href="<?php the_permalink() ?>"><?php the_post_thumbnail('img-120-120'); ?><?php the_title(); ?></a></li>

						<?php
					endwhile;
					wp_reset_postdata();
					?>
		  </ul>
		</div>
  </div>
</div>

<div class="col-12 col-sm-12 col-md-6">
	<div class="product-reviews dash-box">
		<div class="product-review-title">
      	<h3 class="inner">جدیدترین محصولات</h3>
    </div>
		<div class="dash-inner">
			<?php $dash_product = new WP_Query(
				array(
					'post_type' => 'product',
					'posts_per_page' => 5,
					'orderby'=> 'ASC'));
				?>
				<ul class="dash-blog">

						<?php while ($dash_product -> have_posts()) : $dash_product -> the_post(); ?>

							<li><a href="<?php the_permalink() ?>"><?php the_post_thumbnail(''); ?><?php the_title(); ?></a></li>

							<?php
						endwhile;
						wp_reset_postdata();
						?>
				</ul>
		</div>
  </div>
</div>
</div>


<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
