<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );
$related_courses_display = true;
if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
$course_sidebar = 'right';
$course_advice = true;
if ( class_exists('Redux') ) {
	$course_advice = codebean_option('course_advice');
	$course_share_story = codebean_option('course_share_story');
	$related_courses_display = codebean_option('related_courses_display');
	$course_sidebar = codebean_option('course_single_sidebar_position');
	$course_detail_reviews = codebean_option('course_detail_reviews');
}
$rating_enabled = get_option('woocommerce_enable_review_rating');

$course_single_sidebar_position = isset($_GET['sidebar']) ? $_GET['sidebar'] : $course_sidebar;

$course_container_classes = array('row');

if ( $course_single_sidebar_position == 'left' || $course_single_sidebar_position == 'right' ) {
	$course_container_classes[] = 'has-sidebar';
}

if ( $course_single_sidebar_position == 'left' ) {
	$course_container_classes[] = 'sidebar-left';
} elseif ( $course_single_sidebar_position == 'right' ) {
	$course_container_classes[] = 'sidebar-right';
}

// Custom Meta
$prefix = '_studiare_';
$teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );
$course_video = get_post_meta(get_the_ID(), $prefix . 'course_video', true);
$course_disable_image = get_post_meta(get_the_ID(), $prefix . 'course_disable_image', true);
$poster_video_coures = get_post_meta(get_the_ID(), $prefix . 'poster_video_coures', true);
$stock = get_post_meta( get_the_ID(), '_stock', true );
$location_google_map = get_post_meta(get_the_ID(), $prefix . 'location_google_map', true);
global $product;

?>




<div id="product-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="<?php echo esc_attr( implode( ' ', $course_container_classes ) ); ?>">

        <div class="product-single-main">

            <!-- Product Top Part-->
            <div class="product-single-top-part">

                <!-- Product Gallery -->
                <div class="course-single-gallery">

					<?php if ( $course_disable_image ) : ?>
						<?php
							$attr =  array(
							'mp4'      => $course_video,
							'poster'   => $poster_video_coures,
							'preload'  => 'none',
							'width'    => '1200',
							'height'   => '700'
							);
								echo wp_video_shortcode(  $attr );
						?>
				<?php else: ?>
					<?php wc_get_template( 'single-product/product-image.php' ); ?>
				<?php endif; ?>

                </div>
  
            <div class="theiaStickySidebar" style="width: 25%;">
                <?php wc_get_template_part('content-single-product-meta-side'); ?>

   

            </div>
    
            </div>


            <div class="product-single-meta-inside">
                <?php wc_get_template_part( 'content', 'single-product-meta-side-mob' ); ?>
            </div>


            <?php  wc_get_template( 'single-product/tabs/tabs.php' ); ?>

<?php
$extra_content = get_post_meta(get_the_ID(), $prefix . 'extra_content', true);
?>
    
    
  
    
    <?php do_action( 'woocommerce_single_product_countdown' ); ?>
	<?php if ( $extra_content ) : ?>
<div class="product-single-content" style="padding:20px;">
    
    

    <div id="News" class="tabcontent">

    <?php
 mb_internal_encoding('UTF-8');  
 echo  mb_substr($extra_content,0,640)
?> 
<button class="tablink" onclick="openPage('Contact', this, 'blue')">مشاهده کامل</button>
</div>

<div id="Contact" class="tabcontent">

<?php echo($extra_content); ?>
<button class="tablink" onclick="openPage('News', this, 'green')" id="defaultOpen">برگشت</button>
</div>


<script>
function openPage(pageName,elmnt,color) {
  var i, tabcontent, tablinks;
  tabcontent = document.getElementsByClassName("tabcontent");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }
  tablinks = document.getElementsByClassName("tablink");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].style.backgroundColor = "";
  }
  document.getElementById(pageName).style.display = "block";
  elmnt.style.backgroundColor = color;
}
document.getElementById("defaultOpen").click();
</script>

    </div>
	<?php endif; ?>
    
    


			<?php echo wc_get_product_tag_list( $product->get_id(), '  ', '<div class="product-single-content"><span class="tagged_as"><i class="fal fa-tags"></i>' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'woocommerce' ) . ' ', '</span></div>' ); ?>

			<?php if ( $related_courses_display ) : ?>
			<?php get_template_part( '/inc/templates/woocommerce/related' ); ?>
			<?php endif; ?>

        </div>
  

		<?php
		$current_user = wp_get_current_user();
								if ( wc_customer_bought_product( $current_user->user_email, $current_user->ID, $product->get_id())) {
									echo '<div class="sticky-add-to-cart">';
									echo '</div>';
								}
								else {
									do_action( 'woocommerce_sticky_add_to_cart' );
								}
		?>

	</div>
</div>
<?php do_action( 'woocommerce_after_single_product_summary' ); ?>

<?php do_action( 'woocommerce_after_single_product' ); ?>
