<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$prefix = '_studiare_';
$course_video = get_post_meta(get_the_ID(), $prefix . 'course_video', true);
$course_disable_image = get_post_meta(get_the_ID(), $prefix . 'course_disable_image', true);
$poster_video_coures = get_post_meta(get_the_ID(), $prefix . 'poster_video_coures', true);

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

add_filter( 'excerpt_length', 'studiare_product_custom_excerpt_length', 999 );

// Custom Meta
$sale_price = $product->get_sale_price();
$regular_price = $product->get_regular_price();
$prefix = '_studiare_';
$teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );
$stock = get_post_meta( get_the_ID(), '_stock', true );

$courses_cart_loop = true;
$courses_teacher_loop = true;
$course_students = true;
$courses_rating_loop = true;
if ( class_exists( 'Redux' ) ) {
	$course_students = codebean_option('course_students');
	$course_video_loop = codebean_option('course_video_loop');
	$courses_rating_loop = codebean_option('courses_rating_loop');
	$courses_teacher_loop = codebean_option('courses_teacher_loop');
}

if ( function_exists( 'dokan' ) ) {
$product_id = is_callable( array( $product, 'get_id' ) ) ? $product->get_id() : $product->ID;
$user_id = get_post_field( 'post_author', $product_id );
$store_user = get_user_by( 'id', $user_id );
$store_info = dokan_get_store_info( $store_user->ID );
}
?>
<div class="swiper-slide">
	<div class="card">
<div <?php post_class( 'course-item' ); ?>>

<!--    --><?php //do_action( 'woocommerce_before_shop_loop_item' ); ?>
<div class="course-item-inner">



<?php if ( ( $course_disable_image ) && ( $course_video_loop == true ) ) : ?>

<?php
	$attr =  array(
	'mp4'      => $course_video,
	'poster'   => $poster_video_coures,
	'preload'  => 'none',
	'width'    => '585',
	'height'   => '340'
	);
	echo wp_video_shortcode(  $attr );
?>
<div class="course-item-sale">
<?php
					global $product;

						if ( $product->is_on_sale() ) {

						if ( ! $product->is_type( 'variable' ) ) {

						$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;

						} else {

							$max_percentage = 0;

							foreach ( $product->get_children() as $child_id ) {
							$variation = wc_get_product( $child_id );
							$price = $variation->get_regular_price();
							$sale = $variation->get_sale_price();
							if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
							if ( $percentage > $max_percentage ) {
							$max_percentage = $percentage;
							}
							}

						}
						echo "<div class='sale-perc-badge'>";
						echo "<div class='sale-perc'>" . round($max_percentage) . "% </div>";
						echo "</div>";
						}
					?>
	</div>
<?php else: ?>
	<?php if ( has_post_thumbnail( ) ) : ?>
				<div class="course-thumbnail-holder">
						<?php woocommerce_template_loop_product_link_open(); ?>
								<span class="image-item">
				<?php do_action( 'woocommerce_single_product_countdown_loop' ); ?>
										<?php woocommerce_template_loop_product_thumbnail(); ?>
								</span>

						<?php woocommerce_template_loop_product_link_close(); ?>

					<?php
					global $product;

						if ( $product->is_on_sale() ) {

						if ( ! $product->is_type( 'variable' ) ) {

						$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;

						} else {

							$max_percentage = 0;

							foreach ( $product->get_children() as $child_id ) {
							$variation = wc_get_product( $child_id );
							$price = $variation->get_regular_price();
							$sale = $variation->get_sale_price();
							if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
							if ( $percentage > $max_percentage ) {
							$max_percentage = $percentage;
							}
							}

						}
						echo "<div class='sale-perc-badge'>";
						echo "<div class='sale-perc'>" . round($max_percentage) . "% </div>";
						echo "</div>";
						}
					?>
				</div>
	<?php endif; ?>

<?php endif; ?>


		<div class="course-content-holder">


				<div class="course-content-main">
						<h3 class="course-title">
								<a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
						</h3>

						<div class="post-author clearfix">
								<?php
								$author_id = $products->post->post_author;
								if ( function_exists( 'dokan' ) ) {
										echo get_avatar( $store_user->ID, 26 );
									 do_action( 'seller-name-alt' );
								} else {
									echo get_avatar( $author_id, 26 );
									echo '<h5 class="author">' . get_the_author_meta( 'display_name', $author_id ) . '</h5>';
								}
								?>
						</div>

						<div class="course-price">
							<?php woocommerce_template_loop_price(); ?>
						</div>

				</div>

				<div class="course-content-bottom">

						<div class="course-students">
							<?php if ( $course_students ) : ?>
								<i class="fa fa-download"></i><span><?php $count = get_post_meta(get_the_ID(),'total_sales', true); $text = sprintf( _n( '%s فروش', '%s فروش', $count, 'wpdocs_textdomain' ), number_format_i18n($count));echo $text;  ?>
							<?php endif; ?>
						</div>


									<?php woocommerce_template_loop_add_to_cart(); ?>
				</div>
		</div>
</div>
</div>

</div>
</div>
