<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$prefix = '_studiare_';
$download_icon = get_post_meta( get_the_ID(), $prefix . 'download_icon', 1 ) ;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

add_filter( 'excerpt_length', 'studiare_product_custom_excerpt_length', 999 );

// Custom Meta
$sale_price = $product->get_sale_price();
$regular_price = $product->get_regular_price();
$prefix = '_studiare_';
$teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );
$stock = get_post_meta( get_the_ID(), '_stock', true );


if ( function_exists( 'dokan' ) ) {
$product_id = is_callable( array( $product, 'get_id' ) ) ? $product->get_id() : $product->ID;
$user_id = get_post_field( 'post_author', $product_id );
$store_user = get_user_by( 'id', $user_id );
$store_info = dokan_get_store_info( $store_user->ID );
}


// دسته بندی در کاور محصولات //
	if( ! function_exists( 'gigafile_product_categories' ) ) {
	function gigafile_product_categories() {
		global $post, $product;
		?><div class="cover-cats">
			<span>دسته بندی:</span>
                <?php
                    echo strip_tags (wc_get_product_category_list( $product->get_id(), ' / ' ) );
                ?>
            </div>
		<?php
	}
}
// دسته بندی در کاور محصولات //

$thumb_id = get_post_thumbnail_id();
$thumb_url = wp_get_attachment_image_src($thumb_id,'full-thumbnail', true);
?>
<div <?php post_class( 'course-item' ); ?>>

<!--    --><?php //do_action( 'woocommerce_before_shop_loop_item' ); ?>

<div class="mini-icon-item-inner">
 <ul class="products mini-icon">
	<li>
	</li>
	<a target='_blank' href='<?php the_permalink(); ?>' class='index__product rtltheme_product' style="color:white"
		title='<?php the_title(); ?>' data-image='<?php echo $thumb_url[0]; ?>'  data-title='<?php the_title(); ?>' data-category='<?php gigafile_product_categories(); ?>' data-price="<?php echo the_dramatist_price_show(); ?>">
		<img src="<?php echo esc_url( $download_icon ); ?>">
	</a>
	</ul>
</div>
</div>
